/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.persistence.util;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public enum DiffState {
    NEW,
    MODIFIED,
    REMOVED;


    public static DiffStateMap newMap() {
        DiffStateMap result = new DiffStateMap();
        for (DiffState state : DiffState.values()) {
            result.put(state, new ArrayList());
        }
        return result;
    }

    public static void addAll(DiffStateMap mainMap, DiffStateMap toAdd) {
        for (DiffState state : DiffState.values()) {
            List newList = (List)toAdd.get((Object)state);
            if (newList == null || newList.isEmpty()) continue;
            ((List)mainMap.get((Object)state)).addAll(newList);
        }
    }

    public static void clear(DiffStateMap mainMap) {
        for (DiffState state : DiffState.values()) {
            List newList = (List)mainMap.get((Object)state);
            if (newList != null) {
                newList.clear();
            }
            mainMap.remove((Object)state);
        }
    }

    public static void removeEmptyStates(DiffStateMap mainMap) {
        for (DiffState state : DiffState.values()) {
            List newList = (List)mainMap.get((Object)state);
            if (newList != null && !newList.isEmpty()) continue;
            mainMap.remove((Object)state);
        }
    }

    public static class DiffStateMap
    extends EnumMap<DiffState, List<String>> {
        private static final long serialVersionUID = 1L;

        public DiffStateMap() {
            super(DiffState.class);
        }

        public DiffStateMap(EnumMap<DiffState, ? extends List<String>> m) {
            super(m);
        }

        public DiffStateMap(Map<DiffState, ? extends List<String>> m) {
            super(m);
        }
    }
}

