/*
 * Decompiled with CFR 0.152.
 */
package jregex;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import jregex.MatchResult;
import jregex.Matcher;
import jregex.Pattern;
import jregex.PerlSubstitution;
import jregex.Substitution;
import jregex.TextBuffer;

public class Replacer {
    private Pattern pattern;
    private Substitution substitution;

    public Replacer(Pattern pattern, Substitution substitution) {
        this.pattern = pattern;
        this.substitution = substitution;
    }

    public Replacer(Pattern pattern, String string) {
        this(pattern, string, true);
    }

    public Replacer(Pattern pattern, String string, boolean bl) {
        this.pattern = pattern;
        this.substitution = bl ? new PerlSubstitution(string) : new DummySubstitution(string);
    }

    public void setSubstitution(String string, boolean bl) {
        this.substitution = bl ? new PerlSubstitution(string) : new DummySubstitution(string);
    }

    public String replace(String string) {
        TextBuffer textBuffer = Replacer.wrap(new StringBuffer(string.length()));
        Replacer.replace(this.pattern.matcher(string), this.substitution, textBuffer);
        return textBuffer.toString();
    }

    public String replace(char[] cArray, int n, int n2) {
        TextBuffer textBuffer = Replacer.wrap(new StringBuffer(n2));
        Replacer.replace(this.pattern.matcher(cArray, n, n2), this.substitution, textBuffer);
        return textBuffer.toString();
    }

    public String replace(MatchResult matchResult, int n) {
        TextBuffer textBuffer = Replacer.wrap(new StringBuffer());
        Replacer.replace(this.pattern.matcher(matchResult, n), this.substitution, textBuffer);
        return textBuffer.toString();
    }

    public String replace(Reader reader, int n) throws IOException {
        TextBuffer textBuffer = Replacer.wrap(new StringBuffer(n >= 0 ? n : 0));
        Replacer.replace(this.pattern.matcher(reader, n), this.substitution, textBuffer);
        return textBuffer.toString();
    }

    public int replace(String string, StringBuffer stringBuffer) {
        return Replacer.replace(this.pattern.matcher(string), this.substitution, Replacer.wrap(stringBuffer));
    }

    public int replace(char[] cArray, int n, int n2, StringBuffer stringBuffer) {
        return this.replace(cArray, n, n2, Replacer.wrap(stringBuffer));
    }

    public int replace(MatchResult matchResult, int n, StringBuffer stringBuffer) {
        return this.replace(matchResult, n, Replacer.wrap(stringBuffer));
    }

    public int replace(MatchResult matchResult, String string, StringBuffer stringBuffer) {
        return this.replace(matchResult, string, Replacer.wrap(stringBuffer));
    }

    public int replace(Reader reader, int n, StringBuffer stringBuffer) throws IOException {
        return this.replace(reader, n, Replacer.wrap(stringBuffer));
    }

    public int replace(String string, TextBuffer textBuffer) {
        return Replacer.replace(this.pattern.matcher(string), this.substitution, textBuffer);
    }

    public int replace(char[] cArray, int n, int n2, TextBuffer textBuffer) {
        return Replacer.replace(this.pattern.matcher(cArray, n, n2), this.substitution, textBuffer);
    }

    public int replace(MatchResult matchResult, int n, TextBuffer textBuffer) {
        return Replacer.replace(this.pattern.matcher(matchResult, n), this.substitution, textBuffer);
    }

    public int replace(MatchResult matchResult, String string, TextBuffer textBuffer) {
        return Replacer.replace(this.pattern.matcher(matchResult, string), this.substitution, textBuffer);
    }

    public int replace(Reader reader, int n, TextBuffer textBuffer) throws IOException {
        return Replacer.replace(this.pattern.matcher(reader, n), this.substitution, textBuffer);
    }

    public static int replace(Matcher matcher, Substitution substitution, TextBuffer textBuffer) {
        boolean bl = true;
        int n = 0;
        while (matcher.find()) {
            if (matcher.end() == 0 && !bl) continue;
            if (matcher.start() > 0) {
                matcher.getGroup(-1, textBuffer);
            }
            substitution.appendSubstitution(matcher, textBuffer);
            ++n;
            matcher.setTarget(matcher, -2);
            bl = false;
        }
        matcher.getGroup(-3, textBuffer);
        return n;
    }

    public static int replace(Matcher matcher, Substitution substitution, Writer writer) throws IOException {
        try {
            return Replacer.replace(matcher, substitution, Replacer.wrap(writer));
        }
        catch (WriteException writeException) {
            throw writeException.reason;
        }
    }

    public void replace(String string, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(string), this.substitution, writer);
    }

    public void replace(char[] cArray, int n, int n2, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(cArray, n, n2), this.substitution, writer);
    }

    public void replace(MatchResult matchResult, int n, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(matchResult, n), this.substitution, writer);
    }

    public void replace(MatchResult matchResult, String string, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(matchResult, string), this.substitution, writer);
    }

    public void replace(Reader reader, int n, Writer writer) throws IOException {
        Replacer.replace(this.pattern.matcher(reader, n), this.substitution, writer);
    }

    public static TextBuffer wrap(final StringBuffer stringBuffer) {
        return new TextBuffer(){

            public void append(char c) {
                stringBuffer.append(c);
            }

            public void append(char[] cArray, int n, int n2) {
                stringBuffer.append(cArray, n, n2);
            }

            public void append(String string) {
                stringBuffer.append(string);
            }

            public String toString() {
                return stringBuffer.toString();
            }
        };
    }

    public static TextBuffer wrap(final Writer writer) {
        return new TextBuffer(){

            public void append(char c) {
                try {
                    writer.write(c);
                }
                catch (IOException iOException) {
                    throw new WriteException(iOException);
                }
            }

            public void append(char[] cArray, int n, int n2) {
                try {
                    writer.write(cArray, n, n2);
                }
                catch (IOException iOException) {
                    throw new WriteException(iOException);
                }
            }

            public void append(String string) {
                try {
                    writer.write(string);
                }
                catch (IOException iOException) {
                    throw new WriteException(iOException);
                }
            }
        };
    }

    private static class WriteException
    extends RuntimeException {
        IOException reason;

        WriteException(IOException iOException) {
            this.reason = iOException;
        }
    }

    private static class DummySubstitution
    implements Substitution {
        String str;

        DummySubstitution(String string) {
            this.str = string;
        }

        public void appendSubstitution(MatchResult matchResult, TextBuffer textBuffer) {
            if (this.str != null) {
                textBuffer.append(this.str);
            }
        }
    }
}

