/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.processor;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.nuiton.processor.filters.Filter;

public class ProcessorReader
extends LineNumberReader {
    protected LineNumberReader input;
    protected Filter filter;
    protected String lineSeparator;

    protected ProcessorReader() {
        super(new StringReader(""));
    }

    public int getLineNumber() {
        return this.input.getLineNumber();
    }

    public void setLineNumber(int lineNumber) {
        this.input.setLineNumber(lineNumber);
    }

    public ProcessorReader(LineNumberReader input, Filter filter) {
        this();
        this.setInput(input);
        this.setFilter(filter);
        this.lineSeparator = System.getProperty("line.separator");
    }

    public void setInput(LineNumberReader input) {
        this.input = input;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        if (filter != null) {
            filter.setReader(this);
        }
    }

    public boolean markSupported() {
        return false;
    }

    public String readLine() throws IOException {
        String line;
        if (this.input.ready() && (line = this.input.readLine()) != null) {
            if (!(this.input instanceof ProcessorReader)) {
                line = line + this.lineSeparator;
            }
            String parse = this.filter.parse(line);
            return parse;
        }
        if (this.filter.hasCachedData()) {
            return this.filter.flush();
        }
        return null;
    }

    public boolean ready() {
        try {
            boolean ready = this.input.ready();
            if (ready) {
                return true;
            }
            return this.filter.hasCachedData();
        }
        catch (IOException eee) {
            return false;
        }
    }

    public void close() throws IOException {
        this.input.close();
    }
}

