/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.csv;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.nuiton.csv.AbstractImportErrorInfo;

public class ImportRow<E> {
    protected long lineNumber;
    protected E bean;
    protected Set<AbstractImportErrorInfo<E>> errors;
    protected boolean next;
    protected Optional<String> rawRecord = Optional.absent();

    public ImportRow(ImportRow<E> row) {
        this.lineNumber = row.getLineNumber();
        this.bean = row.getBean();
        this.errors = Sets.newHashSet(row.getErrors());
        this.setNext(row.hasNext());
        this.rawRecord = row.getRawRecord();
    }

    public ImportRow() {
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public E getBean() {
        return this.bean;
    }

    public Set<AbstractImportErrorInfo<E>> getErrors() {
        return this.errors == null ? Collections.emptySet() : this.errors;
    }

    public boolean isValid() {
        return CollectionUtils.isEmpty(this.errors);
    }

    public boolean hasNext() {
        return this.next;
    }

    public void setNext(boolean next) {
        this.next = next;
    }

    public void setLineNumber(long lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void addError(AbstractImportErrorInfo<E> error) {
        if (this.errors == null) {
            this.errors = Sets.newHashSet();
        }
        this.errors.add(error);
    }

    public void prepareNextRow(E bean) {
        this.bean = bean;
        ++this.lineNumber;
        this.errors = null;
        this.rawRecord = Optional.absent();
    }

    public Optional<String> getRawRecord() {
        return this.rawRecord;
    }

    public void setRawRecord(String rawRecord) {
        this.rawRecord = Optional.fromNullable((Object)Strings.emptyToNull((String)rawRecord));
    }

    public String toString() {
        return "ImportRow{lineNumber=" + this.lineNumber + ", bean=" + this.bean + ", errors=" + this.errors + ", next=" + this.next + ", rawRecord=" + this.rawRecord + '}';
    }
}

