/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.runtime.api.swing;

import java.net.URL;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class Icons {
    public static final String DEFAULT_ICON_PATH = "/icons/";
    public static final String DEFAULT_ICON_PATH_PROPERTY = "default.icon.path";

    public static ImageIcon createIcon(String path) {
        URL imgURL = Icons.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        throw new IllegalArgumentException("could not find icon " + path);
    }

    public static ImageIcon createImageIcon(String path) {
        String iconPath = Icons.getIconPath();
        return Icons.createIcon(iconPath + path);
    }

    public static Icon getUIManagerIcon(String key) {
        return UIManager.getIcon(key);
    }

    public static Icon getUIManagerActionIcon(String key) {
        return Icons.getUIManagerIcon("action." + key);
    }

    public static ImageIcon createActionIcon(String name) {
        String iconPath = Icons.getIconPath();
        return Icons.createIcon(iconPath + "action-" + name + ".png");
    }

    public static ImageIcon createI18nIcon(String name) {
        String iconPath = Icons.getIconPath();
        return Icons.createIcon(iconPath + "i18n/" + name + ".png");
    }

    private static String getIconPath() {
        String iconPath = UIManager.getString(DEFAULT_ICON_PATH_PROPERTY);
        if (iconPath == null) {
            iconPath = DEFAULT_ICON_PATH;
        } else if (!iconPath.endsWith("/")) {
            iconPath = iconPath + "/";
        }
        return iconPath;
    }
}

