package jaxx.demo.component.jaxx.editor;

/*
 * #%L
 * JAXX :: Demo
 * %%
 * Copyright (C) 2008 - 2014 Code Lutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import jaxx.demo.entities.DemoDataProvider;
import jaxx.demo.entities.DemoDecoratorProvider;
import jaxx.demo.entities.People;
import jaxx.runtime.spi.UIHandler;
import org.nuiton.decorator.JXPathDecorator;

import java.util.List;

import static org.nuiton.i18n.I18n.t;
import static org.nuiton.i18n.I18n.n;

/**
 * Handlerof {@link BeanComboBoxDemo}.
 *
 * @author Kevin Morin - morin@codelutin.com
 * @since 2.5.12
 */
public class BeanFilterableComboBoxDemoHandler implements UIHandler<BeanFilterableComboBoxDemo> {

    private JXPathDecorator<People> decorator;


    @Override
    public void beforeInit(BeanFilterableComboBoxDemo ui) {
        this.decorator = (JXPathDecorator<People>)
                new DemoDecoratorProvider().getDecoratorByType(People.class);
    }

    @Override
    public void afterInit(BeanFilterableComboBoxDemo ui) {

        List<People> data = new DemoDataProvider().getPeoples();

        ui.getComboBox().init(decorator, data);
    }

    public String getSelectedResult(Object people) {
        String result;

        if (people == null || !People.class.isInstance(people)) {
            result = t("jaxxdemo.beanfilterablecomboboxdemo.no.people.selected");
        } else {
            result = t("jaxxdemo.beanfilterablecomboboxdemo.selected.people", decorator.toString(people));
        }
        return result;
    }

    static {
        n("jaxxdemo.common.people");
        n("jaxxdemo.common.firstName");
        n("jaxxdemo.common.lastName");
        n("jaxxdemo.common.age");
    }
}
