/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.votecounting.api;

import com.google.common.collect.Maps;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.chorem.pollen.votecounting.api.VoteCounting;
import org.chorem.pollen.votecounting.api.VoteCountingNotFound;
import org.chorem.pollen.votecounting.api.VoteCountings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VoteCountingFactory {
    private static final Logger log = LoggerFactory.getLogger(VoteCountingFactory.class);
    private final Map<VoteCountings, VoteCounting> voteCountings = Maps.newHashMap();

    public VoteCountingFactory() {
        ServiceLoader<VoteCounting> loader = ServiceLoader.load(VoteCounting.class);
        Locale l = Locale.getDefault();
        for (VoteCounting strategy : loader) {
            VoteCountings id = strategy.getId();
            String voteCountingName = strategy.getName(l);
            if (this.voteCountings.containsKey((Object)id)) {
                throw new IllegalStateException("Strategy [" + voteCountingName + "] with id " + String.valueOf((Object)id) + ", can not be used since the id is already used by strategy [" + this.voteCountings.get((Object)id).getName(l) + "] ");
            }
            if (log.isDebugEnabled()) {
                log.debug("Detected strategy [" + String.valueOf((Object)id) + "-" + voteCountingName + "] : " + strategy.getClass().getName());
            }
            this.voteCountings.put(id, strategy);
        }
    }

    public VoteCounting getVoteCounting(VoteCountings strategyId) throws VoteCountingNotFound {
        VoteCounting type = this.voteCountings.get((Object)strategyId);
        if (type == null) {
            throw new VoteCountingNotFound("Could not find strategy with id " + String.valueOf((Object)strategyId));
        }
        return type;
    }

    public Set<VoteCountings> availableVoteCountingIds() {
        return this.voteCountings.keySet();
    }
}

