<%--
  #%L
  Pollen :: UI (struts2)
  $Id: pollForm.jsp 3715 2012-10-01 05:11:10Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/poll/pollForm.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html" pageEncoding="utf-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/pollCreation.css'/>"/>
<link rel="stylesheet" type="text/css" href="<s:url value='/css/tipTip.css'/>"/>

<script type="text/javascript">

  $(document).data(
    {
      selectPersonListToAddToVotingListTitle:'<s:text name="pollen.title.selectPersonListToAddVotingList"/>',
      selectPersonListToCreateNewVotingListTitle:'<s:text name="pollen.title.selectPersonListToCreateVotingList"/>',

      votingListText:'<s:text name="pollen.common.votingList"/>',
      personToListText:'<s:text name="pollen.common.personToList"/>',
      choiceText:'<s:text name="pollen.common.choice"/>',

      displayVotingListUrl:'<s:url namespace="/poll" action="displayVotingList"/>',
      displayPersonToListUrl:'<s:url namespace="/poll" action="displayPersonToList"/>',
      importPersonListToVotingListUrl:'<s:url namespace="/poll" action="importPersonListToVotingList"/>',
      importPersonListToNewVotingListUrl:'<s:url namespace="/poll" action="importPersonListToNewVotingList"/>',
      displayImageChoiceUrl:'<s:url namespace="/poll" action="displayImageChoice"/>',
      displayDateChoiceUrl:'<s:url namespace="/poll" action="displayDateChoice"/>',
      displayTextChoiceUrl:'<s:url namespace="/poll" action="displayTextChoice"/>',
      selectPersonListToAddToVotingListUrl:'<s:url action="selectPersonListToAddToVotingList" namespace="/poll"/>',
      selectPersonListToCreateNewVotingListUrl:'<s:url action="selectPersonListToCreateNewVotingList" namespace="/poll"/>',

      choiceAddAllowed:'<s:property value="%{poll.choiceAddAllowed}"/>',
      limitChoice:'<s:property value="%{limitChoice}"/>',
      reminder:'<s:property value="%{reminder}"/>',
      publicOption:'<s:property value="%{poll.publicResults}"/>',
      anonymousOption:'<s:property value="%{poll.anonymous}"/>',
      voteCountingType:'<s:property value="%{poll.voteCountingType.name()}"/>',
      choiceType:'<s:property value="%{poll.choiceType.name()}"/>',
      pollType:'<s:property value="%{poll.pollType.name()}"/>',
      confirmCloseTitle:"<s:text name='pollen.title.close.poll'/>",
      confirmCloseUrl:'<s:url action="confirmClosePoll/%{poll.adminId}" namespace="/poll"/>',
      confirmCloseRedirectUrl:'<s:url action="summary/%{poll.adminId}" namespace="/poll"/>',
      voteCountingTypeHelp:{}
    }
  );
  $(document).ready(function () {

    var voteCountingTypeHelp = $(document).data('voteCountingTypeHelp');
    <s:iterator value="voteCountingTypes" status="status">
    voteCountingTypeHelp['<s:property value="#status.index"/>'] =
    "<s:property value='%{getVoteCountingHelp(#status.index)}' escapeHtml="false"/>";
    </s:iterator>

    function displayVoteCountingHelp(type) {
      var help= $(document).data('voteCountingTypeHelp');
      console.info("Change vct to "+type+" : "+help[type]);
      $('#voteCountingHelp').html(help[type]);
    }
    $('[name="poll.voteCountingType"]').change(function () {
      displayVoteCountingHelp(this.value);
    });
    displayVoteCountingHelp('<s:property value="poll.voteCountingType"/>');
  });
</script>

<script type="text/javascript"
        src='<s:url value="/js/createPoll.js"/>'></script>
<script type="text/javascript"
        src='<s:url value="/js/jquery.tipTip.minified.js"/>'></script>

<s:url id='errorImg' value='/img/exclamation.png'/>

<title>
  <s:if test="edit">
    <s:text name="pollen.title.editPoll"/>
  </s:if>
  <s:else>
    <s:text name="pollen.title.createPoll"/>
  </s:else>
</title>

<h1 class="title<s:property value='%{pageLogo}'/>">
  <s:property value="%{pageTitle}"/>
</h1>

<s:form method="POST" id="registerForm" namespace="/poll"
        enctype="multipart/form-data" cssClass="KForm" action="KForm/create">

<s:hidden key="poll.topiaId" label=""/>

<sj:tabbedpanel id="formTabs" selectedTab="%{selectedTab}">

<sj:tab id="tabGeneral" target="tgeneral" key="pollen.tab.poll.general"/>
<sj:tab id="tabOptions" target="toptions" key="pollen.tab.poll.options"/>

<div id="tgeneral">

  <fieldset>

    <s:textfield key="poll.title" label="%{getText('pollen.common.title')}"
                 required="true" size="80"/>
    <s:textarea key="poll.description" rows="3" cols="54"
                label="%{getText('pollen.common.description')}"/>
    <s:hidden key="poll.pollId" label=""/>
  </fieldset>

  <br/>

  <fieldset class="disableForVoteStarted">
    <legend>
      <s:text name='pollen.common.voteCountingType'/>
      <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
           alt="<s:text name='pollen.common.voteCountingTypeHelp'/>"
           title="<s:text name='pollen.common.voteCountingTypeHelp'/>"/>
    </legend>
    <s:radio key='poll.voteCountingType' list="voteCountingTypes"
             label='' theme="simple"/>
    <hr/>
    <p id="voteCountingHelp"></p>
  </fieldset>
  <br/>

  <%@include file="createPoll_choices.jsp" %>

</div>

<div id="toptions">

  <fieldset>
    <legend>
      <s:text name="pollen.fieldset.creator.options"/>
      <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
           title="<s:text name='pollen.fieldset.creator.options.help'/>"
           alt="<s:text name='pollen.fieldset.creator.options.help'/>"/>
    </legend>
    <s:textfield key="poll.creator.votingId" size="80"
                 label="%{getText('pollen.common.login')}"/>
    <s:textfield key="poll.creator.email" size="80"
                 label="%{getText('pollen.common.email')}"/>
    <s:hidden key="poll.creator.accountId" label=""/>
    <s:hidden key="poll.creator.topiaId" label=""/>
    <s:if test="creatorUserAccountDefined">
      <s:hidden name="userId" value="%{poll.creator.userAccount.topiaId}"/>
    </s:if>
  </fieldset>
  <br/>

  <fieldset>
    <legend>
      <s:text name="pollen.fieldset.pollDate.options"/>
      <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
           title="<s:text name='pollen.fieldset.pollDate.options.help'/>"
           alt="<s:text name='pollen.fieldset.pollDate.options.help'/>"/>
    </legend>

    <sj:datepicker key="poll.beginDate" cssClass="disableForVoteStarted"
                   displayFormat="%{getText('pollen.common.datePickerPattern')}"
                   label="%{getText('pollen.common.beginDate')}"
                   timepicker="true"/>
    <sj:datepicker key="poll.endDate"
                   displayFormat="%{getText('pollen.common.datePickerPattern')}"
                   timepicker="true"
                   label="%{getText('pollen.common.endDate')}"/>
  </fieldset>
  <br/>

  <fieldset class="disableForVoteStarted">
    <legend>
      <s:text name="pollen.fieldset.choice.options"/>
      <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
           title="<s:text name='pollen.fieldset.choice.options.help'/>"
           alt="<s:text name='pollen.fieldset.choice.options.help'/>"/>
    </legend>
    <s:checkbox key="poll.choiceAddAllowed"
                label="%{getText('pollen.common.pollOption.choiceAddAllowed')}"
                disabled="%{voteStarted}"
                tooltip="%{getText('pollen.common.pollOption.choiceAddAllowed.help')}"
                tooltipIconPath="/img/tooltip.png"/>
    <sj:datepicker key="poll.beginChoiceDate"
                   label="%{getText('pollen.common.beginChoiceDate')}"
                   displayFormat="%{getText('pollen.common.datePickerPattern')}"
                   timepicker="true"
                   disabled="%{voteStarted}"/>
    <sj:datepicker key="poll.endChoiceDate"
                   label="%{getText('pollen.common.endChoiceDate')}"
                   displayFormat="%{getText('pollen.common.datePickerPattern')}"
                   timepicker="true"
                   disabled="%{voteStarted}"/>
    <s:checkbox key="limitChoice"
                label="%{getText('pollen.common.pollOption.limitChoice')}"
                disabled="%{voteStarted}"
                tooltip="%{getText('pollen.common.pollOption.limitChoice.help')}"
                tooltipIconPath="/img/tooltip.png"/>
    <s:textfield key="maxChoices"
                 label="%{getText('pollen.common.pollOption.maxChoiceNb')}"
                 disabled="%{voteStarted}"/>
  </fieldset>
  <br/>

  <fieldset class="disableForVoteStarted">
    <legend>
      <s:text name="pollen.fieldset.vote.options"/>
      <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
           title="<s:text name='pollen.fieldset.vote.options.help'/>"
           alt="<s:text name='pollen.fieldset.vote.options.help'/>"/>
    </legend>

    <s:checkbox key="pollCommentVisible"
                label="%{getText('pollen.common.pollOption.pollCommentVisible')}"
                disabled="%{voteStarted}"
                tooltip="%{getText('pollen.common.pollOption.pollCommentVisible.help')}"
                tooltipIconPath="/img/tooltip.png"/>

    <s:radio key='poll.pollVoteVisibility' list="pollVoteVisibilities"
             label='%{getText("pollen.common.pollOption.pollVoteVisibility")}'
             tooltip="%{getText('pollen.common.pollOption.pollVoteVisibility.help')}"
             tooltipIconPath="/img/tooltip.png"/>
    <s:checkbox key="poll.anonymousVoteAllowed"
                label="%{getText('pollen.common.pollOption.anonymousVoteAllowed')}"
                disabled="%{voteStarted}"
                tooltip="%{getText('pollen.common.pollOption.anonymousVoteAllowed.help')}"
                tooltipIconPath="/img/tooltip.png"/>
  </fieldset>
  <br/>
  <fieldset>
    <legend>
      <s:text name="pollen.fieldset.result.options"/>
      <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
           title="<s:text name='pollen.fieldset.result.options.help'/>"
           alt="<s:text name='pollen.fieldset.result.options.help'/>"/>
    </legend>

    <s:checkbox key="poll.publicResults"
                label="%{getText('pollen.common.pollOption.publicResults')}"
                tooltip="%{getText('pollen.common.pollOption.publicResults.help')}"
                tooltipIconPath="/img/tooltip.png"/>
    <s:checkbox key="poll.continuousResults"
                label="%{getText('pollen.common.pollOption.continuousResults')}"
                tooltip="%{getText('pollen.common.pollOption.continuousResults.help')}"
                tooltipIconPath="/img/tooltip.png"/>
  </fieldset>
  <br/>

  <fieldset>
    <legend>
      <s:text name="pollen.fieldset.notification.options"/>
      <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
           title="<s:text name='pollen.fieldset.notification.options.help'/>"
           alt="<s:text name='pollen.fieldset.notification.options.help'/>"/>
    </legend>
    <s:checkbox key="notification"
                label="%{getText('pollen.common.pollOption.notification')}"
                tooltip="%{getText('pollen.common.pollOption.notification.help')}"
                tooltipIconPath="/img/tooltip.png"/>
    <s:checkbox key="reminder"
                label="%{getText('pollen.common.pollOption.reminder')}"
                tooltip="%{getText('pollen.common.pollOption.reminder.help')}"
                tooltipIconPath="/img/tooltip.png"/>
    <s:textfield key="reminderHourCountdown"
                 label="%{getText('pollen.common.pollOption.reminderHourCountdown')}"/>
  </fieldset>
  <br/>

  <fieldset class="disableForVoteStarted">
    <legend>
      <s:text name="pollen.common.pollType"/>
      <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
           title="<s:text name='pollen.common.pollType.help'/>"
           alt="<s:text name='pollen.common.pollType.help'/>"/>
    </legend>
    <s:radio key='poll.pollType' list="pollTypes"
             label='%{getText("pollen.common.pollType")}'/>
    <hr/>

    <div id="pollTypeFREE" class="pollType">
        <%--Nothing to show for a free poll--%>
    </div>

    <div id="pollTypeRESTRICTED" class="pollType">
      <s:iterator value="restrictedVotingList" status="status"
                  var="votingList">
        <s:set name="votingListNumber"><s:property
          value="%{#status.index}"/></s:set>
        <s:set name="votingListType">RESTRICTED</s:set>
        <%@include file="displayVotingList.jsp" %>
      </s:iterator>
    </div>

    <div id="pollTypeGROUP" class="pollType">
      <div id="votingListGROUP">
        <s:iterator value="groupVotingList" status="status"
                    var="votingList">
          <s:set name="votingListNumber"><s:property
            value="%{#status.index}"/></s:set>
          <s:set name="votingListType">GROUP</s:set>
          <%@include file="displayVotingList.jsp" %>
        </s:iterator>
      </div>
      <div align="center">
        <s:submit key="pollen.action.addVotingList" theme="simple"
                  onclick="return addNewVotingList();"/>
        <s:if test="userLoggued">
          <s:submit key="pollen.action.addVotingListFromPersonList"
                    onclick='return selectPersonListToCreateNewVotingList();'
                    theme="simple"/>
        </s:if>
      </div>
    </div>
  </fieldset>
</div>

</sj:tabbedpanel>

<br/>
<s:if test="edit">
  <s:submit action="edit/%{pollUri}" value="%{actionLabel}" align="center"/>
</s:if>
<s:elseif test="clone">
  <s:submit action="clone/%{pollUri}" value="%{actionLabel}" align="center"/>
</s:elseif>
<s:else>
  <s:submit action="KAction/create" value="%{actionLabel}" align="center"
            cssClass="KAction"/>
</s:else>
</s:form>

<script type="text/javascript">

  jQuery(document).ready(function () {

    function addErrorImage(element) {
      element.append(
        '<image src="${errorImg}">'
      );
      element.attr('title', '<s:text name="pollen.error.pollTabErrorFound"/>');
    }

    if (<s:property value="%{informationsError}"/>) {
      addErrorImage($('#tabGeneral a'));
    }
    if (<s:property value="%{optionsError}"/>) {
      addErrorImage($('#tabOptions a'));
    }

    if (<s:property value="%{poll.closed}"/>) {
      disablePoll();
    }
    if (<s:property value="%{voteStarted}"/>) {
      disableWhenVoteStarted();
    }

    $.struts2_jquery.require('js/base/jquery.ui.sortable.js', function () {

      $(".choices").sortable({placeholder:"ui-state-highlight",
                               update:function (event, ui) {
                                 var item = $(ui.item);
                                 var container = item.data('choiceType');
                                 var choiceNumber = item.data('choiceNumber');
                                 //console.info('Moved ' + container + ' -- ' + choiceNumber);
                                 reorder(container);
                               }
                             });
    });
  });
</script>

<sj:dialog id="selectPersonListDialog" resizable="true" autoOpen="false"
           modal="true" width="500"/>

<sj:dialog id="confirmDialog" autoOpen="false" modal="true" width="500"/>
