/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.actions.poll.vote;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.pollen.bean.PollUrl;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.services.impl.VoteService;
import org.chorem.pollen.ui.actions.poll.vote.AbstractVoteAction;
import org.chorem.pollen.votecounting.VoteCounting;
import org.nuiton.i18n.I18n;

public class VoteForPoll
extends AbstractVoteAction
implements Preparable {
    private static final Log log = LogFactory.getLog(VoteForPoll.class);
    private static final long serialVersionUID = 1L;

    public boolean isModerate() {
        return false;
    }

    public void prepare() throws Exception {
        this.prepareVotePage();
        Poll poll = this.getPoll();
        if (poll.isClosed()) {
            this.addFlashWarning(this._("pollen.information.pollClosed", new Object[0]));
        } else if (!this.isPollStarted()) {
            this.addFlashWarning(this._("pollen.information.pollNotStarted", new Object[0]));
        } else if (this.isPollFinished()) {
            this.addFlashWarning(this._("pollen.information.pollFinished", new Object[0]));
        } else if (!this.isVoteAllowed()) {
            this.addFlashWarning(this._("pollen.information.pollCanNotVote", new Object[0]));
        }
        if (this.isPollChoiceRunning()) {
            this.addFlashMessage(this._("pollen.information.pollChoiceRunning", new Object[0]));
        }
    }

    public void validate() {
        Vote vote = this.getVote();
        Preconditions.checkNotNull((Object)vote);
        PollAccount pollAccount = this.getVote().getPollAccount();
        Preconditions.checkNotNull((Object)pollAccount);
        Poll poll = this.getPoll();
        if (!vote.isAnonymous()) {
            String name = pollAccount.getVotingId();
            if (StringUtils.isBlank((CharSequence)name)) {
                this.addFieldError("pollAccount.votingId", this._("pollen.error.pollAccount.votingId.required", new Object[0]));
            }
            if (!this.getVoteService().isVotingIdFree(poll, pollAccount.getTopiaId(), name)) {
                this.addFieldError("pollAccount.votingId", this._("pollen.error.user.alreadyVoted", new Object[]{name}));
            }
        }
        int nbVotes = 0;
        int totalValues = 0;
        VoteCounting voteCounting = this.getVoteCounting(this.getPoll());
        boolean voteValid = true;
        int voteNumber = -1;
        for (VoteToChoice voteToChoice : vote.getChoiceVoteToChoice()) {
            boolean voteNull;
            String originalValue;
            ++voteNumber;
            Integer value = voteToChoice.getVoteValue();
            if (value == null) {
                String[] values = (String[])this.getParameters().get("vote.choiceVoteToChoice[" + voteNumber + "].voteValue");
                String string = originalValue = values == null || values.length < 1 ? null : values[0];
                if (StringUtils.isNotBlank((CharSequence)originalValue)) {
                    String validMessage = this._("pollen.error.vote.invalidFormat", new Object[]{voteToChoice.getChoice().getName(), originalValue});
                    this.addFieldError("vote.choices", validMessage);
                    voteValid = false;
                    break;
                }
            } else {
                originalValue = String.valueOf(value);
            }
            if (voteNull = voteCounting.isVoteValueNull(value)) continue;
            boolean valid = voteCounting.isVoteValueValid(value);
            if (valid) {
                ++nbVotes;
                totalValues += value.intValue();
                continue;
            }
            String validMessage = voteCounting.getVoteValueNotValidMessage(this.getLocale(), voteToChoice.getChoice().getName(), originalValue);
            this.addFieldError("vote.choices", validMessage);
            voteValid = false;
            break;
        }
        if (voteValid) {
            int maxChoice = this.getPoll().getMaxChoiceNb();
            if (maxChoice != 0 && nbVotes > maxChoice) {
                this.addFieldError("vote.choices", this._("pollen.error.vote.maxChoiceNb", new Object[]{maxChoice}));
            }
            if (!voteCounting.isTotalVoteValueValid(totalValues)) {
                String errorMessage = voteCounting.getTotalVoteValueNotValidMessage(this.getLocale());
                this.addFieldError("vote.choices", errorMessage);
            }
        }
    }

    public String execute() throws Exception {
        Poll poll = this.getPoll();
        Vote vote = this.getVote();
        VoteService voteService = this.getVoteService();
        boolean newVote = StringUtils.isBlank((CharSequence)vote.getTopiaId());
        Vote savedVote = newVote ? voteService.createVote(poll, vote) : voteService.updateVote(poll, vote);
        this.clearFlashMessages();
        if (StringUtils.isBlank((CharSequence)this.getUserSecurityContext().getAccountId())) {
            boolean connected;
            String pollId = poll.getPollId();
            String accountId = savedVote.getPollAccount().getAccountId();
            PollUrl updateUrl = this.getPollUrlService().getPollVoteUrl(poll, savedVote.getPollAccount());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("UpdateURL for poll '%s' and account '%s' = %s", pollId, accountId, updateUrl));
            }
            String message = (connected = this.getUserSecurityContext().isConnected()) ? I18n.n_((String)"pollen.information.vote.createdWithUpdateUrl.notConnected", (Object[])new Object[0]) : I18n.n_((String)"pollen.information.vote.createdWithUpdateUrl", (Object[])new Object[0]);
            this.addFlashMessage(this._(message, new Object[]{updateUrl}));
        } else {
            this.addFlashMessage(this._("pollen.information.vote.created", new Object[0]));
        }
        return "success";
    }
}

