/*
 * Decompiled with CFR 0.152.
 */
package winstone.accesslog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import winstone.AccessLogger;
import winstone.Logger;
import winstone.WebAppConfiguration;
import winstone.WinstoneRequest;
import winstone.WinstoneResourceBundle;
import winstone.WinstoneResponse;

public class SimpleAccessLogger
implements AccessLogger {
    public static final WinstoneResourceBundle ACCESSLOG_RESOURCES = new WinstoneResourceBundle("winstone.accesslog.LocalStrings");
    private static final DateFormat DF = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
    private static final String COMMON = "###ip### - ###user### ###time### \"###uriLine###\" ###status### ###size###";
    private static final String COMBINED = "###ip### - ###user### ###time### \"###uriLine###\" ###status### ###size### \"###referer###\" \"###userAgent###\"";
    private static final String RESIN = "###ip### - ###user### ###time### \"###uriLine###\" ###status### ###size### \"###userAgent###\"";
    private OutputStream outStream;
    private PrintWriter outWriter;
    private String pattern;
    private String fileName;

    public SimpleAccessLogger(WebAppConfiguration webAppConfig, Map startupArgs) throws IOException {
        String patternType = WebAppConfiguration.stringArg(startupArgs, "simpleAccessLogger.format", "combined");
        this.pattern = patternType.equalsIgnoreCase("combined") ? COMBINED : (patternType.equalsIgnoreCase("common") ? COMMON : (patternType.equalsIgnoreCase("resin") ? RESIN : patternType));
        String filePattern = WebAppConfiguration.stringArg(startupArgs, "simpleAccessLogger.file", "logs/###host###/###webapp###_access.log");
        this.fileName = WinstoneResourceBundle.globalReplace(filePattern, new String[][]{{"###host###", webAppConfig.getOwnerHostname()}, {"###webapp###", webAppConfig.getContextName()}});
        File file = new File(this.fileName);
        file.getParentFile().mkdirs();
        this.outStream = new FileOutputStream(file, true);
        this.outWriter = new PrintWriter(this.outStream, true);
        Logger.log(Logger.DEBUG, ACCESSLOG_RESOURCES, "SimpleAccessLogger.Init", new String[]{this.fileName, patternType});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String originalURL, WinstoneRequest request, WinstoneResponse response) {
        String uriLine = request.getMethod() + " " + originalURL + " " + request.getProtocol();
        int status = response.getErrorStatusCode() == null ? response.getStatus() : response.getErrorStatusCode().intValue();
        int size = response.getWinstoneOutputStream().getBytesCommitted();
        String date = null;
        DateFormat dateFormat = DF;
        synchronized (dateFormat) {
            date = DF.format(new Date());
        }
        String logLine = WinstoneResourceBundle.globalReplace(this.pattern, new String[][]{{"###ip###", request.getRemoteHost()}, {"###user###", SimpleAccessLogger.nvl(request.getRemoteUser())}, {"###time###", "[" + date + "]"}, {"###uriLine###", uriLine}, {"###status###", "" + status}, {"###size###", "" + size}, {"###referer###", SimpleAccessLogger.nvl(request.getHeader("Referer"))}, {"###userAgent###", SimpleAccessLogger.nvl(request.getHeader("User-Agent"))}});
        this.outWriter.println(logLine);
    }

    private static String nvl(String input) {
        return input == null ? "-" : input;
    }

    public void destroy() {
        Logger.log(Logger.DEBUG, ACCESSLOG_RESOURCES, "SimpleAccessLogger.Close", this.fileName);
        if (this.outWriter != null) {
            this.outWriter.flush();
            this.outWriter.close();
            this.outWriter = null;
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outStream = null;
        }
        this.fileName = null;
    }
}

