/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.CompanyBoatInfos;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ObsProgram;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.BoatInfos;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.ElligibleBoat;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.ShipOwner;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceContact;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.components.BoatFilterComponent;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.BoatDataSource;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.data.WaoActivationContext;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.slf4j.Logger;

@RequiresAuthentication(allowedRoles={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER})
@Import(stylesheet={"context:css/boats.css"})
public class Boats {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private ConnectedUser user;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private ServiceContact serviceContact;
    @Inject
    private PropertyAccess propertyAccess;
    private WaoActivationContext waoActivationContext;
    @Property
    @Persist
    private SampleRow sampleRowContext;
    @InjectComponent
    private BoatFilterComponent filterComponent;
    @Persist
    private Integer boatSelectedImmatriculation;
    @Persist
    private BoatDataSource boats;
    @Property
    private Boat boat;
    private boolean even = true;
    @InjectComponent
    private Zone boatsZone;
    @Persist
    private CompanyBoatInfos companyBoatInfos;
    @InjectComponent
    private Zone boatInfosZone;
    @Inject
    private Block displayBoatInfos;
    @Inject
    private Block editBoatInfos;
    @Property
    private ElligibleBoat elligibleBoat;
    @Property
    private SampleRow boatInfosSampleRow;
    private boolean boatInfosEditable;
    private Date boardingFromDate;
    @Inject
    private ServiceUser serviceUser;
    private Company company;
    @Inject
    private WaoManager manager;
    @InjectPage
    private Contacts contacts;

    void onActivate(EventContext ec) {
        this.waoActivationContext = WaoActivationContext.newContextFromTapestry((EventContext)ec);
    }

    public void onActionFromCancelSelection() {
        this.sampleRowContext = null;
    }

    public String getSummaryForSampleRowContext() {
        String summary = null;
        if (this.sampleRowContext != null && this.sampleRowContext.getObsProgram() == ObsProgram.OBSDEB) {
            summary = this.manager.getTooltipSampleRow(this.sampleRowContext);
        }
        return summary;
    }

    void setupRender() throws WaoException, WaoBusinessException {
        this.boats = null;
        this.boatSelectedImmatriculation = null;
        this.companyBoatInfos = null;
        this.getBoatFilter().setBoatImmatriculation(this.waoActivationContext.getBoatImmatriculation());
        this.getBoatFilter().setShipOwnerName(this.waoActivationContext.getShipOwnerName());
        String sampleRowContextId = this.waoActivationContext.getSampleRowCode();
        if (sampleRowContextId != null) {
            SampleRow sampleRow = this.serviceSampling.getSampleRowByCode(this.user, sampleRowContextId);
            this.filterComponent.setSampleRow(sampleRow);
            this.sampleRowContext = this.user.isCoordinatorOrObserver() ? sampleRow : null;
        }
    }

    StreamResponse onActionFromExportShowBoats() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public SamplingFilter getFilter() throws WaoException {
        return this.getBoatFilter();
    }

    public BoatFilter getBoatFilter() throws WaoException {
        return (BoatFilter)this.filterComponent.getFilter();
    }

    public boolean isFiltersVisible() {
        return this.filterComponent.getFiltersVisible();
    }

    Object onActionFromShowFilters() {
        this.filterComponent.switchFiltersVisible();
        if (this.isFiltersVisible()) {
            return this.filterComponent;
        }
        return this.filterComponent.getFiltersZone();
    }

    void onSelectedFromReset() {
        this.filterComponent.resetFilter();
    }

    @Log
    Object onSuccessFromFiltersForm() throws WaoException {
        this.boats = null;
        this.boatSelectedImmatriculation = null;
        this.companyBoatInfos = null;
        return this.boatsZone.getBody();
    }

    public Integer getBoatSelectedImmatriculation() {
        if (this.boatSelectedImmatriculation == null) {
            this.boatSelectedImmatriculation = this.waoActivationContext.getBoatImmatriculation();
        }
        return this.boatSelectedImmatriculation;
    }

    public void setBoatSelectedImmatriculation(Integer boatSelectedImmatriculation) {
        this.boatSelectedImmatriculation = boatSelectedImmatriculation;
    }

    public BoatDataSource getBoats() throws WaoException {
        if (this.boats == null) {
            this.boats = new BoatDataSource(this.getBoatFilter(), this.serviceBoat);
        }
        return this.boats;
    }

    public String getRowStyle() {
        String result = "";
        boolean bl = this.even = !this.even;
        result = this.boatSelectedImmatriculation != null && this.boat.getImmatriculation() == this.boatSelectedImmatriculation.intValue() ? "selected" : (!this.boat.getActive() ? "refused" : (this.even ? "even" : "odd"));
        return result;
    }

    public String getBoatInactive() {
        return !this.boat.getActive() ? "(inactif)" : "";
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public boolean canCreateNewContactFromList() throws WaoException {
        if (!(this.user.isAdmin() || this.user.isProfessional() || this.user.isReadOnly() || this.sampleRowContext == null)) {
            return this.boat.canCreateContact(this.user.getProfile().getObsProgram(), this.user.getCompany());
        }
        return false;
    }

    Block onActionFromShowBoatInfos(Integer boatImma) throws WaoException {
        this.boatSelectedImmatriculation = boatImma;
        this.companyBoatInfos = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Show infos for boat : " + boatImma);
        }
        if (!this.user.isAdmin() || this.getCompany() != null) {
            // empty if block
        }
        return this.boatsZone.getBody();
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String[] getContextForShipOwner() {
        ShipOwner shipOwner = this.getBoatInfos().getBoat().getShipOwner();
        String shipOwnerName = shipOwner.getFirstName() + " " + shipOwner.getLastName();
        this.waoActivationContext.setShipOwnerName(shipOwnerName);
        return this.waoActivationContext.toStrings();
    }

    public Block getActiveBoatInfosBlock() {
        if (this.boatInfosEditable) {
            return this.editBoatInfos;
        }
        return this.displayBoatInfos;
    }

    public CompanyBoatInfos getCompanyBoatInfos() throws WaoException {
        if (this.companyBoatInfos == null && this.boatSelectedImmatriculation != null && this.getCompany() != null) {
            this.companyBoatInfos = this.serviceBoat.getCompanyBoatInfos(this.user.getProfile().getObsProgram(), this.boatSelectedImmatriculation.intValue(), this.getCompany());
        }
        return this.companyBoatInfos;
    }

    public List<Company> getCompanies() {
        List companies = this.serviceUser.getCompanies(true);
        return companies;
    }

    public Company getCompany() {
        if (this.company == null && !this.user.isAdmin()) {
            this.company = this.user.getCompany();
        }
        return this.company;
    }

    public Boat getBoatSelected() throws WaoException {
        Boat boatSelected;
        if (this.boatSelectedImmatriculation == null) {
            boatSelected = null;
        } else {
            boatSelected = (Boat)this.getBoats().get((Object)this.boatSelectedImmatriculation);
            if (boatSelected == null) {
                throw new IllegalStateException("immatriculation selected among an obsolete list of boats");
            }
        }
        return boatSelected;
    }

    public Date getBoardingFromDate() {
        if (this.boardingFromDate == null) {
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).add(2, -12);
            this.boardingFromDate = calendar.getTime();
        }
        return this.boardingFromDate;
    }

    public void setBoardingFromDate(Date boardingFromDate) {
        this.boardingFromDate = boardingFromDate;
    }

    public BoatInfos getBoatInfos() throws WaoException {
        if (this.getCompanyBoatInfos() == null) {
            return null;
        }
        return this.getCompanyBoatInfos().getBoatInfos();
    }

    public String getlastContactStyle() throws WaoException {
        Contact contact = this.getCompanyBoatInfos().getLastContact();
        return this.manager.getContactStyle(contact, this.user.isAdmin());
    }

    public List<SampleRow> getSampleRows() {
        return this.serviceSampling.getSampleRowsForEligibility(this.user);
    }

    public List<ElligibleBoat> getElligibleBoatsValues() {
        return new ArrayList<ElligibleBoat>(this.getCompanyBoatInfos().getElligibleBoatsValues());
    }

    public String getElligibleRowInfos() {
        return this.manager.getTooltipSampleRow(this.elligibleBoat.getSampleRow());
    }

    public boolean isElligibleBoatCompanyActiveFalse() {
        return BooleanUtils.isFalse((Boolean)this.elligibleBoat.getCompanyActive());
    }

    public boolean canCreateNewContactFromElligibleBoat() throws WaoException {
        if (!(this.user.isAdmin() || this.user.isReadOnly() || this.isElligibleBoatCompanyActiveFalse())) {
            Boat currentBoat = this.getBoatInfos().getBoat();
            return currentBoat.canCreateContact(this.user.getProfile().getObsProgram(), this.user.getCompany());
        }
        return false;
    }

    public boolean isSampleRowFinished() {
        boolean result = this.elligibleBoat.getSampleRow().isFinished();
        return result;
    }

    public String getElligibleRowStyle() {
        boolean condition1 = this.elligibleBoat.getCompanyActive() == null && !this.elligibleBoat.getGlobalActive();
        return condition1 || this.isElligibleBoatCompanyActiveFalse() ? "line-through" : "";
    }

    public boolean canEditBoatInfos() {
        return !this.user.isReadOnly();
    }

    void onSuccess() throws WaoException {
        if (this.getBoatInfos() != null) {
            this.boatSelectedImmatriculation = this.getBoatInfos().getBoat().getImmatriculation();
        }
    }

    Block onSuccessFromCompanySelectForm() throws WaoException {
        this.companyBoatInfos = null;
        this.getCompanyBoatInfos();
        return this.boatInfosZone.getBody();
    }

    Block onActionFromEditBoatInfos() throws WaoException {
        if (this.canEditBoatInfos()) {
            this.boatInfosEditable = true;
        }
        return this.boatInfosZone.getBody();
    }

    Block onActionFromCancelEditBoatInfos() throws WaoException {
        this.boatSelectedImmatriculation = this.getBoatInfos().getBoat().getImmatriculation();
        this.companyBoatInfos = null;
        return this.boatInfosZone.getBody();
    }

    void onSelectedFromAddBoatInfosSampleRow() throws WaoException {
        this.boatInfosEditable = true;
        if (this.boatInfosSampleRow != null) {
            this.companyBoatInfos.setNewElligibleBoat(this.boatInfosSampleRow);
        }
    }

    void onSelectedFromRemoveBoatInfosSampleRow(String sampleRowCode) throws WaoException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.removeElligibleBoat(sampleRowCode);
    }

    void onSelectedFromActiveBoatInfosSampleRow(String sampleRowCode) throws WaoException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.activeElligibleBoat(sampleRowCode);
    }

    Block onSuccessFromBoatInfosForm() throws WaoException {
        if (!this.boatInfosEditable && this.canEditBoatInfos()) {
            this.serviceBoat.createUpdateCompanyBoatInfos(this.companyBoatInfos);
        }
        return this.boatInfosZone.getBody();
    }

    Block onSuccessFromCalculateBoardings() throws WaoException {
        return this.boatInfosZone.getBody();
    }

    Object onActionFromAddNewContactFromBoat(int boatImmatriculation) throws WaoException {
        this.boat = (Boat)this.getBoats().get((Object)boatImmatriculation);
        Contact newContact = this.serviceContact.newContact(this.user, this.sampleRowContext, this.boat);
        this.contacts.setContactSelectedId(newContact.getTopiaId());
        return this.contacts;
    }

    Object onActionFromAddNewContactFromSampleRow(String sampleRowCode) throws WaoException {
        ElligibleBoat elligible = this.getCompanyBoatInfos().getElligibleBoat(sampleRowCode);
        SampleRow sampleRow = elligible.getSampleRow();
        this.filterComponent.setSampleRow(sampleRow);
        Contact newContact = this.serviceContact.newContact(this.user, sampleRow, this.getBoatSelected());
        this.contacts.setContactSelectedId(newContact.getTopiaId());
        return this.contacts;
    }

    static /* synthetic */ ServiceBoat access$000(Boats x0) {
        return x0.serviceBoat;
    }
}

