/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: ExportStreamResponse.java 651 2010-10-03 15:20:28Z fdesbois $
 * $HeadURL: svn+ssh://bleny@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-2.0/wao-ui/src/main/java/fr/ifremer/wao/ui/data/ExportStreamResponse.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoUtils;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.services.Response;
import org.nuiton.util.DateUtil;

import java.util.Date;

/**
 * Used to render CSV file from data export.
 *
 * Created: 2 févr. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public abstract class ExportStreamResponse implements StreamResponse {

    protected String filename;

    /**
     * Constructor with filename prefix for resulting file in response.
     *
     * @param filename prefix
     */
    public ExportStreamResponse(String filename) {
        this.filename = filename;
    }

    /**
     * Export only for CSV file with UTF-8 encoding.
     *
     * @return the contentType string
     */
    @Override
    public String getContentType() {
        return "text/csv;charset=utf-8";
    }

    /**
     * Prepare response for rendering result file with date in filename.
     *
     * @param response to prepare
     */
    @Override
    public void prepareResponse(Response response) {
        Date current = WaoUtils.getCurrentDate();
        filename += "-" + DateUtil.formatDate(current, "dd-MM-yyyy") + ".csv";
        response.setHeader("Content-Disposition",
                "attachment; filename=\"" + filename +"\"");
    }

}
