/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoardingResult;
import fr.ifremer.wao.bean.ConnectedUser;
import fr.ifremer.wao.bean.ContactAverageReactivity;
import fr.ifremer.wao.bean.ContactState;
import fr.ifremer.wao.bean.ContactStateStatistics;
import fr.ifremer.wao.bean.GlobalIndicatorValue;
import fr.ifremer.wao.bean.GlobalSynthesisParameters;
import fr.ifremer.wao.bean.GlobalSynthesisResult;
import fr.ifremer.wao.bean.SamplingFilter;
import fr.ifremer.wao.bean.SamplingFilterImpl;
import fr.ifremer.wao.bean.SynthesisId;
import fr.ifremer.wao.bean.UserRole;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.Indicator;
import fr.ifremer.wao.entity.IndicatorLevel;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.service.ServiceSynthesis;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.data.ChartUtils;
import fr.ifremer.wao.ui.data.RequiresAuthentication;
import fr.ifremer.wao.ui.services.WaoManager;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.BooleanUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.RenderSupport;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.jfree.chart.JFreeChart;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

@RequiresAuthentication(value={UserRole.ADMIN, UserRole.COORDINATOR, UserRole.OBSERVER})
@IncludeStylesheet(value={"context:css/synthesis.css"})
public class Synthesis
extends AbstractFilteredPage {
    @Environmental
    private RenderSupport renderSupport;
    @Inject
    private WaoManager manager;
    @Inject
    private ServiceSynthesis serviceSynthesis;
    @Inject
    private Logger log;
    @SessionState
    @Property
    private ConnectedUser user;
    @Persist
    private SynthesisId activeSynthesis;
    @Persist
    private Indicator activeIndicator;
    @Persist
    private IndicatorLevel activeIndicatorLevel;
    @Inject
    private ComponentResources resources;
    @InjectComponent
    private Zone delegator;
    private GlobalSynthesisParameters globalSynthesisParameters;
    private GlobalSynthesisResult globalSynthesisResult;
    @Persist
    private Boolean showGlobalSynthesis;
    @Persist
    private SamplingFilter dataSamplingFilter;
    @Property
    private SampleRow row;
    @InjectComponent
    private Zone filtersZone;
    @Persist
    private ChartUtils.ChartType dataSamplingChartType;
    private boolean reset;
    private BoardingResult boardingResult;
    private Map<String, Double> complianceBoarding;
    @Property
    private Map.Entry<String, Double> complianceBoardingEntry;
    private Collection<ContactStateStatistics> contactStateStatistics;
    @Property
    private ContactStateStatistics contactStateStats;
    @Property
    private ContactState contactState;
    private Collection<ContactAverageReactivity> allegroReactivity;
    @Property
    private ContactAverageReactivity allegroReactivityEntry;
    private Map<String, Double> dataReliability;
    @Property
    private Map.Entry<String, Double> dataReliabilityEntry;
    @Property
    private GlobalIndicatorValue[] globalLevels = GlobalIndicatorValue.values();
    @Property
    private GlobalIndicatorValue globalLevel;

    void setupRender() {
        this.initSelectFilters(true, false, true);
        this.renderSupport.addStylesheetLink("css/synthesis-print.css", "print");
    }

    public SynthesisId getActiveSynthesis() {
        if (this.activeSynthesis == null) {
            this.activeSynthesis = SynthesisId.GRAPH_SAMPLING;
        }
        return this.activeSynthesis;
    }

    public GlobalSynthesisParameters getGlobalSynthesisParameters() {
        if (this.globalSynthesisParameters == null) {
            this.globalSynthesisParameters = this.getGlobalSynthesisResult().getGlobalSynthesisParameters();
        }
        return this.globalSynthesisParameters;
    }

    public GlobalSynthesisResult getGlobalSynthesisResult() {
        if (this.globalSynthesisResult == null) {
            this.globalSynthesisResult = this.serviceSynthesis.getGlobalSynthesisResult(this.getFilter());
        }
        return this.globalSynthesisResult;
    }

    public Indicator getActiveIndicator() {
        SynthesisId activeSynthesis = this.getActiveSynthesis();
        this.activeIndicator = this.getGlobalSynthesisParameters().getParameter(activeSynthesis);
        return this.activeIndicator;
    }

    public void setActiveIndicator(Indicator activeIndicator) {
        this.activeIndicator = activeIndicator;
        this.activeSynthesis = activeIndicator.getSynthesisId();
    }

    public IndicatorLevel getActiveIndicatorLevel() {
        this.activeIndicatorLevel = this.getGlobalSynthesisResult().getLevelForIndicator(this.getActiveSynthesis());
        return this.activeIndicatorLevel;
    }

    public Block getActiveBlock() throws WaoException {
        Block activeBlock = BooleanUtils.isTrue((Boolean)this.showGlobalSynthesis) ? this.resources.getBlock("globalSynthesis") : this.resources.getBlock("ind" + this.getActiveSynthesis().ordinal());
        if (this.log.isDebugEnabled()) {
            this.log.debug("activeBlock = " + activeBlock);
        }
        return activeBlock;
    }

    public String getActionSynthesisId() {
        return SynthesisId.class.getName();
    }

    public String getActionChartType() {
        return ChartUtils.ChartType.class.getName();
    }

    public String getActionShowGlobalSynthesis() {
        return "showGlobalSynthesis";
    }

    public NumberFormat getPercentFormat() {
        return NumberFormat.getPercentInstance();
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public NumberFormat getNumberFormat() {
        NumberFormat result = NumberFormat.getNumberInstance();
        result.setMaximumFractionDigits(1);
        return result;
    }

    @Log
    Object onAction(String actionType, String actionValue) {
        this.showGlobalSynthesis = false;
        if (this.log.isDebugEnabled()) {
            this.log.debug("actionType = " + actionType);
        }
        if (actionType.equals(SynthesisId.class.getName())) {
            this.activeSynthesis = SynthesisId.valueOf((String)actionValue);
            return this.delegator.getBody();
        }
        if (actionType.equals(ChartUtils.ChartType.class.getName())) {
            this.dataSamplingChartType = ChartUtils.ChartType.valueOf((String)actionValue);
        } else if (actionType.equals("showGlobalSynthesis")) {
            this.showGlobalSynthesis = true;
            return this.delegator.getBody();
        }
        return this;
    }

    public SamplingFilter getFilter() throws WaoException {
        if (this.dataSamplingFilter == null) {
            this.dataSamplingFilter = new SamplingFilterImpl();
            if (!this.user.isAdmin()) {
                this.dataSamplingFilter.setCompany(this.user.getCompany());
            }
        }
        return this.dataSamplingFilter;
    }

    public PeriodDates getPeriod() throws WaoException {
        if (this.getFilter().getPeriod() == null) {
            PeriodDates period = PeriodDates.createMonthsPeriodFromToday((int)-12);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Period : " + period);
            }
            this.getFilter().setPeriod(period);
        }
        return this.getFilter().getPeriod();
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return false;
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    Object onSuccessFromFiltersForm() {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        if (this.reset) {
            this.dataSamplingFilter = null;
        }
        return this;
    }

    public JFreeChart getDataSamplingChart() throws WaoException {
        List res = this.serviceSynthesis.getDataSampling(this.getFilter());
        HashMap data = new HashMap();
        data.put("Planifi\u00e9", res.get(0));
        String realText = this.getFilter().getEstimatedTides() ? "Estim\u00e9" : "R\u00e9alis\u00e9";
        data.put(realText, res.get(1));
        String title = this.manager.getDataSamplingTitle(this.getFilter());
        return ChartUtils.createCategoryChart((String)title, (String)"Nb mar\u00e9es", (String)"Mois", (ChartUtils.ChartType)this.getDataSamplingChartType(), data);
    }

    public ChartUtils.ChartType getDataSamplingChartType() {
        if (this.dataSamplingChartType == null) {
            this.dataSamplingChartType = ChartUtils.ChartType.BAR;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ChartType : " + this.dataSamplingChartType);
        }
        return this.dataSamplingChartType;
    }

    public JFreeChart getBoardingBoatsChart() throws WaoException {
        LinkedHashMap<String, Map> data = new LinkedHashMap<String, Map>();
        data.put("Nombre de navires ayant effectu\u00e9s x embarquements", this.getBoardingResult().getBoardings());
        String title = "Sollicitations des navires depuis le " + this.getDateFormat().format(this.getFilter().getPeriod().getFromDate());
        Company companyForBoarding = this.getFilter().getCompany();
        if (companyForBoarding != null) {
            title = title + "\nSoci\u00e9t\u00e9 " + companyForBoarding.getName();
        }
        return ChartUtils.createCategoryChart((String)title, (String)"Nb navires", (String)"Nb embarquements", (ChartUtils.ChartType)ChartUtils.ChartType.BAR, data);
    }

    public BoardingResult getBoardingResult() throws WaoException {
        if (this.boardingResult == null) {
            this.boardingResult = this.serviceSynthesis.getBoardingBoats(this.getFilter());
        }
        return this.boardingResult;
    }

    public Map<String, Double> getComplianceBoarding() throws WaoException {
        if (this.complianceBoarding == null) {
            this.complianceBoarding = this.serviceSynthesis.getComplianceBoardingIndicator(this.getFilter());
        }
        return this.complianceBoarding;
    }

    public Double getComplianceBoardingValue() throws WaoException {
        return (Double)this.getComplianceBoarding().get(this.user.getCompany().getName());
    }

    public ContactState[] getContactStates() {
        return ContactState.values();
    }

    public Collection<ContactStateStatistics> getContactStateStatistics() throws WaoException {
        if (this.contactStateStatistics == null) {
            this.contactStateStatistics = this.serviceSynthesis.getContactStateStatistics(this.getFilter());
        }
        return this.contactStateStatistics;
    }

    public int getNbContactStates() {
        return (Integer)this.contactStateStats.getData().get(this.contactState);
    }

    public double getPercentContactStates() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("nbContactStates : " + this.getNbContactStates());
            this.log.debug("total : " + this.contactStateStats.getTotal());
        }
        return (double)this.getNbContactStates() / (double)this.contactStateStats.getTotal();
    }

    public Collection<ContactAverageReactivity> getAllegroReactivity() throws WaoException {
        if (this.allegroReactivity == null) {
            this.allegroReactivity = this.serviceSynthesis.getContactDataInputDateReactivity(this.getFilter());
        }
        return this.allegroReactivity;
    }

    public Double getAllegroReactivityValue() throws WaoException {
        if (!this.getAllegroReactivity().isEmpty()) {
            ContactAverageReactivity entry = (ContactAverageReactivity)CollectionUtils.get((Object)this.getAllegroReactivity(), (int)0);
            return entry.getResult();
        }
        return 0.0;
    }

    public String getAllegroReactivityStyle() throws WaoException {
        double value;
        double d = value = this.user.isAdmin() ? this.allegroReactivityEntry.getResult() : this.getAllegroReactivityValue().doubleValue();
        if (value >= 15.0) {
            return " warn";
        }
        return "";
    }

    public Map<String, Double> getDataReliability() {
        if (this.dataReliability == null) {
            this.dataReliability = this.serviceSynthesis.getDataReliability(this.getFilter());
        }
        return this.dataReliability;
    }

    public Double getDataReliabilityValue() throws WaoException {
        return (Double)this.getDataReliability().get(this.user.getCompany());
    }

    public boolean highlightGlobalLevel() {
        return this.globalLevel == this.getGlobalSynthesisResult().getGlobalLevel();
    }
}

