/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.services;

import fr.ifremer.wao.WaoProperty;
import fr.ifremer.wao.bean.PieChartData;
import fr.ifremer.wao.bean.PieChartSeries;
import fr.ifremer.wao.service.ServiceChart;
import org.nuiton.util.StringUtil;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Implementation of {@link ServiceChart} using Google PieChart Api syntax to
 * create urls. The property {@link WaoProperty#CHART_SERVER_PATH} defines
 * the path of the application used to create a PieChart.
 * <p />
 * Created: 30 juin 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id: ServiceChartServlet.java 610 2010-07-11 19:10:28Z fdesbois $
 */
public class ServiceChartServlet implements ServiceChart {

    private static final String PROPERTY_SEPARATOR = "&";
    private static final String PROPERTY_VALUE_SEPARATOR = ",";
    private static final String PROPERTY_LABEL_SEPARATOR = "|";
    private static final String PROPERTY_COLOR_SEPARATOR = ",";

    ///chdl=50%_5|40%_4|10%_1  :: legend not supported

    private static final String PROPERTY_TYPE = "cht=";
    private static final String PROPERTY_LABEL = "chl=";
    private static final String PROPERTY_COLOR = "chco=";
    private static final String PROPERTY_SIZE = "chs=";
    private static final String PROPERTY_VALUE = "chd=t:";
    private static final String PROPERTY_BACKGROUND_TRANSPARENT = "chf=bg,s,FFFFFF00";

    private static final int PIE_CHART_MAXI_HEIGHT = 150;
    private static final int PIE_CHART_MAXI_WIDTH = 350;

    private static final String PIE_CHART_MINI_TYPE = PROPERTY_TYPE + "p3";
    private static final String PIE_CHART_MAXI_TYPE = PROPERTY_TYPE + "p3";
    private static final String PIE_CHART_MINI_SIZE = PROPERTY_SIZE + "28x28";
    private static final String PIE_CHART_MAXI_SIZE = PROPERTY_SIZE +
            PIE_CHART_MAXI_WIDTH + "x" + PIE_CHART_MAXI_HEIGHT;

    @Override
    public String getPieChartUrl(PieChartData data, boolean thumb) {

        List<String> labelsList = new ArrayList<String>();
        List<Double> valuesList = new ArrayList<Double>();
        List<String> colorsList = new ArrayList<String>();

        for (PieChartSeries series : data.getSeries()) {
            labelsList.add(series.getLabel());
            valuesList.add(series.getValue());
            colorsList.add(series.getColor());
        }

        String values = StringUtil.join(valuesList,
                PROPERTY_VALUE_SEPARATOR, false);

        String colors = StringUtil.join(colorsList,
                PROPERTY_COLOR_SEPARATOR, false);

        StringBuilder url = new StringBuilder(getBaseUrl());

        if (thumb) {
            url.append(PIE_CHART_MINI_TYPE).
                append(PROPERTY_SEPARATOR).append(PIE_CHART_MINI_SIZE);

        // Labels only on big image
        } else {
            String labels = StringUtil.join(labelsList,
                PROPERTY_LABEL_SEPARATOR, false);

            url.append(PIE_CHART_MAXI_TYPE).
                append(PROPERTY_SEPARATOR).append(PIE_CHART_MAXI_SIZE).
                append(PROPERTY_SEPARATOR).append(PROPERTY_LABEL).append(labels);
        }

        // Add values and colors
        url.append(PROPERTY_SEPARATOR).append(PROPERTY_VALUE).append(values).
            append(PROPERTY_SEPARATOR).append(PROPERTY_COLOR).append(colors).
            append(PROPERTY_SEPARATOR).append(PROPERTY_BACKGROUND_TRANSPARENT);

        return url.toString();
    }

    @Override
    public String getHtmlImgTag(PieChartData data, String text, boolean thumb) {
        StringBuilder builder = new StringBuilder("<img src=\"").
                append(getPieChartUrl(data, thumb)).
                append("\" alt=\"").
                append(text).
                append("\" height=\"").
                append(PIE_CHART_MAXI_HEIGHT).
                append("\" width=\"").
                append(PIE_CHART_MAXI_WIDTH).
                append("\" />");

        return builder.toString();
    }

    protected String getBaseUrl() {
        String baseUrl = "http://" + WaoProperty.CHART_SERVER_PATH.getValue() +
                "/chart?";
        return baseUrl;
    }

}
