/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: BoatDataSource.java 462 2010-04-19 23:41:59Z tchemit $
 * $HeadURL: svn+ssh://fdesbois@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-1.3/wao-ui/src/main/java/fr/ifremer/wao/ui/data/BoatDataSource.java $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.service.ServiceBoat;
import java.util.Map;
import org.apache.tapestry5.beaneditor.PropertyModel;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.SortConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * BoatDataSource
 *
 * Created: 19 janv. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 */
public class BoatDataSource extends AbstractMappedGridDataSource<Integer, Boat> {

    private static Logger log = LoggerFactory.getLogger(BoatDataSource.class);

    private BoatFilter filter;

    private ServiceBoat service;

    public BoatDataSource(BoatFilter filter, ServiceBoat service) {
        this.filter = filter;
        this.service = service;
    }


    @Override
    protected Map<Integer, Boat> execute(int startIndex, int endIndex, SortConstraint orderBy) throws WaoException {

        filter.setStartIndex(startIndex);
        filter.setEndIndex(endIndex);

        if (orderBy != null) {
            PropertyModel property = orderBy.getPropertyModel();
            String filterOrder = property.getPropertyName();

            ColumnSort sort = orderBy.getColumnSort();
            if (sort.equals(ColumnSort.DESCENDING)) {
                filterOrder += " desc";
            }

            if (log.isDebugEnabled()) {
                log.debug("Order : " + filterOrder);
            }
            filter.setOrderBy(filterOrder);
        }
        
        return service.getBoatsByFilter(filter);
    }

    @Override
    protected int count() throws WaoException {
        return service.getNbBoatsByFilter(filter);
    }

    @Override
    public Class<?> getRowType() {
        return Boat.class;
    }

}
