/*
 * #%L
 * Wao :: Web Interface
 * 
 * $Id: ZoneUpdater.js 462 2010-04-19 23:41:59Z tchemit $
 * $HeadURL: svn+ssh://fdesbois@labs.libre-entreprise.org/svnroot/suiviobsmer/tags/wao-1.2/wao-ui/src/main/webapp/js/ZoneUpdater.js $
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
/**
 * ZoneUpdater.js
 *
 * From <http://tinybits.blogspot.com/2009/05/update-zone-on-any-client-side-event.html>
 * by Inge Solvoll
 */
var ZoneUpdater = Class.create();

ZoneUpdater.prototype = {

	initialize: function(zoneElementId, listeningElement, event, link, zone, placeholder) {

		this.zoneElement = $(zoneElementId);

		this.event = event;

		this.link = link;

		this.placeholder = placeholder;

		$T(this.zoneElement).zoneId = zone;

		listeningElement.observe(this.event, this.updateZone.bindAsEventListener(this));

	},

	updateZone: function(event) {

	    var zoneObject = Tapestry.findZoneManager(this.zoneElement);

	    if ( !zoneObject ) return;

	    var param;

	    if (this.zoneElement.value) {

	    	param = this.zoneElement.value;

	    }

	    if (!param) param = ' ';

	    param = this.encodeForUrl(param);

	    var updatedLink = this.link.gsub(this.placeholder, param);

	    zoneObject.updateFromURL(updatedLink);

	},

	encodeForUrl: function(string) {

		/**

		 * See equanda.js for updated version of this

		 */

		string = string.replace(/\r\n/g,"\n");

	    var res = "";

	    for (var n = 0; n < string.length; n++)

	    {

	        var c = string.charCodeAt( n );

	        if ( '$' == string.charAt( n ) )

	        {

	            res += '$$';

	        }

	        else if ( this.inRange( c, "AZ" ) || this.inRange( c, "az" ) || this.inRange( c, "09" ) || this.inRange( c, ".." ) )

	        {

	            res += string.charAt( n )

	        }

	        else

	        {

	            var tmp = c.toString(16);

	            while ( tmp.length < 4 ) tmp = "0" + tmp;

	            res += '$' + tmp;

	        }

	    }

	    return res;

	},

	inRange: function(code, range) {

		return code >= range.charCodeAt( 0 ) &&  code <= range.charCodeAt( 1 );

	}

}
