/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.Layout;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.BeanEditForm;
import org.apache.tapestry5.ioc.annotations.Inject;

@IncludeStylesheet(value={"context:css/userProfile.css"})
public class UserProfile
implements WaoPage {
    @Inject
    private ServiceUser serviceUser;
    @InjectComponent
    private Layout layout;
    @SessionState
    private WaoUser user;
    private WaoUser userEditable;
    @InjectComponent
    private BeanEditForm userForm;
    @Property
    private String password;
    @Property
    private String password2;

    public boolean canDisplay() {
        return true;
    }

    public void initialize() {
    }

    public WaoUser getUserEditable() {
        if (this.userEditable == null) {
            this.userEditable = this.user;
        }
        return this.userEditable;
    }

    void onSuccessFromUserForm() throws WaoException {
        if (this.password != null && !this.password.equals(this.password2)) {
            this.userForm.recordError("Les deux password ne sont pas identiques, v\u00e9rifiez la saisie !");
        } else {
            try {
                if (!StringUtils.isEmpty((String)this.password)) {
                    this.userEditable.setPassword(this.password);
                    this.userEditable.setPasswordChanged(true);
                }
                this.serviceUser.createUpdateUser(this.userEditable, false);
                this.layout.addInfo("Modifications enregistr\u00e9es avec succ\u00e8s !");
            }
            catch (WaoBusinessException eee) {
                if (eee.getType().equals((Object)WaoBusinessException.Type.SMTP_NOT_FOUND)) {
                    this.layout.addInfo("Modifications enregistr\u00e9es avec succ\u00e8s !");
                    this.layout.addInfo(eee.getMessage());
                }
                this.userForm.recordError(eee.getMessage());
            }
        }
    }
}

