/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.pages;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.BoatFilter;
import fr.ifremer.wao.bean.BoatFilterImpl;
import fr.ifremer.wao.bean.CompanyBoatInfos;
import fr.ifremer.wao.entity.Boat;
import fr.ifremer.wao.entity.BoatInfos;
import fr.ifremer.wao.entity.Company;
import fr.ifremer.wao.entity.Contact;
import fr.ifremer.wao.entity.ElligibleBoat;
import fr.ifremer.wao.entity.Profession;
import fr.ifremer.wao.entity.SampleRow;
import fr.ifremer.wao.entity.WaoUser;
import fr.ifremer.wao.service.ServiceBoat;
import fr.ifremer.wao.service.ServiceReferential;
import fr.ifremer.wao.service.ServiceSampling;
import fr.ifremer.wao.service.ServiceUser;
import fr.ifremer.wao.ui.base.AbstractFilteredPage;
import fr.ifremer.wao.ui.base.GenericSelectModel;
import fr.ifremer.wao.ui.base.WaoPage;
import fr.ifremer.wao.ui.components.FeedBack;
import fr.ifremer.wao.ui.components.Layout;
import fr.ifremer.wao.ui.data.BoatDataSource;
import fr.ifremer.wao.ui.data.BusinessUtils;
import fr.ifremer.wao.ui.pages.BoatActivityCalendar;
import fr.ifremer.wao.ui.pages.Contacts;
import fr.ifremer.wao.ui.services.WaoManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.InjectPage;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/boats.css"})
public class Boats
extends AbstractFilteredPage
implements WaoPage {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private WaoUser user;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Inject
    private PropertyAccess propertyAccess;
    @Property
    private String sampleRowContextId;
    @Persist(value="flash")
    private Integer boatSelectedImmatriculation;
    @InjectComponent
    private FeedBack filterFeedback;
    @Inject
    private Messages messages;
    @Property
    private UploadedFile boatsCsvFile;
    @Property
    private UploadedFile activityCalendarsCsvFile;
    private InputStream activityCalendarLogFile;
    private InputStream activityCalendarLogAccessFile;
    protected static final String GZIP_MIMETYPE = "application/x-gzip";
    @Persist
    private BoatFilter boatFilter;
    @Persist
    private SampleRow sampleRow;
    @Persist
    private GenericSelectModel<Profession> professionSelectModel;
    @Property
    private String professionId;
    @Persist
    private boolean filtersHidden;
    @InjectComponent
    private Zone filtersZone;
    @Persist
    private BoatDataSource boats;
    @Property
    private Boat boat;
    private boolean even = true;
    @InjectComponent
    private Zone boatsZone;
    @Persist
    private CompanyBoatInfos companyBoatInfos;
    @InjectComponent
    private Zone boatInfosZone;
    @Inject
    private Block displayBoatInfos;
    @Inject
    private Block editBoatInfos;
    @Property
    private ElligibleBoat elligibleBoat;
    @Property
    private String boatInfosSampleRowId;
    private boolean boatInfosEditable;
    private Date boardingFromDate;
    private GenericSelectModel<Company> companies;
    @Inject
    private ServiceUser serviceUser;
    @Property
    @Persist(value="flash")
    private String companySelectedId;
    private Company company;
    @Inject
    private WaoManager manager;
    @InjectPage
    private Contacts contacts;
    @InjectPage
    private BoatActivityCalendar calendarPage;

    public boolean canDisplay() {
        return true;
    }

    public Integer getBoatSelectedImmatriculation() {
        return this.boatSelectedImmatriculation;
    }

    public void setBoatSelectedImmatriculation(Integer boatSelectedImmatriculation) {
        this.boatSelectedImmatriculation = boatSelectedImmatriculation;
    }

    void setupRender() throws WaoException {
        this.sampleRow = null;
        this.getSampleRow();
        this.professionSelectModel = null;
        this.getProfessionSelectModel();
        if (this.isSampleRowExists()) {
            this.getFilter().setSampleRow(this.sampleRow);
            this.filtersHidden = false;
            this.boats = null;
            this.filterFeedback.addInfo("Vous \u00eates en cours de s\u00e9lection d'un navire pour la ligne du plan " + this.sampleRow.getCode());
            this.professionId = this.getSampleRow().getProfession().getTopiaId();
        }
        this.initSelectFilters(false, false, false);
        this.companyBoatInfos = null;
    }

    void onActivate(EventContext ec) {
        this.sampleRowContextId = (String)ec.get(String.class, 0);
    }

    String onPassivate() {
        return this.sampleRowContextId;
    }

    public boolean canImportReferentials() {
        return this.user.isAdmin() && !this.user.getReadOnly();
    }

    @Log
    void onSuccessFromImportBoatsForm() {
        if (this.canImportReferentials()) {
            try {
                int[] result = this.serviceBoat.importBoatCsv(this.boatsCsvFile.getStream());
                this.boats = null;
                this.layout.addInfo(result[0] + " navires import\u00e9s dont " + result[1] + " nouveaux");
            }
            catch (WaoBusinessException eee) {
                String error = BusinessUtils.getErrorMessage((WaoBusinessException)eee, (Messages)this.messages, (Logger)this.log);
                this.layout.addError(new String[]{error});
            }
        }
    }

    InputStream getActivityCalendarLogFile() throws FileNotFoundException {
        if (this.activityCalendarLogFile == null) {
            this.activityCalendarLogFile = this.serviceBoat.getActivityCalendarLogFile();
        }
        return this.activityCalendarLogFile;
    }

    public boolean isLogFileExists() {
        try {
            this.getActivityCalendarLogFile();
            return true;
        }
        catch (FileNotFoundException eee) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Aucun fichier de log existant pour les calendriers d'activit\u00e9");
            }
            return false;
        }
    }

    InputStream getActivityCalendarLogAccessFile() throws FileNotFoundException {
        if (this.activityCalendarLogAccessFile == null) {
            this.activityCalendarLogAccessFile = this.serviceBoat.getActivityCalendarLogAccessFile();
        }
        return this.activityCalendarLogAccessFile;
    }

    public boolean isLogAccessFileExists() {
        try {
            this.getActivityCalendarLogAccessFile();
            return true;
        }
        catch (FileNotFoundException eee) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Aucun fichier de log existant pour les acc\u00e8s utilisateurs aux calendriers d'activit\u00e9");
            }
            return false;
        }
    }

    @Log
    void onSuccessFromImportActivityCalendarsForm() throws WaoException, IOException {
        if (this.canImportReferentials()) {
            InputStream input = this.activityCalendarsCsvFile.getStream();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Content type : " + this.activityCalendarsCsvFile.getContentType());
            }
            if (this.activityCalendarsCsvFile.getContentType().equals(GZIP_MIMETYPE)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Gzip file");
                }
                input = new GZIPInputStream(input);
            }
            this.serviceBoat.importActivityCalendarCsv(input);
            this.companyBoatInfos = null;
        }
    }

    public StreamResponse onActionFromShowActivityCalendarLogFile() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public StreamResponse onActionFromShowActivityCalendarLogAccessFile() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public BoatFilter getFilter() throws WaoException {
        if (this.boatFilter == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Create filter");
            }
            this.boatFilter = new BoatFilterImpl();
            this.boatFilter.setNbMonthFinishedFromToday(Integer.valueOf(-1));
        }
        return this.boatFilter;
    }

    protected boolean isAvailableDataForFiltersOnly() {
        return true;
    }

    public SampleRow getSampleRow() throws WaoException {
        if (this.sampleRow == null && !StringUtils.isEmpty((String)this.sampleRowContextId)) {
            this.sampleRow = this.serviceSampling.getSampleRow(this.sampleRowContextId);
        }
        return this.sampleRow;
    }

    public boolean isSampleRowExists() throws WaoException {
        return this.getSampleRow() != null;
    }

    public GenericSelectModel<Profession> getProfessionSelectModel() throws WaoException {
        if (this.professionSelectModel == null) {
            List professions = this.serviceReferential.getProfessions();
            this.professionSelectModel = new GenericSelectModel(professions, Profession.class, "code", "topiaId", this.propertyAccess);
        }
        return this.professionSelectModel;
    }

    public boolean isFiltersHidden() {
        return this.filtersHidden;
    }

    public String getHiddenStyle() {
        return this.isFiltersHidden() ? "hidden" : "";
    }

    Block onActionFromShowFilters() {
        this.filtersHidden = false;
        return this.filtersZone.getBody();
    }

    Block onActionFromHideFilters() {
        this.filtersHidden = true;
        return this.filtersZone.getBody();
    }

    void onSelectedFromReset() {
        this.boatFilter = null;
        this.sampleRowContextId = null;
    }

    public void onSelectedFromSearch() throws WaoException {
        super.onSelectedFromSearch();
        if (this.log.isDebugEnabled()) {
            this.log.debug("FILTER : facadeName=" + this.boatFilter.getFacadeName());
            this.log.debug("FILTER : sectorName=" + this.boatFilter.getSectorName());
            this.log.debug("FILTER : sampleRow=" + this.boatFilter.getSampleRow());
            this.log.debug("FILTER : profession=" + this.boatFilter.getProfession());
            this.log.debug("FILTER : boatName=" + this.boatFilter.getBoatName());
            this.log.debug("FILTER : boatImmatriculation=" + this.boatFilter.getBoatImmatriculation());
            this.log.debug("FILTER : boatDistrictCode=" + this.boatFilter.getBoatDistrictCode());
            this.log.debug("FILTER : company=" + this.boatFilter.getCompany());
        }
        Profession profession = (Profession)this.getProfessionSelectModel().findObject(this.professionId);
        this.boatFilter.setProfession(profession);
    }

    Object onSuccessFromFiltersForm() throws WaoException {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        this.boats = null;
        this.boatSelectedImmatriculation = null;
        this.companyBoatInfos = null;
        return this;
    }

    public BoatDataSource getBoats() throws WaoException {
        if (this.boats == null) {
            this.boats = new BoatDataSource(this.getFilter(), this.serviceBoat);
        }
        return this.boats;
    }

    public String getRowStyle() {
        String result = "";
        boolean bl = this.even = !this.even;
        result = this.boatSelectedImmatriculation != null && this.boat.getImmatriculation() == this.boatSelectedImmatriculation.intValue() ? "selected" : (!this.boat.getActive() ? "refused" : (this.even ? "even" : "odd"));
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public boolean canCreateNewContactFromList() throws WaoException {
        if (!this.user.isAdmin() && !this.user.getReadOnly() && this.isSampleRowExists()) {
            return this.boat.canCreateContact(this.user.getCompany());
        }
        return false;
    }

    StreamResponse onActionFromExportShowBoats() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    Block onActionFromShowBoatInfos(Integer boatImma) throws WaoException {
        this.boatSelectedImmatriculation = boatImma;
        this.companyBoatInfos = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Show infos for boat : " + boatImma);
        }
        if (this.user.isAdmin() && this.getCompany() != null) {
            this.companySelectedId = this.getCompany().getTopiaId();
        }
        return this.boatsZone.getBody();
    }

    public boolean isActivityCalendarImportRun() {
        return this.manager.isActivityCalendarImportRun();
    }

    public Block getActiveBoatInfosBlock() {
        if (this.boatInfosEditable) {
            return this.editBoatInfos;
        }
        return this.displayBoatInfos;
    }

    public CompanyBoatInfos getCompanyBoatInfos() throws WaoException {
        if (this.companyBoatInfos == null && this.boatSelectedImmatriculation != null && this.getCompany() != null) {
            this.companyBoatInfos = this.serviceBoat.getCompanyBoatInfos(this.boatSelectedImmatriculation.intValue(), this.getCompany());
        }
        return this.companyBoatInfos;
    }

    public GenericSelectModel<Company> getCompanies() throws WaoException {
        if (this.companies == null) {
            List results = this.serviceUser.getCompanies(true);
            this.companies = new GenericSelectModel(results, Company.class, "name", "topiaId", this.propertyAccess);
        }
        return this.companies;
    }

    public Company getCompany() throws WaoException {
        if (this.company == null) {
            if (StringUtils.isNotEmpty((String)this.companySelectedId)) {
                this.company = (Company)this.getCompanies().findObject(this.companySelectedId);
            } else if (!this.user.isAdmin()) {
                this.company = this.user.getCompany();
            }
        }
        return this.company;
    }

    public Boat getBoatSelected() throws WaoException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("selected imma : " + this.boatSelectedImmatriculation);
            this.log.debug("exist boat ? : " + this.getBoats().contains((Object)this.boatSelectedImmatriculation));
        }
        return (Boat)this.getBoats().get((Object)this.boatSelectedImmatriculation);
    }

    public Date getBoardingFromDate() {
        if (this.boardingFromDate == null) {
            GregorianCalendar calendar = new GregorianCalendar();
            ((Calendar)calendar).add(2, -12);
            this.boardingFromDate = calendar.getTime();
        }
        return this.boardingFromDate;
    }

    public void setBoardingFromDate(Date boardingFromDate) {
        this.boardingFromDate = boardingFromDate;
    }

    public BoatInfos getBoatInfos() throws WaoException {
        if (this.getCompanyBoatInfos() == null) {
            return null;
        }
        return this.getCompanyBoatInfos().getBoatInfos();
    }

    public String getlastContactStyle() throws WaoException {
        Contact contact = this.getCompanyBoatInfos().getLastContact();
        return BusinessUtils.getContactStyle((Contact)contact, (boolean)this.user.isAdmin());
    }

    public String getElligibleRowInfos() {
        return BusinessUtils.getTooltipSampleRow((SampleRow)this.elligibleBoat.getSampleRow());
    }

    public boolean isElligibleBoatCompanyActiveFalse() {
        return BooleanUtils.isFalse((Boolean)this.elligibleBoat.getCompanyActive());
    }

    public boolean canCreateNewContactFromElligibleBoat() throws WaoException {
        if (!(this.user.isAdmin() || this.user.getReadOnly() || this.isElligibleBoatCompanyActiveFalse())) {
            Boat currentBoat = this.getBoatInfos().getBoat();
            return currentBoat.canCreateContact(this.user.getCompany());
        }
        return false;
    }

    public String getElligibleRowStyle() {
        boolean condition1 = this.elligibleBoat.getCompanyActive() == null && !this.elligibleBoat.getGlobalActive();
        return condition1 || this.isElligibleBoatCompanyActiveFalse() ? "line-through" : "";
    }

    public boolean canEditBoatInfos() {
        return !this.user.getReadOnly();
    }

    void onSuccess() throws WaoException {
        if (this.getBoatInfos() != null) {
            this.boatSelectedImmatriculation = this.getBoatInfos().getBoat().getImmatriculation();
        }
    }

    Block onSuccessFromCompanySelectForm() throws WaoException {
        this.companyBoatInfos = null;
        this.getCompanyBoatInfos();
        return this.boatInfosZone.getBody();
    }

    Block onActionFromEditBoatInfos() throws WaoException {
        if (this.canEditBoatInfos()) {
            this.boatInfosEditable = true;
            this.getFilter().setNbMonthFinishedFromToday(null);
            this.resetSampleRowSelect();
            this.getFilter().setNbMonthFinishedFromToday(Integer.valueOf(-1));
        }
        return this.boatInfosZone.getBody();
    }

    Block onActionFromCancelEditBoatInfos() throws WaoException {
        this.boatSelectedImmatriculation = this.getBoatInfos().getBoat().getImmatriculation();
        this.companyBoatInfos = null;
        return this.boatInfosZone.getBody();
    }

    void onSelectedFromAddBoatInfosSampleRow() throws WaoException {
        this.boatInfosEditable = true;
        if (StringUtils.isNotEmpty((String)this.boatInfosSampleRowId)) {
            SampleRow row = (SampleRow)this.getSampleRowSelectModel().findObject(this.boatInfosSampleRowId);
            this.companyBoatInfos.setNewElligibleBoat(row);
        }
    }

    void onSelectedFromRemoveBoatInfosSampleRow(String sampleRowCode) throws WaoException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.removeElligibleBoat(sampleRowCode);
    }

    void onSelectedFromActiveBoatInfosSampleRow(String sampleRowCode) throws WaoException {
        this.boatInfosEditable = true;
        this.companyBoatInfos.activeElligibleBoat(sampleRowCode);
    }

    Block onSuccessFromBoatInfosForm() throws WaoException {
        if (!this.boatInfosEditable && this.canEditBoatInfos()) {
            this.serviceBoat.createUpdateCompanyBoatInfos(this.companyBoatInfos);
        }
        return this.boatInfosZone.getBody();
    }

    Block onSuccessFromCalculateBoardings() throws WaoException {
        return this.boatInfosZone.getBody();
    }

    Object onActionFromAddNewContactFromBoat(int boatImmatriculation) throws WaoException {
        this.sampleRow = this.getSampleRow();
        this.boat = (Boat)this.getBoats().get((Object)boatImmatriculation);
        this.contacts.createNewContact(this.boat, this.sampleRow);
        return this.contacts;
    }

    Object onActionFromAddNewContactFromSampleRow(String sampleRowCode) throws WaoException {
        ElligibleBoat elligible = this.getCompanyBoatInfos().getElligibleBoat(sampleRowCode);
        this.sampleRow = elligible.getSampleRow();
        this.contacts.createNewContact(this.getBoatSelected(), this.sampleRow);
        return this.contacts;
    }

    public boolean hasActivityCalendar() throws WaoException {
        return this.getBoatSelected().sizeActivityCalendar() != 0;
    }

    Object onActionFromShowLastActivityCalendar() throws WaoException {
        this.calendarPage.setBoat(this.getBoatSelected());
        return this.calendarPage;
    }

    static /* synthetic */ Logger access$000(Boats x0) {
        return x0.log;
    }

    static /* synthetic */ ServiceBoat access$100(Boats x0) {
        return x0.serviceBoat;
    }
}

