/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.io.UnsupportedEncodingException;
import org.eclipse.birt.report.model.api.OdaDesignerStateHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.core.Structure;

public class OdaDesignerState
extends Structure {
    public static final String STRUCTURE_NAME = "OdaDesignerState";
    public static final String VERSION_MEMBER = "version";
    public static final String CONTENT_AS_STRING_MEMBER = "stateContentAsString";
    public static final String CONTENT_AS_BLOB_MEMBER = "stateContentAsBlob";
    public static final String CHARSET = "8859_1";
    private String version = null;
    private String contentAsString = null;
    private String contentAsBlob = null;

    public OdaDesignerState(String version, String contentAsString, String contentAsBlob) {
        this.version = version;
        this.contentAsBlob = contentAsBlob;
        this.contentAsString = contentAsString;
    }

    public OdaDesignerState() {
    }

    @Override
    public String getStructName() {
        return STRUCTURE_NAME;
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if (VERSION_MEMBER.equals(propName)) {
            return this.version;
        }
        if (CONTENT_AS_BLOB_MEMBER.equals(propName)) {
            return this.contentAsBlob;
        }
        if (CONTENT_AS_STRING_MEMBER.equals(propName)) {
            return this.contentAsString;
        }
        assert (false);
        return null;
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if (VERSION_MEMBER.equals(propName)) {
            this.version = (String)value;
        } else if (CONTENT_AS_BLOB_MEMBER.equals(propName)) {
            this.contentAsBlob = (String)value;
        } else if (CONTENT_AS_STRING_MEMBER.equals(propName)) {
            this.contentAsString = (String)value;
        } else assert (false);
    }

    public String getVersion() {
        return (String)this.getProperty(null, VERSION_MEMBER);
    }

    public void setVersion(String version) {
        this.setProperty(VERSION_MEMBER, (Object)version);
    }

    public byte[] getContentAsBlob() {
        if (this.contentAsBlob == null) {
            return null;
        }
        try {
            return this.contentAsBlob.getBytes(CHARSET);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
    }

    public void setContentAsBlob(byte[] contentBlob) {
        if (contentBlob != null) {
            try {
                this.contentAsBlob = new String(contentBlob, CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.contentAsBlob = null;
                assert (false);
            }
        } else {
            this.contentAsBlob = null;
        }
    }

    public String getContentAsString() {
        return (String)this.getProperty(null, CONTENT_AS_STRING_MEMBER);
    }

    public void setContentAsString(String contentString) {
        this.setProperty(CONTENT_AS_STRING_MEMBER, (Object)contentString);
    }

    @Override
    public StructureHandle getHandle(SimpleValueHandle valueHandle) {
        return new OdaDesignerStateHandle(valueHandle.getElementHandle(), this.getContext());
    }

    @Override
    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        assert (false);
        return null;
    }
}

