/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx.writer;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.emitter.ppt.util.PPTUtil;
import org.eclipse.birt.report.engine.emitter.pptx.util.PPTXUtil;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Component;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Presentation;
import org.eclipse.birt.report.engine.emitter.pptx.writer.SlideLayout;
import org.eclipse.birt.report.engine.layout.emitter.Image;
import org.eclipse.birt.report.engine.layout.emitter.util.BackgroundImageLayout;
import org.eclipse.birt.report.engine.layout.emitter.util.Position;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.ooxml.IPart;
import org.eclipse.birt.report.engine.ooxml.ImageManager;
import org.eclipse.birt.report.engine.ooxml.util.OOXmlUtil;

public class Slide
extends Component {
    private static final String TAG_SLIDE = "p:sld";
    private static Logger logger = Logger.getLogger(Slide.class.getName());
    private int index;
    private Presentation presentation;
    private int shapeCount = 1;
    private boolean isClosed = false;
    private ImageManager imageManager;
    private Stack<ClipArea> clipStack = new Stack();

    public Slide(Presentation presentation, int slideIndex) throws IOException {
        this(presentation, slideIndex, null);
    }

    public Slide(Presentation presentation, int slideIndex, Color bgColor) throws IOException {
        this.index = slideIndex;
        this.presentation = presentation;
        String uri = this.getSlideUri(this.index);
        String relationShipType = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/slide";
        String type = "application/vnd.openxmlformats-officedocument.presentationml.slide+xml";
        this.initialize(presentation.getPart(), uri, type, relationShipType);
        new SlideLayout(this, this.index);
        this.imageManager = (ImageManager)this.part.getPackage().getExtensionData();
        this.writer.startWriter();
        this.writer.openTag(TAG_SLIDE);
        this.writer.nameSpace("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
        this.writer.nameSpace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
        this.writer.nameSpace("p", "http://schemas.openxmlformats.org/presentationml/2006/main");
        this.writer.openTag("p:cSld");
        if (bgColor != null) {
            this.drawSlideBackgroundColor(bgColor);
        }
        this.writer.openTag("p:spTree");
        this.writer.openTag("p:nvGrpSpPr");
        this.writer.openTag("p:cNvPr");
        this.writer.attribute("id", this.nextShapeId());
        this.writer.attribute("name", "");
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvGrpSpPr");
        this.writer.closeTag("p:cNvGrpSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvGrpSpPr");
        this.writer.openTag("p:grpSpPr");
        this.writer.closeTag("p:grpSpPr");
    }

    private void drawSlideBackgroundColor(Color color) {
        this.writer.openTag("p:bg");
        this.writer.openTag("p:bgPr");
        this.setColor(color);
        this.writer.openTag("a:effectLst");
        this.writer.closeTag("a:effectLst");
        this.writer.closeTag("p:bgPr");
        this.writer.closeTag("p:bg");
    }

    public void drawLine(int startX, int startY, int endX, int endY, int width, Color color, int lineStyle) {
        if (color == null || (float)width == 0.0f || lineStyle == 28) {
            return;
        }
        this.writer.openTag("p:cxnSp");
        this.writer.openTag("p:nvCxnSpPr");
        this.writer.openTag("p:cNvPr");
        int shapeId = this.nextShapeId();
        this.writer.attribute("id", shapeId);
        this.writer.attribute("name", "Line " + shapeId);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvCxnSpPr");
        this.writer.closeTag("p:cNvCxnSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvCxnSpPr");
        this.writer.openTag("p:spPr");
        this.setPosition(startX, startY, endX - startX, endY - startY);
        this.writer.openTag("a:prstGeom");
        this.writer.attribute("prst", "line");
        this.writer.closeTag("a:prstGeom");
        this.setProperty(color, width, lineStyle);
        this.writer.closeTag("p:spPr");
        this.writer.closeTag("p:cxnSp");
    }

    public void drawText(String text, int textX, int textY, int width, int height, String fontName, float fontSize, int fontStyle, Color color, boolean isUnderline, boolean isLineThrough, PPTUtil.HyperlinkDef link) {
        this.writer.openTag("p:sp");
        this.writer.openTag("p:nvSpPr");
        this.writer.openTag("p:cNvPr");
        int shapeId = this.nextShapeId();
        this.writer.attribute("id", shapeId);
        this.writer.attribute("name", "TextBox " + shapeId);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvSpPr");
        this.writer.attribute("txBox", "1");
        this.writer.closeTag("p:cNvSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvSpPr");
        this.writer.openTag("p:spPr");
        this.setPosition(textX, textY, width + 1, height);
        this.writer.openTag("a:prstGeom");
        this.writer.attribute("prst", "rect");
        this.writer.closeTag("a:prstGeom");
        this.writer.closeTag("p:spPr");
        this.writer.openTag("p:txBody");
        this.writer.openTag("a:bodyPr");
        this.writer.attribute("wrap", "none");
        this.writer.attribute("lIns", "0");
        this.writer.attribute("tIns", "0");
        this.writer.attribute("rIns", "0");
        this.writer.attribute("bIns", "0");
        this.writer.attribute("rtlCol", "0");
        this.writer.closeTag("a:bodyPr");
        this.writer.openTag("a:p");
        this.writer.openTag("a:r");
        this.setTextProperty(fontName, fontSize, fontStyle, color, isUnderline, isLineThrough, link);
        this.writer.openTag("a:t");
        this.writeText(text);
        this.writer.closeTag("a:t");
        this.writer.closeTag("a:r");
        this.writer.closeTag("a:p");
        this.writer.closeTag("p:txBody");
        this.writer.closeTag("p:sp");
    }

    private void writeText(String text) {
        int length = text.length();
        StringBuilder sb = new StringBuilder(length * 2);
        int i = 0;
        while (i < length) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    break;
                }
                case '>': {
                    sb.append("&gt;");
                    break;
                }
                case '<': {
                    sb.append("&lt;");
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        this.writer.cdata(sb.toString());
    }

    public void drawImage(String uri, String extension, int imageX, int imageY, int height, int width, String helpText, PPTUtil.HyperlinkDef link) throws IOException {
        byte[] imageData = EmitterUtil.getImageData(uri);
        IPart imagePart = this.imageManager.getImagePart(this.part, uri, imageData).getPart();
        this.drawImage(imagePart, imageX, imageY, height, width, helpText, true, link);
    }

    public void drawImage(String imageId, byte[] imageData, String extension, int imageX, int imageY, int height, int width, String helpText, PPTUtil.HyperlinkDef link) throws IOException {
        this.drawImage(imageId, imageData, extension, imageX, imageY, height, width, helpText, true, link);
    }

    private void drawImage(String imageId, byte[] imageData, String extension, int imageX, int imageY, int height, int width, String helpText, boolean stretch, PPTUtil.HyperlinkDef link) throws IOException {
        IPart imagePart = this.imageManager.getImagePart(this.part, imageId, imageData).getPart();
        this.drawImage(imagePart, imageX, imageY, height, width, helpText, stretch, link);
    }

    private Crop checkCrop(int x, int y, int width, int height) {
        if (this.clipStack.isEmpty()) {
            return null;
        }
        ClipArea clip = this.clipStack.peek();
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (x < clip.x) {
            left = (int)((float)(clip.x - x) / (float)width * 100000.0f);
        }
        if (y < clip.y) {
            top = (int)((float)(clip.y - y) / (float)height * 100000.0f);
        }
        if (x + width > clip.x + clip.width) {
            right = (int)((float)(x + width - (clip.x + clip.width)) / (float)width * 100000.0f);
        }
        if (y + height > clip.y + clip.height) {
            bottom = (int)((float)(y + height - (clip.y + clip.height)) / (float)height * 100000.0f);
        }
        if (left != 0 || right != 0 || top != 0 || bottom != 0) {
            return new Crop(left, right, top, bottom);
        }
        return null;
    }

    private void drawImage(IPart imagePart, int imageX, int imageY, int height, int width, String helpText, boolean stretch, PPTUtil.HyperlinkDef link) {
        String relationshipId = imagePart.getRelationshipId();
        this.writer.openTag("p:pic");
        this.writer.openTag("p:nvPicPr");
        this.writer.openTag("p:cNvPr");
        int shapeId = this.nextShapeId();
        this.writer.attribute("id", shapeId);
        this.writer.attribute("name", "Image " + shapeId);
        this.writer.attribute("descr", helpText);
        this.setHyperlink(link);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvPicPr");
        this.writer.openTag("a:picLocks");
        this.writer.attribute("noChangeAspect", "1");
        this.writer.closeTag("a:picLocks");
        this.writer.closeTag("p:cNvPicPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvPicPr");
        this.writer.openTag("p:blipFill");
        Crop crop = this.checkCrop(imageX, imageY, width, height);
        if (crop != null) {
            this.writer.attribute("rotWithShape", "1");
        }
        this.writer.openTag("a:blip");
        this.writer.attribute("r:embed", relationshipId);
        this.writer.closeTag("a:blip");
        if (crop != null) {
            this.writer.openTag("a:srcRect");
            if (crop.top != 0) {
                this.writer.attribute("t", crop.top);
            }
            if (crop.left != 0) {
                this.writer.attribute("l", crop.left);
            }
            if (crop.right != 0) {
                this.writer.attribute("r", crop.right);
            }
            if (crop.bottom != 0) {
                this.writer.attribute("b", crop.bottom);
            }
            this.writer.closeTag("a:srcRect");
        }
        if (stretch) {
            this.writer.openTag("a:stretch");
            this.writer.closeTag("a:stretch");
        }
        this.writer.closeTag("p:blipFill");
        this.writer.openTag("p:spPr");
        if (crop == null) {
            this.setPosition(imageX, imageY, width, height);
        } else {
            ClipArea clip = this.clipStack.peek();
            int pX = Math.max(clip.x, imageX);
            int pY = Math.max(clip.y, imageY);
            int pWidth = Math.min(imageX + width, clip.x + clip.width) - pX;
            int pHeight = Math.min(imageY + height, clip.y + clip.height) - pY;
            this.setPosition(pX, pY, pWidth, pHeight);
        }
        this.writer.openTag("a:prstGeom");
        this.writer.attribute("prst", "rect");
        this.writer.closeTag("a:prstGeom");
        this.writer.closeTag("p:spPr");
        this.writer.closeTag("p:pic");
    }

    public void drawBackgroundColor(Color color, int x, int y, int width, int height) {
        if (color != null) {
            this.writer.openTag("p:sp");
            this.writer.openTag("p:nvSpPr");
            this.writer.openTag("p:cNvPr");
            int shapeId = this.nextShapeId();
            this.writer.attribute("id", shapeId);
            this.writer.attribute("name", "Rectangle " + shapeId);
            this.writer.closeTag("p:cNvPr");
            this.writer.openTag("p:cNvSpPr");
            this.writer.closeTag("p:cNvSpPr");
            this.writer.openTag("p:nvPr");
            this.writer.closeTag("p:nvPr");
            this.writer.closeTag("p:nvSpPr");
            this.writer.openTag("p:spPr");
            this.setPosition(x, y, width, height);
            this.writer.openTag("a:prstGeom");
            this.writer.attribute("prst", "rect");
            this.writer.closeTag("a:prstGeom");
            this.setColor(color);
            this.writer.closeTag("p:spPr");
            this.writer.closeTag("p:sp");
        }
    }

    public void drawBackgroundImage(int x, int y, int width, int height, int imageWidth, int imageHeight, int repeat, String imageURI, byte[] imageData, int offsetX, int offsetY) {
        if (imageURI == null || imageURI.length() == 0) {
            return;
        }
        if (imageData == null || imageData.length == 0) {
            return;
        }
        try {
            if (!this.imageManager.hasImage(imageURI)) {
                Image image = EmitterUtil.parseImage(imageData, null, null);
                imageData = image.getData();
            }
            ImageManager.ImagePart imagePartInfo = this.imageManager.getImagePart(this.part, imageURI, imageData);
            Image imageInfo = imagePartInfo.getImageInfo();
            float originalImageWidth = imageWidth != 0 ? imageWidth : imageInfo.getWidth();
            float originalImageHeight = imageHeight != 0 ? imageHeight : imageInfo.getHeight();
            Position areaPosition = new Position(x, y);
            Position areaSize = new Position(width, height);
            Position imagePosition = new Position(x + offsetX, y + offsetY);
            Position imageSize = new Position(originalImageWidth, originalImageHeight);
            BackgroundImageLayout layout = new BackgroundImageLayout(areaPosition, areaSize, imagePosition, imageSize);
            List<Position> positions = layout.getImagePositions(repeat);
            for (Position position : positions) {
                this.fillRectangleWithImage(imagePartInfo, (int)OOXmlUtil.convertPointerToEmus(position.getX()), (int)OOXmlUtil.convertPointerToEmus(position.getY()), (int)OOXmlUtil.convertPointerToEmus(originalImageWidth), (int)OOXmlUtil.convertPointerToEmus(originalImageHeight), 0, 0);
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private float getImageRange(float maxRange, float offset, float imageSize) {
        float result = imageSize;
        if (offset < 0.0f) {
            result = Math.max(0.0f, imageSize + offset);
        } else if (offset + imageSize > maxRange) {
            result = Math.max(0.0f, maxRange - offset);
        }
        return result;
    }

    private boolean isOutOfRange(float maxRange, float offset, float imageSize) {
        return offset <= 0.0f - imageSize || offset >= maxRange;
    }

    private void fillRectangleWithImage(ImageManager.ImagePart imageInfo, int x, int y, int width, int height, int offsetX, int offsetY) {
        this.writer.openTag("p:sp");
        this.writer.openTag("p:nvSpPr");
        this.writer.openTag("p:cNvPr");
        int shapeId = this.nextShapeId();
        this.writer.attribute("id", shapeId);
        this.writer.attribute("name", "Rectangle " + shapeId);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvSpPr");
        this.writer.closeTag("p:cNvSpPr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvSpPr");
        this.writer.openTag("p:spPr");
        this.setPosition(x, y, width, height);
        this.writer.openTag("a:prstGeom");
        this.writer.attribute("prst", "rect");
        this.writer.closeTag("a:prstGeom");
        this.writer.openTag("a:blipFill");
        this.writer.attribute("dpi", "0");
        this.writer.attribute("rotWithShape", "1");
        this.writer.openTag("a:blip");
        this.writer.attribute("r:embed", imageInfo.getPart().getRelationshipId());
        this.writer.closeTag("a:blip");
        this.writer.openTag("a:stretch");
        this.writer.openTag("a:fillRect");
        this.writer.closeTag("a:fillRect");
        this.writer.closeTag("a:stretch");
        this.writer.closeTag("a:blipFill");
        this.writer.openTag("a:ln");
        this.writer.openTag("a:noFill");
        this.writer.closeTag("a:noFill");
        this.writer.closeTag("a:ln");
        this.writer.closeTag("p:spPr");
        this.writer.closeTag("p:sp");
    }

    private void setTextProperty(String fontName, float fontSize, int fontStyle, Color color, boolean isUnderline, boolean isLineThrough, PPTUtil.HyperlinkDef link) {
        boolean isBold;
        this.writer.openTag("a:rPr");
        this.writer.attribute("lang", "en-US");
        this.writer.attribute("altLang", "zh-CN");
        this.writer.attribute("dirty", "0");
        this.writer.attribute("smtClean", "0");
        if (isLineThrough) {
            this.writer.attribute("strike", "sngStrike");
        }
        if (isUnderline) {
            this.writer.attribute("u", "sng");
        }
        this.writer.attribute("sz", (int)(fontSize * 100.0f));
        boolean isItalic = (fontStyle & 2) != 0;
        boolean bl = isBold = (fontStyle & 1) != 0;
        if (isItalic) {
            this.writer.attribute("i", 1);
        }
        if (isBold) {
            this.writer.attribute("b", 1);
        }
        this.setColor(color);
        this.setTextFont(fontName);
        this.setHyperlink(link);
        this.writer.closeTag("a:rPr");
    }

    private void setHyperlink(PPTUtil.HyperlinkDef link) {
        String hyperlink;
        if (link != null && (hyperlink = link.getLink()) != null) {
            if (hyperlink.startsWith("\"") && hyperlink.endsWith("\"")) {
                hyperlink = hyperlink.substring(1, hyperlink.length() - 1);
            }
            this.writer.openTag("a:hlinkClick");
            this.writer.attribute("r:id", this.part.getHyperlinkId(hyperlink));
            if (link.getTooltip() != null) {
                this.writer.attribute("tooltip", link.getTooltip());
            }
            this.writer.closeTag("a:hlinkClick");
        }
    }

    private void setTextFont(String fontName) {
        this.writer.openTag("a:latin");
        this.writer.attribute("typeface", fontName);
        this.writer.attribute("pitchFamily", "18");
        this.writer.attribute("charset", "0");
        this.writer.closeTag("a:latin");
        this.writer.openTag("a:cs");
        this.writer.attribute("typeface", fontName);
        this.writer.attribute("pitchFamily", "18");
        this.writer.attribute("charset", "0");
        this.writer.closeTag("a:cs");
    }

    private void setColor(Color color) {
        if (color != null) {
            this.writer.openTag("a:solidFill");
            this.writer.openTag("a:srgbClr");
            this.writer.attribute("val", EmitterUtil.getColorString(color));
            this.writer.closeTag("a:srgbClr");
            this.writer.closeTag("a:solidFill");
        }
    }

    private void setPosition(int startX, int startY, int width, int height) {
        this.writer.openTag("a:xfrm");
        this.writer.openTag("a:off");
        this.writer.attribute("x", startX);
        this.writer.attribute("y", startY);
        this.writer.closeTag("a:off");
        this.writer.openTag("a:ext");
        this.writer.attribute("cx", width);
        this.writer.attribute("cy", height);
        this.writer.closeTag("a:ext");
        this.writer.closeTag("a:xfrm");
    }

    private void setProperty(Color color, int width, int style) {
        this.writer.openTag("a:ln");
        this.writer.attribute("w", width);
        this.setColor(color);
        if (style == 20) {
            this.setStyle("sysDash");
        } else if (style == 22) {
            this.setStyle("dash");
        }
        this.writer.closeTag("a:ln");
    }

    private void setStyle(String lineStyle) {
        this.writer.openTag("a:prstDash");
        this.writer.attribute("val", lineStyle);
        this.writer.closeTag("a:prstDash");
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    private String getSlideUri(int slideIndex) {
        return "slides/slide" + slideIndex + ".xml";
    }

    public int getSlideId() {
        return 255 + this.index;
    }

    public void dispose() {
        if (!this.isClosed) {
            this.writer.closeTag("p:spTree");
            this.writer.closeTag("p:cSld");
            this.writer.openTag("p:clrMapOvr");
            this.writer.openTag("a:masterClrMapping");
            this.writer.closeTag("a:masterClrMapping");
            this.writer.closeTag("p:clrMapOvr");
            this.writer.closeTag(TAG_SLIDE);
            this.writer.endWriter();
            this.writer.close();
            this.writer = null;
            this.isClosed = true;
        }
    }

    private int nextShapeId() {
        return this.shapeCount++;
    }

    public void drawText(String text, int textX, int textY, int width, int height, TextStyle textStyle, PPTUtil.HyperlinkDef link) {
        FontInfo fontInfo = textStyle.getFontInfo();
        String fontName = fontInfo.getFontName();
        float fontSize = fontInfo.getFontSize();
        int fontStyle = fontInfo.getFontStyle();
        Color color = textStyle.getColor();
        this.drawText(text, textX, textY, width, height, fontName, fontSize, fontStyle, color, textStyle.isUnderline(), textStyle.isLinethrough(), link);
    }

    public void startClip(int startX, int startY, int width, int height) {
        startX = PPTXUtil.convertToEnums(startX);
        startY = PPTXUtil.convertToEnums(startY);
        width = PPTXUtil.convertToEnums(width);
        height = PPTXUtil.convertToEnums(height);
        if (this.clipStack.isEmpty()) {
            this.clipStack.push(new ClipArea(startX, startY, width, height));
        } else {
            ClipArea parent = this.clipStack.peek();
            int newX = Math.max(parent.x, startX);
            int newY = Math.max(parent.y, startY);
            int newWidth = Math.min(startX + width, parent.x + parent.width) - newX;
            int newHeight = Math.min(startY + height, parent.y + parent.height) - newY;
            this.clipStack.push(new ClipArea(newX, newY, newWidth, newHeight));
        }
    }

    public void endClip() {
        this.clipStack.pop();
    }

    private class ClipArea {
        int x;
        int y;
        int width;
        int height;

        ClipArea(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    private class Crop {
        int left;
        int right;
        int top;
        int bottom;

        Crop(int left, int right, int top, int bottom) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        }
    }
}

