/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity.domain;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.simulator.sensitivity.Distribution;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.DomainVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContinuousDomain
implements Domain {
    private static Log log = LogFactory.getLog(ContinuousDomain.class);
    private static final long serialVersionUID = -2037768174807839046L;
    protected Distribution distribution;
    protected Map<String, Object> distributionParameters = new HashMap<String, Object>();

    public ContinuousDomain() {
    }

    public ContinuousDomain(Distribution distribution) {
        this();
        this.distribution = distribution;
    }

    public ContinuousDomain(Distribution distribution, SortedMap<String, Object> distributionParameters) {
        this(distribution);
        this.setDistributionParams(distributionParameters);
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public Map<String, Object> getDistributionParameters() {
        return this.distributionParameters;
    }

    public Object getDistributionParameter(String name) {
        return this.distributionParameters.get(name);
    }

    public void setDistributionParams(SortedMap<String, Object> distributionParameters) {
        distributionParameters.clear();
        this.addDistributionParams(distributionParameters);
    }

    public void addDistributionParams(SortedMap<String, Object> distributionParameters) {
        for (Map.Entry<String, Object> entry : distributionParameters.entrySet()) {
            this.addDistributionParam(entry.getKey(), entry.getValue());
        }
    }

    public void addDistributionParam(String name, Object value) {
        Distribution.DistributionParam[] defDistribParams;
        if (this.distribution == null) {
            throw new IllegalStateException("Distribution not set");
        }
        boolean found = false;
        for (Distribution.DistributionParam defDistribParam : defDistribParams = this.distribution.getDistibutionParams()) {
            if (!defDistribParam.getName().equals(name)) continue;
            found = true;
        }
        if (!found) {
            throw new IllegalArgumentException(String.format("Wrong parameter name, %s not supported by distribution", name));
        }
        this.distributionParameters.put(name, value);
    }

    @Override
    public Object getValueForIdentifier(Object identifier) {
        Object result;
        block7: {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(identifier);
            Class distClass = this.distribution.getDistClass();
            if (this.distribution == Distribution.QUNIFPC) {
                Object reference = this.distributionParameters.get(Distribution.QUNIFPC.getDistibutionParams()[0].getName());
                double coef = (Double)this.distributionParameters.get(Distribution.QUNIFPC.getDistibutionParams()[1].getName());
                double ref = (Double)reference;
                args.add(ref * (1.0 - coef));
                args.add(ref * (1.0 + coef));
            } else if (this.distribution == Distribution.QUNIFMM) {
                Object min = this.distributionParameters.get(Distribution.QUNIFMM.getDistibutionParams()[0].getName());
                args.add(min);
                Object max = this.distributionParameters.get(Distribution.QUNIFMM.getDistibutionParams()[1].getName());
                args.add(max);
            } else {
                for (Distribution.DistributionParam param : this.distribution.getDistibutionParams()) {
                    String name = param.getName();
                    Object value = this.distributionParameters.get(name);
                    args.add(value);
                }
            }
            args.add(true);
            args.add(false);
            result = null;
            try {
                result = MethodUtils.invokeStaticMethod((Class)distClass, (String)"quantile", (Object[])args.toArray());
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)("Can't invoke quantile method : args was " + args), (Throwable)ex);
            }
        }
        return result;
    }

    @Override
    public void accept(DomainVisitor visitor) {
        visitor.start(this);
        visitor.end(this);
    }

    @Override
    public ContinuousDomain clone() {
        ContinuousDomain cloned;
        try {
            cloned = (ContinuousDomain)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IsisFishRuntimeException("Can't clone domain", e);
        }
        return cloned;
    }
}

