/*
 * #%L
 * IsisFish
 * 
 * $Id: GenericComboModel.java 3969 2014-04-17 16:48:13Z echatellier $
 * $HeadURL: http://svn.codelutin.com/isis-fish/trunk/src/main/java/fr/ifremer/isisfish/ui/models/common/GenericComboModel.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.ui.models.common;

import java.util.List;

import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

/**
 * Model pour pour la representation d'une liste de type generic.
 * Utilisation dans les {@link JComboBox}.
 *
 * @param <E> generic type
 * @author chatellier
 * @version $Revision: 3969 $
 * 
 * Last update : $Date: 2014-04-17 18:48:13 +0200 (jeu., 17 avril 2014) $
 * By : $Author: echatellier $
 */
public class GenericComboModel<E> extends DefaultComboBoxModel<E> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -4070846632975105788L;

    /** E list. */
    protected List<E> genericList;

    /**
     * Empty constructor.
     */
    public GenericComboModel() {
        this(null);
    }

    /**
     * Constructor with export list.
     * 
     * @param genericList E list
     */
    public GenericComboModel(List<E> genericList) {
        setGenericList(genericList);
    }

    /**
     * Get E list.
     * 
     * @return E list
     */
    public List<E> getGenericList() {
        return genericList;
    }

    /**
     * Set E list.
     * 
     * @param genericList E list to set
     */
    public void setGenericList(List<E> genericList) {
        this.genericList = genericList;
        // reset selected
        setSelectedItem(null);
    }

    public void addElement(E elt) {
        genericList.add(elt);
        fireIntervalAdded(this, genericList.size() - 1, genericList.size());
    }

    public boolean containsElement(E elt) {
        return genericList.contains(elt);
    }

    /*
     * @see javax.swing.ListModel#getElementAt(int)
     */
    @Override
    public E getElementAt(int index) {
        return genericList.get(index);
    }

    /*
     * @see javax.swing.ListModel#getSize()
     */
    @Override
    public int getSize() {
        int size = 0;

        if (genericList != null) {
            size = genericList.size();
        }
        return size;
    }
}
