package fr.ifremer.coselmar.persistence.entity;

/*
 * #%L
 * Coselmar :: Persistence
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2014 Ifremer, Code Lutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import fr.ifremer.coselmar.persistence.DaoUtils;

public class DocumentTopiaDao extends AbstractDocumentTopiaDao<Document> {

    public List<Document> findAllContainingAllKeywords(List<String> keywords) {

        StringBuilder hqlBuilder = new StringBuilder("FROM " + Document.class.getName() + " D");
        Map<String, Object> args = new HashMap<>();

        if (keywords != null) {
            hqlBuilder.append(" WHERE ( 1 = 0 ");
            for (String keyword : keywords) {
                String nameClause = DaoUtils.orAttributeLike("D", Document.PROPERTY_NAME, args, keyword);
                String summaryClause = DaoUtils.orAttributeLike("D", Document.PROPERTY_SUMMARY, args, keyword);
                String authorsClause = DaoUtils.orAttributeLike("D", Document.PROPERTY_AUTHORS, args, keyword);
                String containsKeyword = DaoUtils.orAttributeContains("D", Document.PROPERTY_KEYWORDS, args, keyword);

                hqlBuilder.append(nameClause);
                hqlBuilder.append(summaryClause);
                hqlBuilder.append(authorsClause);
                hqlBuilder.append(containsKeyword);
            }
            hqlBuilder.append(" )");
        }

        List<Document> documents = forHql(hqlBuilder.toString(), args).findAll();
        return documents;
    }

    public List<Document> findAllFilterByUser(CoselmarUser currentUser, List<String> keywords) {

        StringBuilder hqlBuilder = new StringBuilder("SELECT DISTINCT(D) FROM " + Document.class.getName() + " D"
            + " LEFT OUTER JOIN D." + Document.PROPERTY_RESTRICTED_LIST + " CUG ");

        Map<String, Object> args = new HashMap<>();

        // can list all public document
        String privacyPublicCondition = DaoUtils.getQueryForAttributeEquals("D", Document.PROPERTY_PRIVACY, args, Privacy.PUBLIC, "");
        hqlBuilder.append(" WHERE ( " + privacyPublicCondition);

        // Can list his own document
        String ownerCondition = DaoUtils.orAttributeEquals("D", Document.PROPERTY_OWNER, args, currentUser);
        hqlBuilder.append(ownerCondition);

        // For limited access, check if user is in a restricted list
        String participantCondition = DaoUtils.orAttributeContains("CUG", CoselmarUserGroup.PROPERTY_MEMBERS, args, currentUser);
        hqlBuilder.append(participantCondition + ")");

        // Manage keywords search in : title, summary, authors and keywords

        if (keywords != null) {
            hqlBuilder.append(" AND ( 1 = 0 ");
            for (String keyword : keywords) {
                String nameClause = DaoUtils.orAttributeLike("D", Document.PROPERTY_NAME, args, keyword);
                String summaryClause = DaoUtils.orAttributeLike("D", Document.PROPERTY_SUMMARY, args, keyword);
                String authorsClause = DaoUtils.orAttributeLike("D", Document.PROPERTY_AUTHORS, args, keyword);
                String containsKeyword = DaoUtils.orAttributeContains("D", Document.PROPERTY_KEYWORDS, args, keyword);

                hqlBuilder.append(nameClause);
                hqlBuilder.append(summaryClause);
                hqlBuilder.append(authorsClause);
                hqlBuilder.append(containsKeyword);
            }
            hqlBuilder.append(" )");
        }


        List<Document> documents = forHql(hqlBuilder.toString(), args).findAll();

        return documents;
    }

    public List<String> findAllKeywords() {

        StringBuilder hqlBuilder =
            new StringBuilder("SELECT DISTINCT(keywords)"
                + " FROM " + Document.class.getName() + " D "
                + " INNER JOIN D." + Document.PROPERTY_KEYWORDS + " keywords ");

        List<String> values = findAll(hqlBuilder.toString());

        return values;
    }

    public List<String> findAllTypes() {

        StringBuilder hqlBuilder =
            new StringBuilder("SELECT DISTINCT(D. " + Document.PROPERTY_TYPE + ")"
                + " FROM " + Document.class.getName() + " D ");

        List<String> values = findAll(hqlBuilder.toString());

        return values;
    }

} //DocumentTopiaDao
