/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.widgets;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.widgets.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class MultipleSelectionPane<D, B extends BusinessEntity> extends javax.swing.JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN_TYPE = "beanType";
    public static final String PROPERTY_HANDLER = "handler";
    public static final String PROPERTY_LBL = "lbl";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADD_FILE_ENABLED = "addFile.enabled";
    public static final String BINDING_LIST_ENABLED = "list.enabled";
    public static final String BINDING_REMOVE_FILE_ENABLED = "removeFile.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JLABEL0_TEXT = "$JLabel0.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz08TQRSeFtrSAoIQEAPGX2j04NaDicYSRCEVSVFDORB7cboz0iGzu+PMLCwX45/gn6B3LybePBkPnj14Mf4Lxnjwanyz23a70EojPew2773ve+99M+/t2x8ooyQ6v4ODwJK+q5lDrbW7W1uP6jvU1itU2ZIJ7UkU/VJplK6hYdK2K40u1ioGXmzCi8ueIzyXuh3oUgUVlN7nVDUo1RqdSSJspYrVtrsUCF+2WNtFdWN9/etn+hV5+SaNUCCgulFo5dxRqLiTwQpKM6LRBGTaxUWO3W0oQzJ3G+odNbZljpV6iB36HL1AuQrKCiyBTKML/bcccoT4QGg05fhcM8FplXIQmHnuY+xSjW7anmPt+JIpB0u7QZW1KzFhls+sPUa2qVbWejekECF3VqM8Z0qve4RyjeZM8YGl9qAXa4U+wwCttNwxZNxAlinnG9QlVFIJh9kD2Rll0Pk2yQCvQ8Zxg7OMhFYkYZwl18Au4Yb89n80uRqBY7qhOsXu5r4A0cbipKHKHTnnN3Gd0+sazSTuQ9RX6Et2MTS/VsF1ygEx0SlBZDVBs52xRvrDsaE1GZvDhJQZh2InE6H3fK09NxlbkNTxdqkJN5bLSe/o/FrVlh7nJgukPpXgi13JvgbNEWt0MtkT2Iz/qoCBmU0IBKNoxaMYz0qqhjLSBzMoWjs8vRvgiuZ25sDcGsLQ+2d68uuH7+/LrWHNQ+6prqEduwaGSEhPwOVhJvVYNKm+Zry4jkWpBizhRQkX0VyXwqpNNxQH+UIZLAO3VrFqAEUm9+3jp+mnXwZQuowK3MOkjE38A5TXDQkqeJwE4s5SWNHI3hA8x01tGmU53vfgFNGJBYI1PldnLgF1FwMQYa6LCO1K6vnPvyer75ZaQqSgsNM9w2MxMk9QlrmcuTTcW82V1HVPDQtFfeLFq6fbMkqZd0E0h+ZG+LzVrdNBTYPwvpQC37wWwqLNv8WQ42w/HMyOrnsPjkt9cOSoawaXHIvGmO//g+FKXwyVYzFoNGIf2Kc9uK4du5qjGTTKOOa7cATJXwSPejQrCAAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.widgets.MultipleSelectionPane.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton addFile;
    protected java.lang.Class< B > beanType;
    protected com.jurismarches.vradi.ui.widgets.MultipleSelectionHandler< D, B, ? > handler;
    protected java.lang.String lbl;
    protected javax.swing.JList list;
    protected javax.swing.DefaultListCellRenderer listCellRenderer;
    protected javax.swing.DefaultListModel listModel;
    protected MultipleSelectionPane multipleSelectionPane = this;
    protected javax.swing.JButton removeFile;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.JPanel $JPanel0;
    private javax.swing.JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
        addPropertyChangeListener("handler", new PropertyChangeListener() {
    
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (getHandler() != null && getBean() != null) {
                    init();
                }
            }
        });
    
        list.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ListSelectionModel selectionModel = list.getSelectionModel();
                    int selectionIndex = selectionModel.getLeadSelectionIndex();
                    String selected = (String)listModel.get(selectionIndex);
    
                    getHandler().openSelected(selected);
                }
            }
        });
    }
    
    public void init() {
        if (handler != null) {
            handler.init();
        }
    }
    
    public B getBean() {
        return getContextValue(getBeanType());
    }
    
    public void setBean(B bean) {
        if (bean != null) {
            setContextValue(bean);
        }
    }
    
    public Collection<D> getAddedDatas() {
        return handler.getAddedDatas();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MultipleSelectionPane() {
        $initialize();
    }

    public MultipleSelectionPane(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addFile(java.awt.event.ActionEvent event) {
        handler.add();
    }

    public void doActionPerformed__on__removeFile(java.awt.event.ActionEvent event) {
        handler.remove();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public javax.swing.JButton getAddFile() {
        return addFile;
    }

    public java.lang.Class< B > getBeanType() {
        return beanType;
    }

    public com.jurismarches.vradi.ui.widgets.MultipleSelectionHandler< D, B, ? > getHandler() {
        return handler;
    }

    public java.lang.String getLbl() {
        return lbl;
    }

    public javax.swing.JList getList() {
        return list;
    }

    public javax.swing.DefaultListCellRenderer getListCellRenderer() {
        return listCellRenderer;
    }

    public javax.swing.DefaultListModel getListModel() {
        return listModel;
    }

    public javax.swing.JButton getRemoveFile() {
        return removeFile;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBeanType(java.lang.Class< B > newValue) {
        java.lang.Class< B > oldValue = this.beanType;
        this.beanType = newValue;
        firePropertyChange(PROPERTY_BEAN_TYPE, oldValue, newValue);
    }

    public void setHandler(com.jurismarches.vradi.ui.widgets.MultipleSelectionHandler< D, B, ? > newValue) {
        com.jurismarches.vradi.ui.widgets.MultipleSelectionHandler< D, B, ? > oldValue = this.handler;
        this.handler = newValue;
        firePropertyChange(PROPERTY_HANDLER, oldValue, newValue);
    }

    public void setLbl(java.lang.String newValue) {
        java.lang.String oldValue = this.lbl;
        this.lbl = newValue;
        firePropertyChange(PROPERTY_LBL, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected javax.swing.JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToMultipleSelectionPane() {
        if (!allComponentsCreated) {
            return;
        }
        add(listCellRenderer);
        add($Table0, BorderLayout.NORTH);
        add($JScrollPane0, BorderLayout.CENTER);
    }

    protected void createAddFile() {
        $objectMap.put("addFile", addFile = new javax.swing.JButton());
        
        addFile.setName("addFile");
        addFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addFile"));
    }

    protected void createBeanType() {
        $objectMap.put("beanType", beanType = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = null);
    }

    protected void createLbl() {
        $objectMap.put("lbl", lbl = StringUtils.EMPTY);
    }

    protected void createList() {
        $objectMap.put("list", list = new javax.swing.JList());
        
        list.setName("list");
    }

    protected void createListCellRenderer() {
        $objectMap.put("listCellRenderer", listCellRenderer = new javax.swing.DefaultListCellRenderer());
        
        listCellRenderer.setName("listCellRenderer");
    }

    protected void createListModel() {
        $objectMap.put("listModel", listModel = new javax.swing.DefaultListModel());
    }

    protected void createRemoveFile() {
        $objectMap.put("removeFile", removeFile = new javax.swing.JButton());
        
        removeFile.setName("removeFile");
        removeFile.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeFile"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToMultipleSelectionPane();
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel0, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(addFile, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(removeFile, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(list);
        
        // apply 4 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        addFile.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("add"));
        removeFile.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("remove"));
        list.setCellRenderer(listCellRenderer);
        list.setModel(listModel);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("multipleSelectionPane", this);
        createListModel();
        createListCellRenderer();
        createLbl();
        createHandler();
        createBeanType();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new javax.swing.JPanel());
        
        $JPanel0.setName("$JPanel0");
        createAddFile();
        createRemoveFile();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new javax.swing.JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createList();
        // inline creation of multipleSelectionPane
        setName("multipleSelectionPane");
        setLayout(new BorderLayout());
        
        // registers 4 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 4 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JLABEL0_TEXT, true ,"lbl") {
        
            @Override
            public void processDataBinding() {
                $JLabel0.setText(_(getLbl()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADD_FILE_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                addFile.setEnabled(isEnabled());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_REMOVE_FILE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("enabled", this);
                if (list != null) {
                    $bindingSources.put("list.getSelectionModel()", list.getSelectionModel());
                    list.getSelectionModel().addListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    list.addPropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(com.jurismarches.vradi.ui.widgets.MultipleSelectionPane.this, BINDING_REMOVE_FILE_ENABLED));
                }
            }
        
            @Override
            public void processDataBinding() {
                if (list != null) {
                    removeFile.setEnabled(isEnabled() && (list.getSelectedIndex() != -1));
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("enabled", this);
                if (list != null) {
                    javax.swing.ListSelectionModel $target = ((javax.swing.ListSelectionModel) $bindingSources.remove("list.getSelectionModel()"));
                    if ($target != null) {
                        $target.removeListSelectionListener( JAXXUtil.getEventListener(ListSelectionListener.class, this, "$pr$u0"));
                    }
                    list.removePropertyChangeListener("selectionModel", JAXXUtil.getDataBindingUpdateListener(com.jurismarches.vradi.ui.widgets.MultipleSelectionPane.this, BINDING_REMOVE_FILE_ENABLED));
                }
            }
        
            public void $pr$u0(javax.swing.event.ListSelectionEvent event) {
                propertyChange(null);
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LIST_ENABLED, true ,"enabled") {
        
            @Override
            public void processDataBinding() {
                list.setEnabled(isEnabled());
            }
        });
    }

}