/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.search.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.Item;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class CriteriaField extends jaxx.runtime.swing.Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACTIF = "actif";
    public static final String PROPERTY_DELETABLE = "deletable";
    public static final String PROPERTY_LABEL_NAME = "labelName";
    public static final String PROPERTY_ROOT_THESAURUS = "rootThesaurus";
    public static final String PROPERTY_THESAURUS = "thesaurus";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_COMBO_ENABLED = "combo.enabled";
    public static final String BINDING_LABEL_ENABLED = "label.enabled";
    public static final String BINDING_LABEL_TEXT = "label.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdO3GMEwIBKyGIgBJACCRYR7RGEGJkkciAFKeIcMP6bkk2Wt8uu3vJQYH4CfwE6GmQ6KgQBTUFDeIvIERBi5i9s302uXy4uPPNvnnzdubNu59QMBoWtmkUER0GlncYWb27sfGovc08e48ZT3NlpYbkl8tDvgUTfj9uLFxqNVx6pZteqcmOkgELBrKrDRg39rlgZosxa+H8cIZnTKXZP65GKtQ91r6oLNY3v3/lX/uv3uYBIoXqSniV+cOy0puMNiDPfQunsdIOrQgabKIMzYNN1DvpYjVBjXlIO+wZvIRiA8YU1Uhm4eLRrxxzxPmRwlo7mvq8prllmtM6ZwIFEE92yHaouelQ7W0xQ2IUCTkxzEXIUIJSMd+YhZKgbSacQAtTTjBxlyDJJQZgFjlpqEOc1rV9aqF4bjl+rvewaf6kltKupxw3DuNYG8QP6PCZYJa28QGnUrnLUgpGgxRXoJ7lT93HmTRYvtyMW7sSYA0q+AumFy1ciceNehQXTJOk+2QPcoA7bhkOwtWPiNnFTpHVhgs6RCkFImlbWpgeAtZccFlGXayGc0N+QyeT1Mmp1XItKOgQwxZmW3vNv4ZHie1n/7O9I4xP/86Uv3388aHe8/oI1p7OhA6sKnpQaamYdlOxcDIxemi5qDygqtrCjcGJeMkez2UIa3aPURzWS2bm0sl9araQolD8/unzzJOvI5Cvw7iQ1K9Th19xntPYBSn8SN1ZihUd3z2GzymnzUKRBc4I6P4Tt3xq6XybBz62+HaEXZjL6EJfSrv05U+5+X6p14kcKju7LzztRuExjPFA8IDFe99d6cw9n1CGhb5MVzdrmXPufUF1rXU1fl7PuuqoZZF1p5UodK/FWLT7d/OIHC5MDmBYQIZ/OrZLrssFAAA=";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.search.CriteriaField.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean actif;
    protected javax.swing.JComboBox combo;
    protected java.lang.Boolean deletable;
    protected javax.swing.JLabel label;
    protected java.lang.String labelName;
    protected com.jurismarches.vradi.entities.RootThesaurus rootThesaurus;
    protected com.jurismarches.vradi.entities.Thesaurus thesaurus;
    protected CriteriaField vradiCriteriaField = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected Item rootItem;
    
    
    protected SearchHandler getHandler() {
        return UIHelper.getHandler(this, SearchHandler.class);
    }
    
    protected VradiContext getVradiContext() {
        return VradiContext.get();
    }
    
    void $afterCompleteSetup() {
    }
    
    public void init(){
        if (isDeletable()){
            addMouseListener(new MouseAdapter() {
    
                @Override
                public void mouseClicked(final MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == MouseEvent.BUTTON3){
    
                        JPopupMenu popup = new JPopupMenu();
                        JMenuItem menuRemoveCriteria = new JMenuItem();
                        menuRemoveCriteria.setText(_("vradi.menu.removeCriteria"));
                        menuRemoveCriteria.addActionListener(new ActionListener() {
    
                            @Override
                            public void actionPerformed(ActionEvent actionEvent) {
                                removeCriteriaSelected();
                            }
                        });
                        popup.add(menuRemoveCriteria);
                        popup.show(vradiCriteriaField, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
    }
    
    protected void removeCriteriaSelected(){
        if (getThesaurus() != null) {
            getHandler().removeCriteriaAndPersist(this, getThesaurus());
        } else {
            getHandler().removeRootCriteriaAndPersist(this, getRootThesaurus());
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CriteriaField() {
        $initialize();
    }

    public CriteriaField(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getActif() {
        return actif;
    }

    public javax.swing.JComboBox getCombo() {
        return combo;
    }

    public java.lang.Boolean getDeletable() {
        return deletable;
    }

    public javax.swing.JLabel getLabel() {
        return label;
    }

    public java.lang.String getLabelName() {
        return labelName;
    }

    public com.jurismarches.vradi.entities.RootThesaurus getRootThesaurus() {
        return rootThesaurus;
    }

    public com.jurismarches.vradi.entities.Thesaurus getThesaurus() {
        return thesaurus;
    }

    public java.lang.Boolean isActif() {
        return actif !=null && actif;
    }

    public java.lang.Boolean isDeletable() {
        return deletable !=null && deletable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setActif(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.actif;
        this.actif = newValue;
        firePropertyChange(PROPERTY_ACTIF, oldValue, newValue);
    }

    public void setDeletable(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.deletable;
        this.deletable = newValue;
        firePropertyChange(PROPERTY_DELETABLE, oldValue, newValue);
    }

    public void setLabelName(java.lang.String newValue) {
        java.lang.String oldValue = this.labelName;
        this.labelName = newValue;
        firePropertyChange(PROPERTY_LABEL_NAME, oldValue, newValue);
    }

    public void setRootThesaurus(com.jurismarches.vradi.entities.RootThesaurus newValue) {
        com.jurismarches.vradi.entities.RootThesaurus oldValue = this.rootThesaurus;
        this.rootThesaurus = newValue;
        firePropertyChange(PROPERTY_ROOT_THESAURUS, oldValue, newValue);
    }

    public void setThesaurus(com.jurismarches.vradi.entities.Thesaurus newValue) {
        com.jurismarches.vradi.entities.Thesaurus oldValue = this.thesaurus;
        this.thesaurus = newValue;
        firePropertyChange(PROPERTY_THESAURUS, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToVradiCriteriaField() {
        if (!allComponentsCreated) {
            return;
        }
        add(label, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 2, 0, 0), 0, 0));
        add(combo, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createActif() {
        $objectMap.put("actif", actif = true);
    }

    protected void createCombo() {
        $objectMap.put("combo", combo = new javax.swing.JComboBox());
        
        combo.setName("combo");
    }

    protected void createDeletable() {
        $objectMap.put("deletable", deletable = false);
    }

    protected void createLabel() {
        $objectMap.put("label", label = new javax.swing.JLabel());
        
        label.setName("label");
    }

    protected void createLabelName() {
        $objectMap.put("labelName", labelName = "");
    }

    protected void createRootThesaurus() {
        $objectMap.put("rootThesaurus", rootThesaurus = null);
    }

    protected void createThesaurus() {
        $objectMap.put("thesaurus", thesaurus = null);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToVradiCriteriaField();
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("vradiCriteriaField", this);
        createLabelName();
        createThesaurus();
        createRootThesaurus();
        createDeletable();
        createActif();
        rootItem = null;
        createLabel();
        createCombo();
        // inline creation of vradiCriteriaField
        setName("vradiCriteriaField");
        
        // registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_ENABLED, true ,"actif") {
        
            @Override
            public void processDataBinding() {
                label.setEnabled(isActif());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT, true ,"labelName") {
        
            @Override
            public void processDataBinding() {
                label.setText(_(getLabelName()));
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_COMBO_ENABLED, true ,"actif") {
        
            @Override
            public void processDataBinding() {
                combo.setEnabled(isActif());
            }
        });
    }

}