/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: VradiI18nTableCellRenderer.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/renderers/VradiI18nTableCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.renderers;

import static org.nuiton.i18n.I18n._;

import java.awt.Component;

import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import jaxx.runtime.swing.renderer.I18nTableCellRenderer;

/**
 * @author letellier
 */
public class VradiI18nTableCellRenderer extends I18nTableCellRenderer {

    public VradiI18nTableCellRenderer(TableCellRenderer delegate, String... keysAndTips) {
        super(delegate, keysAndTips);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasfocus, int row, int column) {
        TableColumn col = table.getColumn(table.getColumnName(column));
        int index = col.getModelIndex();
        if (index < keys.length) {
            value = _(keys[index]);
            JComponent rendererComponent = (JComponent) delegate.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
            rendererComponent.setToolTipText(_(tips[index]));
            return rendererComponent;
        }
        return delegate.getTableCellRendererComponent(table, value, isSelected, hasfocus, row, column);
    }

}
