/*
 * #%L
 * Vradi :: Swing
 * *
 * $Id: RequestFieldMenu.java 1873 2010-12-30 12:56:40Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/models/RequestFieldMenu.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.models;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiExtensionsListener;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.Infogene;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.search.SearchUI;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.WikittyExtension;

import javax.swing.*;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import static org.nuiton.i18n.I18n._;

/**
 * @author letellier
 */
public class RequestFieldMenu extends JMenu implements VradiExtensionsListener {

    /**
     * Logger
     */
    private static final Log log = LogFactory.getLog(FormMenu.class);

    public static final String FIELD_NAME_SUFFIX = ":\"\"";

    protected SearchUI searchUI;
    protected Map<String, JMenu> formTypesMenu;
    protected Map<String, JMenuItem> formTypesFieldMenu;

    public RequestFieldMenu(SearchUI searchUI){
        super(_("vradi.request.keywords"));

        this.searchUI = searchUI;

        // Fill infogene fields
        fillInfogeneMenu();

        // Get all formsType
        List<WikittyExtension> formTypes = null;
        try {
            formTypes = VradiService.getVradiDataService().getAllFormTypes();
        } catch (VradiException eee) {
            log.error("cant get all forms type", eee);
            ErrorDialogUI.showError(eee);
        }

        // Sort
        Collections.sort(formTypes, VradiComparators.EXTENSION_COMPARATOR);

        formTypesMenu = new HashMap<String, JMenu>();
        formTypesFieldMenu = new HashMap<String, JMenuItem>();

        // Fill for all formTypes
        if (formTypes != null) {
            for (final WikittyExtension formType : formTypes){
                fillFormTypeMenu(formType);
            }
        }
        // register each tree on wikitty service
        VradiContext.get().getVradiNotifier().addVradiListener(this);
    }

    protected void fillInfogeneMenu() {
        JMenu infogeneMenu = new JMenu(_("vradi.request.infogene"));

        // Fill infogene menu
        for (String fieldName : getInfogeneFieldNames()) {
            infogeneMenu.add(new FieldMenuItem(fieldName));
        }

        // Fill form menu
        for (String fieldName : getFormFieldNames()) {
            infogeneMenu.add(new FieldMenuItem(fieldName));
        }

        // TODO sletellier 15/12/10 : [#2557] Requête sur tout ce qui caractérise un formulaire
//        // Fill formType menu
//        FormMenuItem formTypeMenu = new FormMenuItem("formType");
//        infogeneMenu.add(formTypeMenu);
//
//        // Get all formTypes
//        List<WikittyExtension> formTypes;
//        try {
//            formTypes = VradiService.getVradiDataService().getAllFormTypes();
//        } catch (VradiException eee) {
//            log.error("Failled to get all form types", eee);
//            ErrorDialogUI.showError(eee);
//            return;
//        }
//        for (WikittyExtension formType : formTypes) {
//            formTypeMenu.add(new JMenuItem(formType.getName()));
//        }
//
//        // Fill status menu
//        InfogeneMenuItem statusMenu = new InfogeneMenuItem(Infogene.FIELD_INFOGENE_STATUS);
//        infogeneMenu.add(statusMenu);
//
//        // Get all status
//        List<Status> statuses = VradiService.getVradiDataService().findAllStatus();
//        for (Status status : statuses) {
//            formTypeMenu.add(new JMenuItem(_(status.getName())));
//        }
//
//        // Fill xmlStream menu
//        FormMenuItem xmlStreamMenu = new FormMenuItem(Form.FIELD_FORM_XMLSTREAM);
//        infogeneMenu.add(xmlStreamMenu);
//
//        // Get all status
//        List<XmlStream> streams = VradiService.getVradiDataService().findAllXmlStreams();
//        for (XmlStream stream : streams) {
//            formTypeMenu.add(new JMenuItem(stream.getName()));
//        }

        add(infogeneMenu);
    }

    protected void fillFormTypeMenu(WikittyExtension formType) {
        String formTypeName = formType.getName();
        JMenu formTypeMenu = new JMenu(formTypeName);

        for (String fieldName : formType.getFieldNames()) {

            FieldMenuItem fieldMenu = new FieldMenuItem(formType, fieldName);
            formTypeMenu.add(fieldMenu);

            formTypesFieldMenu.put(fieldName, fieldMenu);
        }
        formTypesMenu.put(formTypeName, formTypeMenu);
        add(formTypeMenu);
    }

    protected List<String> getInfogeneFieldNames() {
        java.util.List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_ID);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_OBJET);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_DESCRIPTION);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_CREATIONDATE);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_ENTITY);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_SOURCETEXT);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_SOURCEURL);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_COUNTRY);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_DEPARTMENT);
        fieldNames.add(Infogene.FQ_FIELD_INFOGENE_STATUS);

        return fieldNames;
    }

    protected List<String> getFormFieldNames() {
        java.util.List<String> fieldNames = new ArrayList<String>();
        fieldNames.add(Form.FQ_FIELD_FORM_DATEPUB);
        fieldNames.add(Form.FQ_FIELD_FORM_DATEPEREMPTION);
        fieldNames.add(ModificationTag.FQ_FIELD_MODIFICATIONTAG_LASTMODIFIER);

        return fieldNames;
    }

    protected class FieldMenuItem extends JMenuItem implements ActionListener {

        protected String fieldName;
        protected FieldType fieldType;
        protected String description;
        protected String traduction;

        public FieldMenuItem(String fqFieldName) {
            this(null, fqFieldName);
        }

        public FieldMenuItem(WikittyExtension extension, String fqFieldName) {
            this.fieldName = fqFieldName;
            int i = fqFieldName.indexOf('.');
            if (i != -1) {
                this.fieldName = WikittyUtil.getFieldNameFromFQFieldName(fqFieldName);
            } else {
                this.fieldName = fqFieldName;
            }
            if (extension != null) {
                this.fieldType = extension.getFieldType(fqFieldName);
                this.description = VradiHelper.getFieldTypeDescription(fieldType);
            }
            this.traduction = VradiHelper.getTraduction(extension, fqFieldName);

            addActionListener(this);
        }

        @Override
        public String getText() {
            if (traduction != null && !traduction.equals(fieldName)) {
                return traduction + " (" + fieldName + ")";
            }
            return fieldName;
        }

        @Override
        public void actionPerformed(ActionEvent e) {

            JTextArea requestArea = searchUI.getRequestArea();

            int position = requestArea.getCaretPosition();
            requestArea.insert(fieldName + FIELD_NAME_SUFFIX, position);

            // Put carret under cotes
            requestArea.setCaretPosition(position + fieldName.length() + 2);

            searchUI.setRequest(requestArea.getText());
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            return getToolTipText();
        }

        @Override
        public String getToolTipText() {
            if (description != null) {
                return description;
            } else {
                return super.getToolTipText();
            }
        }
    }

    @Override
    public void extensionsAdded(Set<WikittyExtension> added) {
        for (WikittyExtension ext : added) {
            fillFormTypeMenu(ext);
        }
    }

    @Override
    public void extensionsRemoved(Set<String> removedNames) {
        for (String formTypeName : removedNames) {
            
            JMenu formTypeMenu = formTypesMenu.get(formTypeName);
            if (formTypeMenu != null) {
                formTypesMenu.remove(formTypeName);
                remove(formTypeMenu);
            }
        }
    }

}
