/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: EmailFormsListCellRenderer.java 1807 2010-11-24 15:11:33Z sletellier $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/email/renderers/EmailFormsListCellRenderer.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.email.renderers;

import com.jurismarches.vradi.beans.SendingHelper;
import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.entities.Group;
import com.jurismarches.vradi.entities.GroupForms;
import com.jurismarches.vradi.entities.Sending;
import com.jurismarches.vradi.entities.Session;
import com.jurismarches.vradi.entities.User;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.email.helpers.EmailDataHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.WikittyProxy;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EmailFormsListCellRenderer extends DefaultListCellRenderer {

    private static final Log log = LogFactory.getLog(EmailFormsListCellRenderer.class);

    protected Session sessionConcerned;
    protected String formConcerned;

    protected List<Object> cachedDeletion;
    protected Map<String, String> cachedRendered;
    protected Map<String, Boolean> cachedAdded;

    public EmailFormsListCellRenderer() {
        this.cachedDeletion = new ArrayList<Object>();
        this.cachedRendered = new HashMap<String, String>();
        this.cachedAdded = new HashMap<String, Boolean>();
    }

    public void updateDatas(Session sessionConcerned, String formConcerned) {
        this.sessionConcerned = sessionConcerned;
        this.formConcerned = formConcerned;
        clearCaches();
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {

        if (value == null) {
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }

        String wikittyId = ((BusinessEntity) value).getWikittyId();
        String renderedText = cachedRendered.get(wikittyId);
        if (renderedText != null) {
            Component rendered = super.getListCellRendererComponent(list, renderedText, index, isSelected, cellHasFocus);
            Boolean added = cachedAdded.get(wikittyId);
            if (added != null && added) {
                rendered.setForeground(Color.BLUE);
            }
            return rendered;
        }

        WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
        boolean isAdded = false;

        if (value instanceof User) {
            User user = (User)value;

            // Get user text
            String clientId = user.getClient();
            Client client = VradiService.getWikittyProxy().restore(
                    Client.class, clientId);
            String clientString = "";
            if (client != null) {
                clientString = client.getName() + " - ";
            }
            renderedText = clientString + user.getName();
            
            Sending sending = EmailDataHelper.getUserSending(sessionConcerned, user);
            if (sending != null) {
                Set<String> deletedForms = SendingHelper.extractForms(wikittyProxy, sending.getDeletedGroupForms());
                if (deletedForms != null && deletedForms.contains(formConcerned)) {
                    cachedDeletion.add(value);
                    renderedText = UIHelper.crossOf(renderedText);
                }
                Set<String> addedForms = SendingHelper.extractForms(wikittyProxy, sending.getAddedGroupForms());
                if (addedForms != null && addedForms.contains(formConcerned)) {
                    isAdded = true;
                }
            }
        } else if (value instanceof Group) {
            Group group = (Group)value;

            renderedText = group.getName();

            Set<String> userIds = group.getUser();
            if (userIds != null) {
                int deletedCount = 0;
                List<Sending> sendings = EmailDataHelper.getUsersSendings(sessionConcerned, userIds);
                for (Sending sending : sendings) {
                    if (sending != null) {
                        Set<String> groupFormsDeletedIds = sending.getDeletedGroupForms();
                        if (groupFormsDeletedIds != null) {
                            List<GroupForms> groupForms = wikittyProxy.restore(GroupForms.class, new ArrayList<String>(groupFormsDeletedIds));
                            for (GroupForms groupForm : groupForms) {
                                if (groupForm.getForm() != null && groupForm.getForm().contains(formConcerned)) {

                                    deletedCount++;
                                    break;
                                }
                            }
                        }
                        Set<String> groupFormsAddedIds = sending.getAddedGroupForms();
                        if (groupFormsAddedIds != null) {
                            List<GroupForms> groupForms = wikittyProxy.restore(GroupForms.class, new ArrayList<String>(groupFormsAddedIds));
                            for (GroupForms groupForm : groupForms) {
                                String groupId = groupForm.getGroup();
                                if (groupId != null && groupId.equals(group.getWikittyId()) &&
                                        groupForm.getForm() != null && groupForm.getForm().contains(formConcerned)) {

                                    isAdded = true;
                                    break;
                                }
                            }
                        }
                    }
                }

                // If all are deleted
                if (deletedCount == sendings.size()) {
                    cachedDeletion.add(value);

                    renderedText = UIHelper.crossOf(renderedText);
                }
            }
        }

        cachedRendered.put(wikittyId, renderedText);
        cachedAdded.put(wikittyId, isAdded);
        Component rendered = super.getListCellRendererComponent(list, renderedText, index, isSelected, cellHasFocus);
        if (isAdded) {
            rendered.setForeground(Color.BLUE);
        }
        return rendered;
    }

    public boolean isDeleted(Object o) {
        return cachedDeletion.contains(o);
    }

    public boolean areDeleted(Object[] o) {
        return cachedDeletion.containsAll(Arrays.asList(o));
    }

    public void clearCaches() {
        cachedDeletion.clear();
        cachedRendered.clear();
        cachedAdded.clear();
    }
}
