/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: FieldTypeModel.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/models/FieldTypeModel.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.models;

import javax.swing.AbstractListModel;
import javax.swing.MutableComboBoxModel;

import com.jurismarches.vradi.entities.FieldTypeEnum;

/**
 * @author letellier
 */
public class FieldTypeModel extends AbstractListModel implements MutableComboBoxModel {

    private static final long serialVersionUID = 1L;

    protected FieldTypeEnum selected = null;
    protected FieldTypeEnum[] values = FieldTypeEnum.values();

    @Override
    public int getSize() {
        return values.length;
    }

    @Override
    public Object getElementAt(int index) {
        return values[index];
    }

    @Override
    public void addElement(Object obj) {
    }

    @Override
    public void removeElement(Object obj) {
    }

    @Override
    public void insertElementAt(Object obj, int index) {
    }

    @Override
    public void removeElementAt(int index) {
    }

    @Override
    public void setSelectedItem(Object anItem) {
        selected = (FieldTypeEnum) anItem;
    }

    @Override
    public Object getSelectedItem() {
        return selected;
    }

}
