/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id: ClientsNodeLoadors.java 1715 2010-10-27 19:21:28Z tchemit $
 * $HeadURL: svn+ssh://sletellier@labs.libre-entreprise.org/svnroot/vradi/vradi/tags/vradi-0.5.2/vradi-swing/src/main/java/com/jurismarches/vradi/ui/admin/loadors/ClientsNodeLoadors.java $
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin.loadors;

import java.util.Collections;
import java.util.List;

import jaxx.runtime.swing.nav.NavDataProvider;

import com.jurismarches.vradi.entities.Client;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.ui.helpers.VradiComparators;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import com.jurismarches.vradi.ui.tree.loadors.AbstractVradiNodeLoadors;

/**
 * @author letellier
 */
public class ClientsNodeLoadors extends AbstractVradiNodeLoadors<Client> {

    /** serialVersionUID. */
    private static final long serialVersionUID = 6540304326033236054L;

    public ClientsNodeLoadors() {
        super(Client.class);
    }

    @Override
    public List<String> getData(Class<?> parentClass, String parentId, NavDataProvider dataProvider) throws Exception {

        // Return all clients
        // ne recupere pas seulement les id pour les mettre en cache
        VradiDataService dataService = getDataService(dataProvider);
        List<Client> clients = dataService.findAllClients();
        Collections.sort(clients, VradiComparators.CLIENT_COMPARATOR);
        return extractIds(clients);
    }

    @Override
    public VradiTreeNode createNode(String id, NavDataProvider dataProvider) {
        return createVradiNode(id);
    }
}

