/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2011 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.admin;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.ui.admin.*;
import com.jurismarches.vradi.ui.admin.content.*;
import com.jurismarches.vradi.ui.admin.helpers.ClientNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.helpers.FormTypeNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.helpers.GroupNavigationTreeHelper;
import com.jurismarches.vradi.ui.admin.helpers.XmlStreamNavigationTreeHelper;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.thesaurus.helpers.ThesaurusTreeTableHelper;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import javax.swing.tree.TreePath;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class AdminPopupUI extends javax.swing.JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ADMIN_TABS_MODEL = "adminTabs.model";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.admin.AdminPopupUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AdminPopupUI adminPopupUI = this;
    protected com.jurismarches.vradi.ui.admin.content.AdminStatusUI adminStatus;
    protected javax.swing.JTabbedPane adminTabs;
    protected com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI adminThesaurus;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI clientAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI formAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI groupAdminNavUI;
    protected com.jurismarches.vradi.ui.admin.AdminNavUI xmlStreamAdminNavUI;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private javax.swing.JButton $JButton0;
    private jaxx.runtime.swing.TabInfo $TabInfo0;
    private jaxx.runtime.swing.TabInfo $TabInfo1;
    private jaxx.runtime.swing.TabInfo $TabInfo2;
    private jaxx.runtime.swing.TabInfo $TabInfo3;
    private jaxx.runtime.swing.TabInfo $TabInfo4;
    private jaxx.runtime.swing.TabInfo $TabInfo5;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    private boolean contextInitialized;
    private SingleSelectionModel selectionModel;
    private VradiDataProvider dataProvider;
    
    
    public  AdminPopupUI(JAXXContext parentContext, Window parent) {
        super();$initialize();
    
        SwingUtil.initContext(this, parentContext);
        jaxx.runtime.JAXXUtil.assignment(selectionModel = new DefaultSingleSelectionModel() {
            private static final long serialVersionUID = 1L;
    
            @Override
            public void setSelectedIndex(int index) {
                int oldIndex = getSelectedIndex();
                if (oldIndex != -1) {
                    // on verifie que l'onglet en cours n'est pas modifie
                    AdminContentUI<?> content = getCurrentContent();
    
                    // null if is thesaurus selected
                    if (content != null){
                        boolean canContinue = getHandler().answerToSave(content);
                        if (!canContinue) {
                            // l'utilisateur ne veut pas partir au final
                            return;
                        }
                    }
                }
                super.setSelectedIndex(index);
            }
        }, "selectionModel", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
        jaxx.runtime.JAXXUtil.assignment(contextInitialized = true, "contextInitialized", com.jurismarches.vradi.ui.admin.AdminPopupUI.this);
        this.pack();
    $initialize();
    }
    
    protected AdminThesaurusHandler getThesaurusHandler() {
        return UIHelper.getHandler(this, AdminThesaurusHandler.class);
    }
    
    protected AdminHandler getHandler() {
        return getContextValue(AdminHandler.class);
    }
    
    public void close(){
        Component selected = adminTabs.getSelectedComponent();
        AdminHandler handler = getHandler();
    
        // Nothing for thesaurus
        if (selected instanceof AdminThesaurusUI) {
            handler.close(this);
        }
        AdminContentUI currentContent;
    
        // Status ui is not nav ui
        if (selected instanceof AdminStatusUI) {
            currentContent = (AdminStatusUI) selected;
        } else {
            currentContent = getCurrentContent();
    
            // if is thesaurus selected
            if (currentContent == null){
                handler.close(this);
                return;
            }
        }
        boolean canContinue = handler.answerToSave(currentContent);
        if (canContinue) {
            handler.close(this);
        }
    }
    
    public void showTab(int i){
        adminTabs.setSelectedIndex(i);
    }
    
    public AdminContentUI getCurrentContent() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminNavUI) {
            return ((AdminNavUI)selected).getCurrentContent();
        } else if (selected instanceof AdminStatusUI) {
            return (AdminContentUI) selected;
        }
        return null;
    }
    
    public AdminNavUI getCurrentTab() {
        Component selected = adminTabs.getSelectedComponent();
        if (selected instanceof AdminThesaurusUI ||
            selected instanceof AdminStatusUI) {
            return null;
        }
        return (AdminNavUI) selected;
    }
    
    public AdminStatusUI getStatusTab(){
        return (AdminStatusUI)adminTabs.getComponentAt(4);
    }
    
    public AdminThesaurusUI getTesaurusTab(){
        return (AdminThesaurusUI)adminTabs.getComponentAt(5);
    }
    
    void $afterCompleteSetup() {
        SwingUtil.center(getOwner(), this);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AdminPopupUI() {
        $initialize();
    }

    public AdminPopupUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        close();
    }

    public void doWindowClosing__on__adminPopupUI(java.awt.event.WindowEvent event) {
        close();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public com.jurismarches.vradi.ui.admin.content.AdminStatusUI getAdminStatus() {
        return adminStatus;
    }

    public javax.swing.JTabbedPane getAdminTabs() {
        return adminTabs;
    }

    public com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI getAdminThesaurus() {
        return adminThesaurus;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getClientAdminNavUI() {
        return clientAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getFormAdminNavUI() {
        return formAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getGroupAdminNavUI() {
        return groupAdminNavUI;
    }

    public com.jurismarches.vradi.ui.admin.AdminNavUI getXmlStreamAdminNavUI() {
        return xmlStreamAdminNavUI;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo0() {
        return $TabInfo0;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo1() {
        return $TabInfo1;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo2() {
        return $TabInfo2;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo3() {
        return $TabInfo3;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo4() {
        return $TabInfo4;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAdminPopupUI() {
        if (!allComponentsCreated) {
            return;
        }
        add(adminTabs, BorderLayout.CENTER);
        add($JButton0, BorderLayout.SOUTH);
    }

    protected void addChildrenToAdminTabs() {
        if (!allComponentsCreated) {
            return;
        }
        adminTabs.add(clientAdminNavUI);
        adminTabs.add(groupAdminNavUI);
        adminTabs.add(formAdminNavUI);
        adminTabs.add(xmlStreamAdminNavUI);
        adminTabs.add(adminStatus);
        adminTabs.add(adminThesaurus);
        $TabInfo0.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 0));
        adminTabs.setTitleAt(0, _("vradi.admin.client"));
        $TabInfo1.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 1));
        adminTabs.setTitleAt(1, _("vradi.admin.group"));
        $TabInfo2.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 2));
        adminTabs.setTitleAt(2, _("vradi.admin.form"));
        $TabInfo3.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 3));
        adminTabs.setTitleAt(3, _("vradi.admin.xmlStream"));
        $TabInfo4.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 4));
        adminTabs.setTitleAt(4, _("vradi.admin.status"));
        $TabInfo5.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(adminTabs, 5));
        adminTabs.setTitleAt(5, _("vradi.admin.thesaurus"));
    }

    protected void createAdminStatus() {
        $objectMap.put("adminStatus", adminStatus = new com.jurismarches.vradi.ui.admin.content.AdminStatusUI(this));
        
        adminStatus.setName("adminStatus");
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont((float) 20));
        }
        if (((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont() != null) {
            ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().deriveFont(((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).getFont().getStyle() | Font.BOLD));
        }
    }

    protected void createAdminTabs() {
        $objectMap.put("adminTabs", adminTabs = new javax.swing.JTabbedPane());
        
        adminTabs.setName("adminTabs");
    }

    protected void createAdminThesaurus() {
        $objectMap.put("adminThesaurus", adminThesaurus = new com.jurismarches.vradi.ui.admin.content.AdminThesaurusUI(this, new ThesaurusTreeTableHelper()));
        
        adminThesaurus.setName("adminThesaurus");
    }

    protected void createClientAdminNavUI() {
        $objectMap.put("clientAdminNavUI", clientAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new ClientNavigationTreeHelper(dataProvider)));
        
        clientAdminNavUI.setName("clientAdminNavUI");
        clientAdminNavUI.setShowImportExport(true);
    }

    protected void createFormAdminNavUI() {
        $objectMap.put("formAdminNavUI", formAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new FormTypeNavigationTreeHelper(dataProvider)));
        
        formAdminNavUI.setName("formAdminNavUI");
    }

    protected void createGroupAdminNavUI() {
        $objectMap.put("groupAdminNavUI", groupAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new GroupNavigationTreeHelper(dataProvider)));
        
        groupAdminNavUI.setName("groupAdminNavUI");
        groupAdminNavUI.setShowImportExport(true);
    }

    protected void createXmlStreamAdminNavUI() {
        $objectMap.put("xmlStreamAdminNavUI", xmlStreamAdminNavUI = new com.jurismarches.vradi.ui.admin.AdminNavUI(this, new XmlStreamNavigationTreeHelper(dataProvider)));
        
        xmlStreamAdminNavUI.setName("xmlStreamAdminNavUI");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        addChildrenToAdminPopupUI();
        addChildrenToAdminTabs();
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 5 property setters
        setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        $JButton0.setIcon(jaxx.runtime.SwingUtil.getUIManagerActionIcon("close"));
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        ((javax.swing.JLabel) adminStatus.getObjectById("$JLabel0")).setHorizontalTextPosition(JLabel.LEFT);
        // late initializer
        adminPopupUI.pack();
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("adminPopupUI", this);
        dataProvider = new VradiDataProvider();
        createAdminTabs();
        createClientAdminNavUI();
        createGroupAdminNavUI();
        createFormAdminNavUI();
        createXmlStreamAdminNavUI();
        createAdminStatus();
        createAdminThesaurus();
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("vradi.action.close"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        // inline creation of $TabInfo0
        $objectMap.put("$TabInfo0", $TabInfo0 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo0.setTitle(_("vradi.admin.client"));
        // inline creation of $TabInfo1
        $objectMap.put("$TabInfo1", $TabInfo1 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo1.setTitle(_("vradi.admin.group"));
        // inline creation of $TabInfo2
        $objectMap.put("$TabInfo2", $TabInfo2 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo2.setTitle(_("vradi.admin.form"));
        // inline creation of $TabInfo3
        $objectMap.put("$TabInfo3", $TabInfo3 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo3.setTitle(_("vradi.admin.xmlStream"));
        // inline creation of $TabInfo4
        $objectMap.put("$TabInfo4", $TabInfo4 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo4.setTitle(_("vradi.admin.status"));
        // inline creation of $TabInfo5
        $objectMap.put("$TabInfo5", $TabInfo5 = new jaxx.runtime.swing.TabInfo());
        
        $TabInfo5.setTitle(_("vradi.admin.thesaurus"));
        // inline creation of adminPopupUI
        setName("adminPopupUI");
        adminPopupUI.getContentPane().setLayout(new BorderLayout());
        setTitle(_("vradi.admin.title"));
        adminPopupUI.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__adminPopupUI"));
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ADMIN_TABS_MODEL, true ,"selectionModel") {
        
            @Override
            public void processDataBinding() {
                adminTabs.setModel(selectionModel);
            }
        });
    }

}