/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.addons.importexport;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.addons.importexport.ImportExportMethod;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.FacetTopic;
import org.nuiton.wikitty.search.PagedResult;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.search.operators.Element;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class ImportExportCSV
implements ImportExportMethod {
    private static Log log = LogFactory.getLog(ImportExportCSV.class);
    protected static final String FIELD_WIKITTY_ID = "Wikitty.Id";
    protected static final String FIELD_WIKITTY_EXT = "Wikitty.Ext";
    protected Pattern queryPattern = Pattern.compile("^((\\w+)\\.(\\w+))=(\"(.+)\"|([^\"]+))$");

    @Override
    public void importReader(String securityToken, Reader reader, WikittyService ws) throws Exception {
        String[] currentLine;
        int wikittyIdIndex = -1;
        int wikittyExtIndex = -1;
        CSVReader csvReader = new CSVReader(reader);
        String[] header = csvReader.readNext();
        String[] ext = new String[header.length];
        String[] fieldsName = new String[header.length];
        for (int i = 0; i < header.length; ++i) {
            if (FIELD_WIKITTY_ID.equalsIgnoreCase(header[i])) {
                wikittyIdIndex = i;
                continue;
            }
            if (FIELD_WIKITTY_EXT.equalsIgnoreCase(header[i])) {
                wikittyExtIndex = i;
                continue;
            }
            ext[i] = header[i].substring(0, header[i].indexOf("."));
            fieldsName[i] = header[i].substring(header[i].indexOf(".") + 1);
        }
        while ((currentLine = csvReader.readNext()) != null) {
            String extensionList;
            String wikittyId;
            if (currentLine.length == 1) continue;
            WikittyImpl currentWikitty = null;
            if (wikittyIdIndex != -1 && StringUtils.isNotBlank((String)(wikittyId = currentLine[wikittyIdIndex]))) {
                currentWikitty = new WikittyImpl(wikittyId);
            }
            if (currentWikitty == null) {
                currentWikitty = new WikittyImpl();
            }
            if (wikittyExtIndex != -1 && StringUtils.isNotBlank((String)(extensionList = currentLine[wikittyExtIndex]))) {
                String[] extensions;
                for (String extension : extensions = extensionList.split(",")) {
                    String extName = extension.trim();
                    this.addMissingExtension(securityToken, ws, currentWikitty, extName);
                }
            }
            for (int i = 0; i < header.length; ++i) {
                if (i == wikittyIdIndex || i == wikittyExtIndex) continue;
                String extName = ext[i];
                String fieldName = fieldsName[i];
                String value = currentLine[i];
                if (!StringUtils.isNotEmpty((String)value)) continue;
                this.addMissingExtension(securityToken, ws, currentWikitty, extName);
                value = this.convertLinkValues(securityToken, ws, value);
                FieldType fieldType = currentWikitty.getFieldType(extName + "." + fieldName);
                if (fieldType.isCollection()) {
                    String[] multiplesValues;
                    for (String multiplesValue : multiplesValues = StringUtil.split((String)value)) {
                        if (multiplesValue.startsWith("(") && multiplesValue.endsWith(")")) {
                            multiplesValue = multiplesValue.substring(1, multiplesValue.length() - 1);
                        }
                        if (fieldType.getType().equals((Object)FieldType.TYPE.WIKITTY)) {
                            List<Wikitty> wikitties = ws.restore(securityToken, Collections.singletonList(multiplesValue));
                            if (wikitties == null || wikitties.size() != 1 || wikitties.get(0) == null) continue;
                            currentWikitty.addToField(extName, fieldName, multiplesValue);
                            continue;
                        }
                        currentWikitty.addToField(extName, fieldName, multiplesValue);
                    }
                    continue;
                }
                if (fieldType.getType().equals((Object)FieldType.TYPE.WIKITTY)) {
                    List<Wikitty> wikitties = ws.restore(securityToken, Collections.singletonList(value));
                    if (wikitties == null || wikitties.size() != 1 || wikitties.get(0) == null) continue;
                    currentWikitty.setField(extName, fieldName, value);
                    continue;
                }
                currentWikitty.setField(extName, fieldName, value);
            }
            ws.store(securityToken, Collections.singleton(currentWikitty), true);
        }
    }

    protected void addMissingExtension(String securityToken, WikittyService ws, Wikitty currentWikitty, String extName) {
        if (!currentWikitty.hasExtension(extName)) {
            WikittyExtension extension = ws.restoreExtensionLastVersion(securityToken, extName);
            if (extension != null) {
                String requires = extension.getRequires();
                if (StringUtils.isNotEmpty((String)requires)) {
                    for (String require : requires.split(",")) {
                        String localRequire = require.trim();
                        this.addMissingExtension(securityToken, ws, currentWikitty, localRequire);
                    }
                }
                currentWikitty.addExtension(extension);
            } else {
                throw new WikittyException("Extension " + extName + " does not exist");
            }
        }
    }

    protected String convertLinkValues(String securityToken, WikittyService ws, String value) {
        boolean correctQueries;
        String resultValue;
        String originalValue;
        block7: {
            originalValue = value;
            resultValue = "";
            String separator = "";
            correctQueries = true;
            try {
                String[] queries;
                for (String query : queries = StringUtil.split((String)value, (String)",")) {
                    Matcher m = this.queryPattern.matcher(query.trim());
                    if (m.find()) {
                        Criteria criteria;
                        String id;
                        Wikitty wikitty;
                        String fqField = m.group(1);
                        String fValue = m.group(5);
                        if (fValue == null) {
                            fValue = m.group(6);
                        }
                        if ((wikitty = WikittyServiceEnhanced.restore(ws, securityToken, id = ws.findByCriteria(securityToken, criteria = Search.query().eq(fqField, fValue).criteria()))) == null) {
                            correctQueries = false;
                            continue;
                        }
                        resultValue = resultValue + separator + wikitty.getId();
                        separator = ",";
                        continue;
                    }
                    correctQueries = false;
                }
            }
            catch (StringIndexOutOfBoundsException eee) {
                if (!log.isTraceEnabled()) break block7;
                log.trace((Object)"Can't split field on , skipping");
            }
        }
        if (!correctQueries || StringUtils.isEmpty((String)resultValue)) {
            resultValue = originalValue;
        }
        return resultValue;
    }

    @Override
    public void exportWriter(String securityToken, Writer writer, WikittyService ws, PagedResult<Wikitty> pagedResult) throws Exception {
        CSVWriter csvWriter = new CSVWriter(writer);
        LinkedList<String> extensionHeader = new LinkedList<String>();
        extensionHeader.add(FIELD_WIKITTY_ID);
        extensionHeader.add(FIELD_WIKITTY_EXT);
        for (FacetTopic topic : pagedResult.getTopic(Element.ELT_EXTENSION)) {
            String extName = topic.getTopicName();
            WikittyExtension extension = ws.restoreExtensionLastVersion(securityToken, extName);
            String ext = WikittyExtension.computeName(extName);
            for (String fieldName : extension.getFieldNames()) {
                extensionHeader.add(ext + "." + fieldName);
            }
        }
        csvWriter.writeNext(extensionHeader.toArray(new String[extensionHeader.size()]));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exporting wikitty : " + pagedResult.getAll().size() + " results"));
        }
        List<Wikitty> wikitties = pagedResult.getAll();
        for (Wikitty w : wikitties) {
            String extNames;
            String[] wikittyField = new String[extensionHeader.size()];
            wikittyField[extensionHeader.indexOf((Object)FIELD_WIKITTY_ID)] = w.getId();
            Collection<String> extNamesCollection = w.getExtensionNames();
            wikittyField[extensionHeader.indexOf((Object)FIELD_WIKITTY_EXT)] = extNames = StringUtils.join(extNamesCollection, (char)',');
            for (String fieldName : w.fieldNames()) {
                String currentField = "";
                FieldType type = w.getFieldType(fieldName);
                if (type.isCollection()) {
                    Object fqField = w.getFqField(fieldName);
                    if (fqField != null) {
                        String separator = "";
                        for (Object o : (Collection)fqField) {
                            String fqFieldValue = WikittyUtil.toStringForExport(type, o);
                            currentField = currentField + separator + "(" + fqFieldValue + ")";
                            separator = ",";
                        }
                    }
                } else {
                    String fqFieldValue;
                    currentField = fqFieldValue = WikittyUtil.toStringForExport(type, w.getFqField(fieldName));
                }
                wikittyField[extensionHeader.indexOf((Object)fieldName)] = currentField;
            }
            csvWriter.writeNext(wikittyField);
        }
        csvWriter.close();
    }
}

