/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.modes;

import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMap;

public class JavaScriptTokenMaker
extends AbstractTokenMaker {
    protected final String operators = "+-*/%!=<>^&|?:";
    protected final String separators = "()[]{}";
    protected final String separators2 = ".,;";
    protected final String hexCharacters = "0123456789ABCDEFabcdef";
    protected final String numberEndChars = "FfLl";
    private int currentTokenStart;
    private int currentTokenType;

    public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
        switch (tokenType) {
            case 15: {
                int value = this.wordsToHighlight.get(segment, start, end);
                if (value == -1) break;
                tokenType = value;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            default: {
                new Exception("Unknown tokenType: '" + tokenType + "'").printStackTrace();
                tokenType = 15;
            }
        }
        super.addToken(segment, start, end, tokenType, startOffset);
    }

    public String[] getLineCommentStartAndEnd() {
        return new String[]{"//", null};
    }

    public TokenMap getWordsToHighlight() {
        TokenMap tokenMap = new TokenMap(52);
        int reservedWord = 4;
        tokenMap.put("abstract", reservedWord);
        tokenMap.put("as", reservedWord);
        tokenMap.put("break", reservedWord);
        tokenMap.put("case", reservedWord);
        tokenMap.put("catch", reservedWord);
        tokenMap.put("class", reservedWord);
        tokenMap.put("const", reservedWord);
        tokenMap.put("continue", reservedWord);
        tokenMap.put("debugger", reservedWord);
        tokenMap.put("default", reservedWord);
        tokenMap.put("delete", reservedWord);
        tokenMap.put("do", reservedWord);
        tokenMap.put("else", reservedWord);
        tokenMap.put("enum", reservedWord);
        tokenMap.put("export", reservedWord);
        tokenMap.put("extends", reservedWord);
        tokenMap.put("final", reservedWord);
        tokenMap.put("finally", reservedWord);
        tokenMap.put("for", reservedWord);
        tokenMap.put("function", reservedWord);
        tokenMap.put("goto", reservedWord);
        tokenMap.put("if", reservedWord);
        tokenMap.put("implements", reservedWord);
        tokenMap.put("import", reservedWord);
        tokenMap.put("in", reservedWord);
        tokenMap.put("instanceof", reservedWord);
        tokenMap.put("interface", reservedWord);
        tokenMap.put("item", reservedWord);
        tokenMap.put("namespace", reservedWord);
        tokenMap.put("native", reservedWord);
        tokenMap.put("new", reservedWord);
        tokenMap.put("null", reservedWord);
        tokenMap.put("package", reservedWord);
        tokenMap.put("private", reservedWord);
        tokenMap.put("protected", reservedWord);
        tokenMap.put("public", reservedWord);
        tokenMap.put("return", reservedWord);
        tokenMap.put("static", reservedWord);
        tokenMap.put("super", reservedWord);
        tokenMap.put("switch", reservedWord);
        tokenMap.put("synchronized", reservedWord);
        tokenMap.put("this", reservedWord);
        tokenMap.put("throw", reservedWord);
        tokenMap.put("throws", reservedWord);
        tokenMap.put("transient", reservedWord);
        tokenMap.put("try", reservedWord);
        tokenMap.put("typeof", reservedWord);
        tokenMap.put("var", reservedWord);
        tokenMap.put("void", reservedWord);
        tokenMap.put("while", reservedWord);
        tokenMap.put("with", reservedWord);
        int literalBoolean = 6;
        tokenMap.put("false", literalBoolean);
        tokenMap.put("true", literalBoolean);
        int dataType = 13;
        tokenMap.put("boolean", dataType);
        tokenMap.put("byte", dataType);
        tokenMap.put("char", dataType);
        tokenMap.put("double", dataType);
        tokenMap.put("float", dataType);
        tokenMap.put("int", dataType);
        tokenMap.put("long", dataType);
        tokenMap.put("short", dataType);
        return tokenMap;
    }

    public boolean getCurlyBracesDenoteCodeBlocks() {
        return true;
    }

    public boolean getShouldIndentNextLineAfter(Token t) {
        if (t != null && t.textCount == 1) {
            char ch = t.text[t.textOffset];
            return ch == '{' || ch == '(';
        }
        return false;
    }

    public Token getTokenList(Segment text, int initialTokenType, int startOffset) {
        this.resetTokenList();
        char[] array = text.array;
        int offset = text.offset;
        int count = text.count;
        int end = offset + count;
        int newStartOffset = startOffset - offset;
        this.currentTokenStart = offset;
        this.currentTokenType = initialTokenType;
        boolean backslash = false;
        boolean numContainsExponent = false;
        boolean numContainsEndCharacter = false;
        block64: for (int i = offset; i < end; ++i) {
            char c = array[i];
            switch (this.currentTokenType) {
                case 0: {
                    this.currentTokenStart = i;
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.currentTokenType = 16;
                            continue block64;
                        }
                        case '\"': {
                            if (backslash) {
                                this.addToken(text, this.currentTokenStart, i, 15, newStartOffset + this.currentTokenStart);
                                backslash = false;
                                continue block64;
                            }
                            this.currentTokenType = 25;
                            continue block64;
                        }
                        case '\'': {
                            if (backslash) {
                                this.addToken(text, this.currentTokenStart, i, 15, newStartOffset + this.currentTokenStart);
                                backslash = false;
                                continue block64;
                            }
                            this.currentTokenType = 26;
                            continue block64;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i, 15, newStartOffset + this.currentTokenStart);
                            this.currentTokenType = 0;
                            backslash = !backslash;
                            continue block64;
                        }
                    }
                    if (RSyntaxUtilities.isDigit(c)) {
                        this.currentTokenType = 7;
                        continue block64;
                    }
                    if (RSyntaxUtilities.isLetter(c) || c == '_') {
                        this.currentTokenType = 15;
                        continue block64;
                    }
                    int indexOf = "+-*/%!=<>^&|?:".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        continue block64;
                    }
                    indexOf = "()[]{}".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i, 17, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    indexOf = ".,;".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i, 15, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    this.currentTokenType = 23;
                    continue block64;
                }
                case 16: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            continue block64;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 16, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            continue block64;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 16, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            continue block64;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 16, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            continue block64;
                        }
                    }
                    this.addToken(text, this.currentTokenStart, i - 1, 16, newStartOffset + this.currentTokenStart);
                    this.currentTokenStart = i;
                    if (RSyntaxUtilities.isDigit(c)) {
                        this.currentTokenType = 7;
                        continue block64;
                    }
                    if (RSyntaxUtilities.isLetter(c) || c == '_') {
                        this.currentTokenType = 15;
                        continue block64;
                    }
                    int indexOf = "+-*/%!=<>^&|?:".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        continue block64;
                    }
                    indexOf = "()[]{}".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    indexOf = ".,;".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    this.currentTokenType = 23;
                    continue block64;
                }
                default: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            continue block64;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            continue block64;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            continue block64;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            continue block64;
                        }
                    }
                    if (RSyntaxUtilities.isLetterOrDigit(c) || c == '_') continue block64;
                    int indexOf = "+-*/%!=<>^&|?:".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        continue block64;
                    }
                    indexOf = "()[]{}".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    indexOf = ".,;".indexOf(c, 0);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 15, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    this.currentTokenType = 23;
                    continue block64;
                }
                case 7: {
                    if (this.currentTokenStart == i - 1) {
                        numContainsExponent = false;
                        numContainsEndCharacter = false;
                    }
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            continue block64;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            continue block64;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            continue block64;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            continue block64;
                        }
                    }
                    if (RSyntaxUtilities.isDigit(c)) continue block64;
                    if (c == 'e') {
                        if (!numContainsExponent) {
                            numContainsExponent = true;
                            continue block64;
                        }
                        this.currentTokenType = 24;
                        continue block64;
                    }
                    if (c == '.') {
                        if (numContainsExponent) {
                            this.currentTokenType = 24;
                            continue block64;
                        }
                        this.currentTokenType = 8;
                        continue block64;
                    }
                    int indexOf = "FfLl".indexOf(c);
                    if (indexOf > -1) {
                        if (numContainsEndCharacter) {
                            this.currentTokenType = 24;
                            continue block64;
                        }
                        numContainsEndCharacter = true;
                        continue block64;
                    }
                    indexOf = "+-*/%!=<>^&|?:".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        continue block64;
                    }
                    indexOf = "()[]{}".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    indexOf = ".,;".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 7, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    this.currentTokenType = 24;
                    continue block64;
                }
                case 8: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            continue block64;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            continue block64;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            continue block64;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            continue block64;
                        }
                    }
                    if (RSyntaxUtilities.isDigit(c)) continue block64;
                    if (c == 'e') {
                        if (!numContainsExponent) {
                            numContainsExponent = true;
                            continue block64;
                        }
                        this.currentTokenType = 24;
                        continue block64;
                    }
                    if (c == '.') {
                        this.currentTokenType = 24;
                        continue block64;
                    }
                    int indexOf = "FfLl".indexOf(c);
                    if (indexOf > -1) {
                        if (numContainsEndCharacter) {
                            this.currentTokenType = 24;
                            continue block64;
                        }
                        numContainsEndCharacter = true;
                        continue block64;
                    }
                    indexOf = "+-*/%!=<>^&|?:".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        continue block64;
                    }
                    indexOf = "()[]{}".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    indexOf = ".,;".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 8, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    this.currentTokenType = 24;
                    continue block64;
                }
                case 9: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            continue block64;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            continue block64;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            continue block64;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            continue block64;
                        }
                    }
                    if (c == 'e') {
                        if (!numContainsExponent) {
                            numContainsExponent = true;
                            continue block64;
                        }
                        this.currentTokenType = 24;
                        continue block64;
                    }
                    int indexOf = "0123456789ABCDEFabcdef".indexOf(c);
                    if (indexOf > -1) continue block64;
                    indexOf = "FfLl".indexOf(c);
                    if (indexOf > -1) {
                        if (numContainsEndCharacter) {
                            this.currentTokenType = 24;
                            continue block64;
                        }
                        numContainsEndCharacter = true;
                        continue block64;
                    }
                    indexOf = "+-*/%!=<>^&|?:".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                        continue block64;
                    }
                    indexOf = "()[]{}".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    indexOf = ".,;".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 9, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 15, newStartOffset + i);
                        this.currentTokenType = 0;
                        continue block64;
                    }
                    this.currentTokenType = 24;
                    continue block64;
                }
                case 2: {
                    while (i < end - 1) {
                        if (array[i] == '*' && array[i + 1] == '/') {
                            this.addToken(text, this.currentTokenStart, i + 1, 2, newStartOffset + this.currentTokenStart);
                            ++i;
                            this.currentTokenType = 0;
                            backslash = false;
                            continue block64;
                        }
                        ++i;
                    }
                    continue block64;
                }
                case 1: {
                    i = end - 1;
                    this.addToken(text, this.currentTokenStart, i, 1, newStartOffset + this.currentTokenStart);
                    this.currentTokenType = 0;
                    continue block64;
                }
                case 18: {
                    if (array[i - 1] == '/') {
                        if (c == '*') {
                            this.currentTokenType = 2;
                            continue block64;
                        }
                        if (c == '/') {
                            this.currentTokenType = 1;
                            i = end - 1;
                            continue block64;
                        }
                        this.addToken(text, this.currentTokenStart, i - 1, 18, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                        --i;
                        continue block64;
                    }
                    this.addToken(text, this.currentTokenStart, i - 1, 18, newStartOffset + this.currentTokenStart);
                    --i;
                    this.currentTokenType = 0;
                    continue block64;
                }
                case 23: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            continue block64;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            continue block64;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            continue block64;
                        }
                        case ';': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            continue block64;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            continue block64;
                        }
                    }
                    int indexOf = "+-*/%!=<>^&|?:".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                    }
                    if ((indexOf = "()[]{}".indexOf(c)) > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                    }
                    if ((indexOf = ".,;".indexOf(c)) <= -1) continue block64;
                    this.addToken(text, this.currentTokenStart, i - 1, 23, newStartOffset + this.currentTokenStart);
                    this.addToken(text, i, i, 15, newStartOffset + i);
                    this.currentTokenType = 0;
                    continue block64;
                }
                case 24: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 16;
                            continue block64;
                        }
                        case '\"': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 25;
                            backslash = false;
                            continue block64;
                        }
                        case '\'': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.currentTokenStart = i;
                            this.currentTokenType = 26;
                            backslash = false;
                            continue block64;
                        }
                        case ';': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            continue block64;
                        }
                        case '\\': {
                            this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                            this.addToken(text, i, i, 15, newStartOffset + i);
                            this.currentTokenType = 0;
                            backslash = true;
                            continue block64;
                        }
                    }
                    int indexOf = "0123456789ABCDEFabcdef".indexOf(c);
                    if (indexOf > -1 && i - this.currentTokenStart == 2 && array[i - 1] == 'x' && array[i - 2] == '0') {
                        this.currentTokenType = 9;
                        continue block64;
                    }
                    indexOf = "+-*/%!=<>^&|?:".indexOf(c);
                    if (indexOf > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                        this.currentTokenStart = i;
                        this.currentTokenType = 18;
                    }
                    if ((indexOf = "()[]{}".indexOf(c)) > -1) {
                        this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                        this.addToken(text, i, i, 17, newStartOffset + i);
                        this.currentTokenType = 0;
                    }
                    if ((indexOf = ".,;".indexOf(c)) <= -1) continue block64;
                    this.addToken(text, this.currentTokenStart, i - 1, 24, newStartOffset + this.currentTokenStart);
                    this.addToken(text, i, i, 15, newStartOffset + i);
                    this.currentTokenType = 0;
                    continue block64;
                }
                case 26: {
                    if (c == '\\') {
                        backslash = !backslash;
                        continue block64;
                    }
                    if (c == '\'' && !backslash) {
                        this.addToken(text, this.currentTokenStart, i, 11, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                    }
                    backslash = false;
                    continue block64;
                }
                case 25: {
                    if (c == '\\') {
                        backslash = !backslash;
                        continue block64;
                    }
                    if (c == '\"' && !backslash) {
                        this.addToken(text, this.currentTokenStart, i, 10, newStartOffset + this.currentTokenStart);
                        this.currentTokenType = 0;
                    }
                    backslash = false;
                }
            }
        }
        if (this.currentTokenType != 0) {
            this.addToken(text, this.currentTokenStart, end - 1, this.currentTokenType, newStartOffset + this.currentTokenStart);
        }
        if (this.currentTokenType != 2) {
            this.addNullToken();
        }
        return this.firstToken;
    }
}

