/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.basic.BasicTextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.ChangeableColorHighlightPainter;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rsyntaxtextarea.MarkOccurrencesHighlightPainter;
import org.fife.ui.rsyntaxtextarea.parser.ParserNotice;
import org.fife.ui.rtextarea.RTextArea;

public class RSyntaxTextAreaHighlighter
extends BasicTextUI.BasicHighlighter {
    private RTextArea textArea;
    private List markedOccurrences = new ArrayList();
    private List parserHighlights = new ArrayList(0);
    private static final Color DEFAULT_PARSER_NOTICE_COLOR = Color.RED;

    Object addMarkedOccurrenceHighlight(int start, int end, MarkOccurrencesHighlightPainter p) throws BadLocationException {
        Document doc = this.textArea.getDocument();
        TextUI mapper = this.textArea.getUI();
        LayeredHighlightInfo i = new LayeredHighlightInfo();
        i.painter = p;
        ((HighlightInfo)i).p0 = doc.createPosition(start);
        ((HighlightInfo)i).p1 = doc.createPosition(end - 1);
        this.markedOccurrences.add(i);
        mapper.damageRange(this.textArea, start, end);
        return i;
    }

    Object addParserHighlight(ParserNotice notice, Highlighter.HighlightPainter p) throws BadLocationException {
        Document doc = this.textArea.getDocument();
        TextUI mapper = this.textArea.getUI();
        int start = notice.getOffset();
        int end = start + notice.getLength();
        LayeredHighlightInfo i = new LayeredHighlightInfo();
        i.painter = p;
        ((HighlightInfo)i).p0 = doc.createPosition(start);
        ((HighlightInfo)i).p1 = doc.createPosition(end);
        ((HighlightInfo)i).notice = notice;
        this.parserHighlights.add(i);
        mapper.damageRange(this.textArea, start, end);
        return i;
    }

    void clearParserHighlights() {
        for (int i = 0; i < this.parserHighlights.size(); ++i) {
            Object tag = this.parserHighlights.get(i);
            if (tag instanceof LayeredHighlightInfo) {
                LayeredHighlightInfo lhi = (LayeredHighlightInfo)tag;
                if (lhi.width <= 0 || lhi.height <= 0) continue;
                this.textArea.repaint(lhi.x, lhi.y, lhi.width, lhi.height);
                continue;
            }
            HighlightInfo info = (HighlightInfo)tag;
            TextUI ui = this.textArea.getUI();
            ui.damageRange(this.textArea, info.getStartOffset(), info.getEndOffset());
        }
        this.parserHighlights.clear();
    }

    public void deinstall(JTextComponent c) {
        this.textArea = null;
        this.markedOccurrences.clear();
        this.parserHighlights.clear();
    }

    public List getMarkedOccurrences() {
        ArrayList<DocumentRangeImpl> list = new ArrayList<DocumentRangeImpl>(this.markedOccurrences.size());
        Iterator i = this.markedOccurrences.iterator();
        while (i.hasNext()) {
            HighlightInfo info = (HighlightInfo)i.next();
            int start = info.getStartOffset();
            int end = info.getEndOffset() + 1;
            DocumentRangeImpl range = new DocumentRangeImpl(start, end);
            list.add(range);
        }
        return list;
    }

    public void install(JTextComponent c) {
        super.install(c);
        this.textArea = (RTextArea)c;
    }

    public void paint(Graphics g) {
        this.paintList(g, this.markedOccurrences);
        super.paint(g);
        this.paintList(g, this.parserHighlights);
    }

    private void paintList(Graphics g, List highlights) {
        int len = highlights.size();
        for (int i = 0; i < len; ++i) {
            HighlightInfo info = (HighlightInfo)highlights.get(i);
            if (info instanceof LayeredHighlightInfo) continue;
            Rectangle a = this.textArea.getBounds();
            Insets insets = this.textArea.getInsets();
            a.x = insets.left;
            a.y = insets.top;
            a.width -= insets.left + insets.right;
            a.height -= insets.top + insets.bottom;
            while (i < len) {
                info = (HighlightInfo)this.markedOccurrences.get(i);
                if (!(info instanceof LayeredHighlightInfo)) {
                    Color c = info.getColor();
                    Highlighter.HighlightPainter p = info.getPainter();
                    if (c != null && p instanceof ChangeableColorHighlightPainter) {
                        ((ChangeableColorHighlightPainter)p).setColor(c);
                    }
                    p.paint(g, info.getStartOffset(), info.getEndOffset(), a, this.textArea);
                }
                ++i;
            }
        }
    }

    public void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
        this.paintListLayered(g, p0, p1, viewBounds, editor, view, this.markedOccurrences);
        super.paintLayeredHighlights(g, p0, p1, viewBounds, editor, view);
        this.paintListLayered(g, p0, p1, viewBounds, editor, view, this.parserHighlights);
    }

    private void paintListLayered(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view, List highlights) {
        for (int i = highlights.size() - 1; i >= 0; --i) {
            Object tag = highlights.get(i);
            if (!(tag instanceof LayeredHighlightInfo)) continue;
            LayeredHighlightInfo lhi = (LayeredHighlightInfo)tag;
            int start = lhi.getStartOffset();
            int end = lhi.getEndOffset();
            if ((p0 >= start || p1 <= start) && (p0 < start || p0 >= end)) continue;
            lhi.paintLayeredHighlights(g, p0, p1, viewBounds, editor, view);
        }
    }

    private void removeListHighlight(List list, Object tag) {
        if (tag instanceof LayeredHighlightInfo) {
            LayeredHighlightInfo lhi = (LayeredHighlightInfo)tag;
            if (lhi.width > 0 && lhi.height > 0) {
                this.textArea.repaint(lhi.x, lhi.y, lhi.width, lhi.height);
            }
        } else {
            HighlightInfo info = (HighlightInfo)tag;
            TextUI ui = this.textArea.getUI();
            ui.damageRange(this.textArea, info.getStartOffset(), info.getEndOffset());
        }
        list.remove(tag);
    }

    void removeMarkOccurrencesHighlight(Object tag) {
        this.removeListHighlight(this.markedOccurrences, tag);
    }

    void removeParserHighlight(Object tag) {
        this.removeListHighlight(this.parserHighlights, tag);
    }

    private static class LayeredHighlightInfo
    extends HighlightInfo {
        private int x;
        private int y;
        private int width;
        private int height;

        private LayeredHighlightInfo() {
        }

        void union(Shape bounds) {
            Rectangle alloc;
            if (bounds == null) {
                return;
            }
            Rectangle rectangle = alloc = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            if (this.width == 0 || this.height == 0) {
                this.x = alloc.x;
                this.y = alloc.y;
                this.width = alloc.width;
                this.height = alloc.height;
            } else {
                this.width = Math.max(this.x + this.width, alloc.x + alloc.width);
                this.height = Math.max(this.y + this.height, alloc.y + alloc.height);
                this.x = Math.min(this.x, alloc.x);
                this.width -= this.x;
                this.y = Math.min(this.y, alloc.y);
                this.height -= this.y;
            }
        }

        void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            p0 = Math.max(start, p0);
            p1 = Math.min(end, p1);
            if (this.getColor() != null && this.painter instanceof ChangeableColorHighlightPainter) {
                ((ChangeableColorHighlightPainter)this.painter).setColor(this.getColor());
            }
            this.union(((LayeredHighlighter.LayerPainter)this.painter).paintLayer(g, p0, p1, viewBounds, editor, view));
        }
    }

    private static class HighlightInfo
    implements Highlighter.Highlight {
        private Position p0;
        private Position p1;
        protected Highlighter.HighlightPainter painter;
        private ParserNotice notice;

        private HighlightInfo() {
        }

        public Color getColor() {
            Color color = null;
            if (this.notice != null && (color = this.notice.getColor()) == null) {
                color = DEFAULT_PARSER_NOTICE_COLOR;
            }
            return color;
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    private static class DocumentRangeImpl
    implements DocumentRange {
        private int startOffs;
        private int endOffs;

        public DocumentRangeImpl(int startOffs, int endOffs) {
            this.startOffs = startOffs;
            this.endOffs = endOffs;
        }

        public int getEndOffset() {
            return this.endOffs;
        }

        public int getStartOffset() {
            return this.startOffs;
        }
    }
}

