/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.io.File;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfig;
import org.nuiton.wikitty.jdbc.WikittyExtensionStorageJDBC;
import org.nuiton.wikitty.jdbc.WikittyStorageJDBC;
import org.nuiton.wikitty.services.WikittyServiceStorage;
import org.nuiton.wikitty.storage.solr.RAMDirectoryFactory;
import org.nuiton.wikitty.storage.solr.WikittySearchEngineSolr;

public class WikittyServiceInMemoryJdbcSolr
extends WikittyServiceStorage {
    private static Log log = LogFactory.getLog(WikittyServiceInMemoryJdbcSolr.class);

    public WikittyServiceInMemoryJdbcSolr() {
        super(null, null, null);
        String dbName = "wikitty-tx-" + UUID.randomUUID().toString();
        WikittyConfig config = new WikittyConfig();
        config.setOption(WikittyConfig.WikittyOption.WIKITTY_STORAGE_JDBC_URL.getKey(), "jdbc:h2:mem:" + dbName);
        config.setOption(WikittyConfig.WikittyOption.WIKITTY_DATA_DIR.getKey(), config.getOption("java.io.tmpdir") + File.separator + dbName);
        config.setOption(WikittyConfig.WikittyOption.WIKITTY_SEARCHENGINE_SOLR_DIRECTORY_FACTORY.getKey(), RAMDirectoryFactory.class.getName());
        this.extensionStorage = new WikittyExtensionStorageJDBC((ApplicationConfig)config);
        this.wikittyStorage = new WikittyStorageJDBC((ApplicationConfig)config, this.extensionStorage);
        this.searchEngine = new WikittySearchEngineSolr((ApplicationConfig)config, this.extensionStorage);
    }
}

