/*
 * Decompiled with CFR 0.152.
 */
package org.htmlcleaner;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.htmlcleaner.CleanerProperties;
import org.htmlcleaner.DoctypeToken;
import org.htmlcleaner.HtmlCleaner;
import org.htmlcleaner.TagInfo;
import org.htmlcleaner.TagNode;
import org.htmlcleaner.Utils;

public abstract class XmlSerializer {
    protected CleanerProperties props;

    protected XmlSerializer(CleanerProperties props) {
        this.props = props;
    }

    public void writeXmlToStream(TagNode tagNode, OutputStream out, String charset) throws IOException {
        this.writeXml(tagNode, new OutputStreamWriter(out, charset), charset);
    }

    public void writeXmlToStream(TagNode tagNode, OutputStream out) throws IOException {
        this.writeXmlToStream(tagNode, out, HtmlCleaner.DEFAULT_CHARSET);
    }

    public void writeXmlToFile(TagNode tagNode, String fileName, String charset) throws IOException {
        this.writeXmlToStream(tagNode, new FileOutputStream(fileName), charset);
    }

    public void writeXmlToFile(TagNode tagNode, String fileName) throws IOException {
        this.writeXmlToFile(tagNode, fileName, HtmlCleaner.DEFAULT_CHARSET);
    }

    public String getXmlAsString(TagNode tagNode, String charset) throws IOException {
        StringWriter writer = new StringWriter();
        this.writeXml(tagNode, writer, charset);
        return writer.getBuffer().toString();
    }

    public String getXmlAsString(TagNode tagNode) throws IOException {
        return this.getXmlAsString(tagNode, HtmlCleaner.DEFAULT_CHARSET);
    }

    public void writeXml(TagNode tagNode, Writer writer, String charset) throws IOException {
        DoctypeToken doctypeToken;
        writer = new BufferedWriter(writer);
        if (!this.props.isOmitXmlDeclaration()) {
            String declaration = "<?xml version=\"1.0\"";
            if (charset != null) {
                declaration = declaration + " encoding=\"" + charset + "\"";
            }
            declaration = declaration + "?>";
            writer.write(declaration + "\n");
        }
        if (!this.props.isOmitDoctypeDeclaration() && (doctypeToken = tagNode.getDocType()) != null) {
            doctypeToken.serialize(this, writer);
        }
        this.serialize(tagNode, writer);
        writer.flush();
        writer.close();
    }

    protected String escapeXml(String xmlContent) {
        return Utils.escapeXml(xmlContent, this.props, false);
    }

    protected boolean dontEscape(TagNode tagNode) {
        String tagName = tagNode.getName();
        return this.props.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName));
    }

    protected boolean isScriptOrStyle(TagNode tagNode) {
        String tagName = tagNode.getName();
        return "script".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName);
    }

    protected boolean isMinimizedTagSyntax(TagNode tagNode) {
        TagInfo tagInfo = this.props.getTagInfoProvider().getTagInfo(tagNode.getName());
        return tagNode.getChildren().size() == 0 && (this.props.isUseEmptyElementTags() || tagInfo != null && tagInfo.isEmptyTag());
    }

    protected void serializeOpenTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        String tagName = tagNode.getName();
        Map tagAtttributes = tagNode.getAttributes();
        writer.write("<" + tagName);
        Iterator it = tagAtttributes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String attName = (String)entry.getKey();
            String attValue = (String)entry.getValue();
            if (!this.props.isNamespacesAware() && ("xmlns".equals(attName) || attName.startsWith("xmlns:"))) continue;
            writer.write(" " + attName + "=\"" + this.escapeXml(attValue) + "\"");
        }
        if (this.isMinimizedTagSyntax(tagNode)) {
            writer.write(" />");
            if (newLine) {
                writer.write("\n");
            }
        } else if (this.dontEscape(tagNode)) {
            writer.write("><![CDATA[");
        } else {
            writer.write(">");
        }
    }

    protected void serializeOpenTag(TagNode tagNode, Writer writer) throws IOException {
        this.serializeOpenTag(tagNode, writer, true);
    }

    protected void serializeEndTag(TagNode tagNode, Writer writer, boolean newLine) throws IOException {
        String tagName = tagNode.getName();
        if (this.dontEscape(tagNode)) {
            writer.write("]]>");
        }
        writer.write("</" + tagName + ">");
        if (newLine) {
            writer.write("\n");
        }
    }

    protected void serializeEndTag(TagNode tagNode, Writer writer) throws IOException {
        this.serializeEndTag(tagNode, writer, true);
    }

    protected abstract void serialize(TagNode var1, Writer var2) throws IOException;
}

