/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.runtime.processors;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.webharvest.definition.BaseElementDef;
import org.webharvest.definition.IElementDef;
import org.webharvest.runtime.Scraper;
import org.webharvest.runtime.ScraperContext;
import org.webharvest.runtime.processors.BodyProcessor;
import org.webharvest.runtime.processors.ProcessorResolver;
import org.webharvest.runtime.templaters.BaseTemplater;
import org.webharvest.runtime.variables.EmptyVariable;
import org.webharvest.runtime.variables.NodeVariable;
import org.webharvest.runtime.variables.Variable;
import org.webharvest.utils.CommonUtil;
import org.webharvest.utils.KeyValuePair;

public abstract class BaseProcessor {
    protected BaseElementDef elementDef;
    private Map properties = new LinkedHashMap();

    public abstract Variable execute(Scraper var1, ScraperContext var2);

    protected BaseProcessor() {
    }

    protected BaseProcessor(BaseElementDef elementDef) {
        this.elementDef = elementDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Variable run(Scraper scraper, ScraperContext context) {
        int scraperStatus = scraper.getStatus();
        if (scraperStatus == 4 || scraperStatus == 6) {
            return EmptyVariable.INSTANCE;
        }
        if (scraperStatus == 2) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
            try {
                Scraper scraper2 = scraper;
                synchronized (scraper2) {
                    if (scraper.getLogger().isInfoEnabled()) {
                        scraper.getLogger().info((Object)("Execution paused [" + dateFormatter.format(new Date()) + "]."));
                    }
                    scraper.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            scraper.continueExecution();
            if (scraper.getLogger().isInfoEnabled()) {
                scraper.getLogger().info((Object)("Execution continued [" + dateFormatter.format(new Date()) + "]."));
            }
        }
        long startTime = System.currentTimeMillis();
        int runningLevel = scraper.getRunningLevel();
        String id = this.elementDef != null ? BaseTemplater.execute(this.elementDef.getId(), scraper.getScriptEngine()) : null;
        String idDesc = id != null ? "[ID=" + id + "] " : "";
        String indent = CommonUtil.replicate("    ", runningLevel - 1);
        this.setProperty("ID", id);
        if (scraper.getLogger().isInfoEnabled()) {
            scraper.getLogger().info((Object)(indent + CommonUtil.getClassName(this) + " starts processing..." + idDesc));
        }
        scraper.setExecutingProcessor(this);
        Variable result = this.execute(scraper, context);
        long executionTime = System.currentTimeMillis() - startTime;
        this.setProperty("[Execution Time]", new Long(executionTime));
        this.setProperty("[Value]", result);
        scraper.processorFinishedExecution(this, this.properties);
        scraper.finishExecutingProcessor();
        if (scraper.isDebugMode() && id != null) {
            this.writeDebugFile(result, id, scraper);
        }
        if (scraper.getLogger().isInfoEnabled()) {
            scraper.getLogger().info((Object)(indent + CommonUtil.getClassName(this) + " processor executed in " + executionTime + "ms." + idDesc));
        }
        return result;
    }

    protected void setProperty(String name, Object value) {
        if (name != null && !"".equals(name) && value != null) {
            this.properties.put(name, value);
        }
    }

    protected void debug(BaseElementDef elementDef, Scraper scraper, Variable variable) {
        String id;
        String string = id = elementDef != null ? BaseTemplater.execute(elementDef.getId(), scraper.getScriptEngine()) : null;
        if (scraper.isDebugMode() && id != null && variable != null) {
            this.writeDebugFile(variable, id, scraper);
        }
    }

    protected Variable getBodyTextContent(BaseElementDef elementDef, Scraper scraper, ScraperContext context, boolean registerExecution, KeyValuePair[] properties) {
        if (elementDef == null) {
            return null;
        }
        if (elementDef.hasOperations()) {
            BodyProcessor bodyProcessor = new BodyProcessor(elementDef);
            if (properties != null) {
                for (int i = 0; i < properties.length; ++i) {
                    bodyProcessor.setProperty(properties[i].getKey(), properties[i].getValue());
                }
            }
            Variable body = registerExecution ? bodyProcessor.run(scraper, context) : bodyProcessor.execute(scraper, context);
            return new NodeVariable(body == null ? "" : body.toString());
        }
        return new NodeVariable(elementDef.getBodyText());
    }

    protected Variable getBodyTextContent(BaseElementDef elementDef, Scraper scraper, ScraperContext context, boolean registerExecution) {
        return this.getBodyTextContent(elementDef, scraper, context, registerExecution, null);
    }

    protected Variable getBodyTextContent(BaseElementDef elementDef, Scraper scraper, ScraperContext context) {
        return this.getBodyTextContent(elementDef, scraper, context, false);
    }

    protected BaseProcessor[] getSubprocessors(Scraper scraper) {
        IElementDef[] defs = this.elementDef.getOperationDefs();
        BaseProcessor[] result = new BaseProcessor[defs.length];
        for (int i = 0; i < defs.length; ++i) {
            result[i] = ProcessorResolver.createProcessor(defs[i], scraper.getConfiguration(), scraper);
        }
        return result;
    }

    public BaseElementDef getElementDef() {
        return this.elementDef;
    }

    private void writeDebugFile(Variable var, String processorId, Scraper scraper) {
        byte[] data = var == null ? new byte[]{} : var.toString().getBytes();
        String workingDir = scraper.getWorkingDir();
        String dir = CommonUtil.getAbsoluteFilename(workingDir, "_debug");
        int index = 1;
        String fullPath = dir + "/" + processorId + "_" + index + ".debug";
        while (new File(fullPath).exists()) {
            fullPath = dir + "/" + processorId + "_" + ++index + ".debug";
        }
        try {
            new File(dir).mkdirs();
            FileOutputStream out = new FileOutputStream(fullPath, false);
            out.write(data);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

