/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.webharvest.utils.CommonUtil;

public class TableHeaderRenderer
extends JLabel
implements TableCellRenderer {
    protected int[] aligns = null;
    private boolean drawTopLine = true;
    private boolean drawBottomLine = true;

    public TableHeaderRenderer() {
        this.setOpaque(true);
        Border headerCellBorder = new Border(){

            @Override
            public Insets getBorderInsets(Component c) {
                return new Insets(1, 2, 1, 2);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(Color.gray);
                if (TableHeaderRenderer.this.drawTopLine) {
                    g.drawLine(0, 0, width - 1, 0);
                }
                g.drawLine(width - 1, 0, width - 1, height - 1);
                if (TableHeaderRenderer.this.drawBottomLine) {
                    g.drawLine(0, height - 1, width - 1, height - 1);
                }
            }
        };
        this.setBorder(headerCellBorder);
    }

    public void setAligns(int[] aligns) {
        this.aligns = aligns;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String text = CommonUtil.nvl(value, "");
        String[] tokens = CommonUtil.tokenize(text, "\n");
        String colName = tokens.length > 0 ? tokens[0] : " ";
        this.setText(colName);
        this.setToolTipText(tokens.length > 1 ? tokens[1] : colName);
        this.setBackground(new Color(200, 198, 188));
        this.setForeground(Color.black);
        if (this.aligns != null && column < this.aligns.length) {
            this.setHorizontalAlignment(this.aligns[column]);
        }
        return this;
    }

    public boolean isDrawTopLine() {
        return this.drawTopLine;
    }

    public void setDrawTopLine(boolean drawTopLine) {
        this.drawTopLine = drawTopLine;
    }

    public boolean isDrawBottomLine() {
        return this.drawBottomLine;
    }

    public void setDrawBottomLine(boolean drawBottomLine) {
        this.drawBottomLine = drawBottomLine;
    }
}

