/*
 * Decompiled with CFR 0.152.
 */
package org.webharvest.gui.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.webharvest.gui.GuiUtils;
import org.webharvest.gui.component.CommonDialog;
import org.webharvest.gui.component.WHTextField;

public class InputDialog
extends CommonDialog {
    private Component caller;
    private String result = null;
    private WHTextField inputField;

    public InputDialog(Component caller, String title, String message, String value, int textFieldSize, Icon icon) {
        super(title);
        this.caller = caller;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new FlowLayout(1, 2, 0));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel label = new JLabel(message);
        label.setIcon(icon);
        this.inputField = new WHTextField(value, textFieldSize);
        this.inputField.selectAll();
        panel.add((Component)label, "West");
        panel.add((Component)this.inputField, "Center");
        contentPane.add((Component)panel, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(1, 3, 4));
        buttonPanel.add(this.createOkButton());
        buttonPanel.add(this.createCancelButton());
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
    }

    @Override
    protected void onOk() {
        if (!"".equals(this.inputField.getText().trim())) {
            this.result = this.inputField.getText();
            this.setVisible(false);
        } else {
            this.inputField.requestFocus();
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            Component relativeTo = this.caller;
            if (relativeTo == null) {
                relativeTo = GuiUtils.getActiveFrame();
            }
            if (relativeTo != null) {
                GuiUtils.centerRelativeTo(this, relativeTo);
            }
        }
        super.setVisible(b);
    }

    public String getValue() {
        this.setVisible(true);
        return this.result;
    }
}

