/*
 * Decompiled with CFR 0.152.
 */
package org.bounce.text.xml;

import java.awt.Color;
import java.util.Hashtable;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class XMLContext
extends StyleContext {
    private static final long serialVersionUID = 3905522717859263025L;
    private Hashtable styles = new Hashtable();

    public XMLContext() {
        this.setDefaultStyles();
    }

    private void setDefaultStyles() {
        this.setStyle("element-name", new Color(0, 51, 102), 0);
        this.setStyle("element-value", Color.black, 0);
        this.setStyle("element-prefix", new Color(0, 102, 102), 0);
        this.setStyle("attribute-name", new Color(153, 51, 51), 0);
        this.setStyle("attribute-value", new Color(102, 0, 0), 0);
        this.setStyle("attribute-prefix", new Color(0, 102, 102), 0);
        this.setStyle("namespace-name", new Color(102, 102, 102), 0);
        this.setStyle("namespace-value", new Color(0, 51, 51), 0);
        this.setStyle("namespace-prefix", new Color(0, 102, 102), 0);
        this.setStyle("Entity", new Color(102, 102, 102), 0);
        this.setStyle("Comment", new Color(153, 153, 153), 0);
        this.setStyle("CData", new Color(0, 0, 0), 0);
        this.setStyle("Special", new Color(102, 102, 102), 0);
    }

    public void setStyle(String token, Color foreground, int style) {
        this.setForeground(token, foreground);
        this.setFontStyle(token, style);
    }

    public void setFontStyle(String token, int style) {
        Style s = this.getStyle(token);
        StyleConstants.setItalic(s, (style & 2) > 0);
        StyleConstants.setBold(s, (style & 1) > 0);
    }

    public void setForeground(String token, Color color) {
        Style s = this.getStyle(token);
        StyleConstants.setForeground(s, color);
    }

    public Color getForeground(String token) {
        Style s;
        if (token != null && (s = (Style)this.styles.get(token)) != null) {
            return super.getForeground(s);
        }
        return Color.black;
    }

    public int getFontStyle(Style style) {
        int fontStyle = 0;
        if (style != null) {
            if (StyleConstants.isItalic(style)) {
                fontStyle += 2;
            }
            if (StyleConstants.isBold(style)) {
                ++fontStyle;
            }
        }
        return fontStyle;
    }

    public Color getForeground(Style style) {
        if (style != null) {
            return super.getForeground(style);
        }
        return null;
    }

    @Override
    public Style getStyle(String token) {
        if (token != null) {
            Style result = (Style)this.styles.get(token);
            if (result == null) {
                result = new StyleContext.NamedStyle(this);
                this.styles.put(token, result);
            }
            return result;
        }
        return null;
    }
}

