/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.extractor;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.DelegatingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class EmbeddedDocumentExtractor {
    private static final File ABSTRACT_PATH = new File("");
    private static final Parser DELEGATING_PARSER = new DelegatingParser();
    private final ParseContext context;

    public EmbeddedDocumentExtractor(ParseContext context) {
        this.context = context;
    }

    public boolean shouldParseEmbedded(Metadata metadata) {
        String name;
        DocumentSelector selector = this.context.get(DocumentSelector.class);
        if (selector != null) {
            return selector.select(metadata);
        }
        FilenameFilter filter = this.context.get(FilenameFilter.class);
        if (filter != null && (name = metadata.get("resourceName")) != null) {
            return filter.accept(ABSTRACT_PATH, name);
        }
        return true;
    }

    public void parseEmbedded(InputStream stream, ContentHandler handler, Metadata metadata, boolean outputHtml) throws SAXException, IOException {
        String name;
        if (outputHtml) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "package-entry");
            handler.startElement("http://www.w3.org/1999/xhtml", "div", "div", attributes);
        }
        if ((name = metadata.get("resourceName")) != null && name.length() > 0 && outputHtml) {
            handler.startElement("http://www.w3.org/1999/xhtml", "h1", "h1", new AttributesImpl());
            char[] chars = name.toCharArray();
            handler.characters(chars, 0, chars.length);
            handler.endElement("http://www.w3.org/1999/xhtml", "h1", "h1");
        }
        try {
            DELEGATING_PARSER.parse(new CloseShieldInputStream(stream), new EmbeddedContentHandler(new BodyContentHandler(handler)), metadata, this.context);
        }
        catch (TikaException e) {
            // empty catch block
        }
        if (outputHtml) {
            handler.endElement("http://www.w3.org/1999/xhtml", "div", "div");
        }
    }
}

