/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;

public class Translate
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return StringValue.EMPTY_STRING;
        }
        CharSequence charSequence = atomicValue.getStringValueCS();
        atomicValue = (AtomicValue)this.argument[1].evaluateItem(xPathContext);
        CharSequence charSequence2 = atomicValue.getStringValueCS();
        atomicValue = (AtomicValue)this.argument[2].evaluateItem(xPathContext);
        CharSequence charSequence3 = atomicValue.getStringValueCS();
        return StringValue.makeStringValue(Translate.translate(charSequence, charSequence2, charSequence3));
    }

    private static CharSequence translate(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        int n = StringValue.getStringLength(charSequence);
        int n2 = StringValue.getStringLength(charSequence2);
        int n3 = StringValue.getStringLength(charSequence3);
        if (charSequence.length() != n || charSequence2.length() != n2 || charSequence3.length() != n3) {
            return Translate.slowTranslate(charSequence, charSequence2, charSequence3);
        }
        String string = ((Object)charSequence2).toString();
        FastStringBuffer fastStringBuffer = new FastStringBuffer(charSequence.length());
        int n4 = charSequence3.length();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            int n5 = string.indexOf(c);
            if (n5 >= n4) continue;
            fastStringBuffer.append(n5 < 0 ? c : charSequence3.charAt(n5));
        }
        return fastStringBuffer;
    }

    private static CharSequence slowTranslate(CharSequence charSequence, CharSequence charSequence2, CharSequence charSequence3) {
        int[] nArray = StringValue.expand(charSequence);
        int[] nArray2 = StringValue.expand(charSequence2);
        int[] nArray3 = StringValue.expand(charSequence3);
        StringBuffer stringBuffer = new StringBuffer(charSequence.length());
        for (int i = 0; i < nArray.length; ++i) {
            int n;
            int n2 = nArray[i];
            int n3 = -1;
            for (n = 0; n < nArray2.length; ++n) {
                if (nArray2[n] != n2) continue;
                n3 = n;
                break;
            }
            n = -1;
            if (n3 < 0) {
                n = nArray[i];
            } else if (n3 < nArray3.length) {
                n = nArray3[n3];
            }
            if (n < 0) continue;
            if (n < 65536) {
                stringBuffer.append((char)n);
                continue;
            }
            stringBuffer.append((char)((n -= 65536) / 1024 + 55296));
            stringBuffer.append((char)(n % 1024 + 56320));
        }
        return stringBuffer;
    }
}

