/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.widgets;

import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.widgets.MultipleSelectionPane;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import jaxx.runtime.SwingUtil;
import org.nuiton.wikitty.entities.BusinessEntity;

public abstract class MultipleSelectionHandler<D, B extends BusinessEntity, H> {
    protected MultipleSelectionPane<D, B> ui;
    protected Map<String, D> addedDatas;
    protected Class<H> handlerClass;

    public MultipleSelectionHandler(MultipleSelectionPane<D, B> ui, Class<H> handlerClass) {
        this.ui = ui;
        this.handlerClass = handlerClass;
        this.addedDatas = new HashMap<String, D>();
    }

    public H getHandler() {
        return UIHelper.getHandler(this.ui, this.handlerClass);
    }

    protected JList getList() {
        return this.ui.getList();
    }

    protected DefaultListModel getListModel() {
        return this.ui.getListModel();
    }

    protected B getBean() {
        return this.ui.getBean();
    }

    protected void setBean(B bean) {
        this.ui.setBean(bean);
    }

    public Collection<D> getAddedDatas() {
        return this.addedDatas.values();
    }

    public D getAddedData(String id) {
        return this.addedDatas.get(id);
    }

    public abstract void init();

    public abstract void add();

    public abstract void remove();

    public abstract void openSelected(String var1);

    protected void addToList(D addedData, String data) {
        if (data != null) {
            this.getListModel().addElement(data);
        }
        if (addedData != null) {
            this.addedDatas.put(data, addedData);
        }
    }

    protected void removeFromList(List<String> datas) {
        for (String data : datas) {
            this.getListModel().removeElement(data);
        }
    }

    protected void removeFromList(String data) {
        this.getListModel().removeElement(data);
    }

    protected void fillList(Collection<String> datas) {
        this.getList().removeAll();
        SwingUtil.fillList((JList)this.getList(), datas, null);
    }

    protected List<String> getSelectedInList() {
        Object[] objects = this.getList().getSelectedValues();
        String[] selected = new String[objects.length];
        int cnt = 0;
        for (Object o : objects) {
            selected[cnt] = (String)o;
            ++cnt;
        }
        List<String> selectedList = Arrays.asList(selected);
        return selectedList;
    }
}

