/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.tree.helpers;

import com.jurismarches.vradi.VradiEntitiesListener;
import com.jurismarches.vradi.ui.tree.VradiDataProvider;
import com.jurismarches.vradi.ui.tree.VradiTreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.tree.NavTreeBridge;
import jaxx.runtime.swing.nav.tree.NavTreeHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.entities.BusinessEntity;

public abstract class VradiTreeHelper<C extends BusinessEntity>
extends NavTreeHelper<VradiTreeNode>
implements VradiEntitiesListener<C> {
    private static final Log log = LogFactory.getLog(VradiTreeHelper.class);
    protected List<String> idsLoaded = new ArrayList<String>();

    public void setUI(JTree tree, boolean addExpandTreeListener, boolean addOneClickSelectionListener, TreeSelectionListener listener, TreeWillExpandListener willExpandListener) {
        super.setUI(tree, addExpandTreeListener, addOneClickSelectionListener, listener, willExpandListener);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                VradiTreeNode node = (VradiTreeNode)((Object)event.getPath().getLastPathComponent());
                VradiTreeHelper.this.registerLoadedIds(node);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                VradiTreeNode node = (VradiTreeNode)((Object)event.getPath().getLastPathComponent());
                Enumeration enumeration = node.children();
                while (enumeration.hasMoreElements()) {
                    VradiTreeNode child = (VradiTreeNode)((Object)enumeration.nextElement());
                    VradiTreeHelper.this.idsLoaded.remove(child.getId());
                }
            }
        });
    }

    public void selectNode(VradiTreeNode node) {
        super.selectNode((NavNode)node);
        this.registerLoadedIds(node);
    }

    public VradiDataProvider getDataProvider() {
        return (VradiDataProvider)this.dataProvider;
    }

    public VradiTreeNode getSelectedNode() {
        return (VradiTreeNode)super.getSelectedNode();
    }

    public VradiTreeNode findNode(VradiTreeNode node, String ... ids) {
        return (VradiTreeNode)super.findNode((NavNode)node, ids);
    }

    public VradiTreeNode getRootNode() {
        return (VradiTreeNode)super.getRootNode();
    }

    public List<String> getLoadedIds() {
        return this.idsLoaded;
    }

    public boolean isLoadedId(String id) {
        return this.idsLoaded.contains(id);
    }

    public void registerLoadedIds(VradiTreeNode node) {
        this.idsLoaded.add(node.getId());
        Enumeration enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            VradiTreeNode child = (VradiTreeNode)((Object)enumeration.nextElement());
            this.idsLoaded.add(child.getId());
        }
    }

    public void refresh(VradiTreeNode node) {
        if (node == null) {
            return;
        }
        ((NavTreeBridge)this.getBridge()).nodeChanged((TreeNode)((Object)node));
    }

    public abstract void createEntityNode(String var1);

    @Override
    public void entitiesAdded(Set<C> added) {
        log.info((Object)("entityAdded : " + added.size()));
        for (BusinessEntity entity : added) {
            String wikittyId = entity.getWikittyId();
            VradiTreeNode existingNode = this.findNode(this.getRootNode(), wikittyId);
            if (existingNode != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Client modification occured");
                }
                this.refresh(existingNode);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Client creation occured");
            }
            this.createEntityNode(wikittyId);
        }
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        log.info((Object)("entityRemoved : " + removed.size()));
        this.removeEntities(removed);
    }

    public void removeEntities(Collection<String> entities) {
        for (String wikittyId : entities) {
            if (!this.isLoadedId(wikittyId)) continue;
            VradiTreeNode node = this.findNode(this.getRootNode(), wikittyId);
            this.idsLoaded.remove(wikittyId);
            if (node == null) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing node " + wikittyId + " from parent"));
            }
            VradiTreeNode parent = (VradiTreeNode)node.getParent();
            int index = parent.getIndex((TreeNode)((Object)node));
            node.removeFromParent();
            ((NavTreeBridge)this.getBridge()).nodesWereRemoved((TreeNode)((Object)parent), new int[]{index}, (Object[])new VradiTreeNode[]{node});
        }
    }
}

