/*
 * Decompiled with CFR 0.152.
 */
package com.jurismarches.vradi.ui.offer;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.VradiHelper;
import com.jurismarches.vradi.entities.FieldTypeEnum;
import com.jurismarches.vradi.entities.Form;
import com.jurismarches.vradi.entities.FormImpl;
import com.jurismarches.vradi.entities.FormLink;
import com.jurismarches.vradi.entities.FormLinkImpl;
import com.jurismarches.vradi.entities.FormLinkTypeEnum;
import com.jurismarches.vradi.entities.ModificationTag;
import com.jurismarches.vradi.entities.Status;
import com.jurismarches.vradi.entities.Thesaurus;
import com.jurismarches.vradi.entities.VradiUser;
import com.jurismarches.vradi.entities.XmlStream;
import com.jurismarches.vradi.services.VradiDataService;
import com.jurismarches.vradi.services.VradiException;
import com.jurismarches.vradi.services.VradiService;
import com.jurismarches.vradi.services.VradiStorageService;
import com.jurismarches.vradi.ui.VradiMainUIHandler;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.offer.OfferEditUI;
import com.jurismarches.vradi.ui.offer.OfferListColumnFactory;
import com.jurismarches.vradi.ui.offer.OfferListHandler;
import com.jurismarches.vradi.ui.offer.OfferListUI;
import com.jurismarches.vradi.ui.offer.OfferTable;
import com.jurismarches.vradi.ui.offer.RequestFormViewHandler;
import com.jurismarches.vradi.ui.offer.RequestFormViewUI;
import com.jurismarches.vradi.ui.offer.ThesaurusHandler;
import com.jurismarches.vradi.ui.offer.ThesaurusUI;
import com.jurismarches.vradi.ui.offer.editors.CurrencyEditor;
import com.jurismarches.vradi.ui.offer.editors.DateEditor;
import com.jurismarches.vradi.ui.offer.editors.DateTimeEditor;
import com.jurismarches.vradi.ui.offer.editors.EmailEditor;
import com.jurismarches.vradi.ui.offer.editors.NumEditor;
import com.jurismarches.vradi.ui.offer.editors.StringEditor;
import com.jurismarches.vradi.ui.offer.editors.TextEditor;
import com.jurismarches.vradi.ui.offer.editors.UrlEditor;
import com.jurismarches.vradi.ui.offer.editors.VradiEditor;
import com.jurismarches.vradi.ui.offer.models.OfferListTableModel;
import com.jurismarches.vradi.ui.offer.widgets.SelectFormUI;
import com.jurismarches.vradi.ui.search.SearchHandler;
import com.jurismarches.vradi.ui.search.SearchUI;
import com.jurismarches.vradi.ui.task.VradiTask;
import com.jurismarches.vradi.ui.widgets.MultipleSelectionPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultListModel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.context.JAXXInitialContext;
import jaxx.runtime.swing.ErrorDialogUI;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.FileUtil;
import org.nuiton.wikitty.WikittyObsoleteException;
import org.nuiton.wikitty.WikittyProxy;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.FieldType;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyExtension;

public class OfferEditHandler {
    private static final Log log = LogFactory.getLog(OfferEditHandler.class);
    private static final String DEFAULT_EDITOR_NAME = "$default";
    public static final String REQUIRED_FIELD_CONTEXT = "required";
    protected static Map<String, Class<? extends VradiEditor<?, ?>>> editorMapping;

    protected VradiStorageService getVradiStorageService() {
        return VradiService.getVradiStorageService();
    }

    protected VradiDataService getDataService() {
        return VradiService.getVradiDataService();
    }

    public OfferEditUI initUI(JAXXContext rootContext, String formId) {
        Form data = (Form)VradiService.getWikittyProxy().restore(Form.class, formId);
        return this.initUI(rootContext, data);
    }

    public OfferEditUI initUI(JAXXContext rootContext, Form data) {
        JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext).add((Object)this).add((Object)data);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load form '" + data.getObjet() + "' with status : " + data.getStatus()));
        }
        UIHelper.getHandler((JAXXContext)context, ThesaurusHandler.class);
        OfferEditUI ui = new OfferEditUI((JAXXContext)context);
        this.fillfields(ui, data);
        try {
            List thesaurusToPropose = this.getDataService().proposeThesaurus(data.getWikittyId());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Find " + thesaurusToPropose.size() + " thesaurus to propose for form " + data.getObjet()));
            }
            this.addPropositions((JAXXContext)ui, thesaurusToPropose.toArray(new Thesaurus[thesaurusToPropose.size()]));
        }
        catch (VradiException eee) {
            log.error((Object)"Cant get propositions of thesaurus ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)((Object)eee));
        }
        ThesaurusHandler thesaurusHandler = UIHelper.getHandler((JAXXContext)context, ThesaurusHandler.class);
        thesaurusHandler.initThesaurus(ui);
        return ui;
    }

    public void fillfields(OfferEditUI ui, Form form) {
        boolean isEditable;
        String previousReplaceForm = VradiService.getVradiDataService().getPreviousReplaceForm(form.getWikittyId());
        boolean bl = isEditable = previousReplaceForm == null;
        if (!isEditable) {
            Form previousForm = (Form)VradiService.getWikittyProxy().restore(Form.class, previousReplaceForm);
            ui.setPreviousForm(previousForm);
        }
        ui.setEditable(isEditable);
        Collection extensions = form.getExtensionNames();
        for (String extensionName : extensions) {
            if (extensionName.equals("ModificationTag") || extensionName.equals("Infogene") || extensionName.equals("Form")) continue;
            Wikitty wikitty = VradiService.getWikittyProxy().getWikitty((BusinessEntity)form);
            WikittyExtension extension = wikitty.getExtension(extensionName);
            Collection fieldNames = extension.getFieldNames();
            for (String fieldName : fieldNames) {
                this.createField(ui, extension, fieldName, form, isEditable);
            }
        }
    }

    protected void createField(OfferEditUI ui, WikittyExtension extension, String fieldName, BusinessEntity data, boolean isEditable) {
        VradiEditor editor;
        JPanel content = ui.getContent();
        FieldType fieldType = extension.getFieldType(fieldName);
        if (!fieldType.isCollection() && (editor = this.getEditor(fieldType, (JAXXContext)ui)) != null) {
            String extensionName = extension.getName();
            Object value = data.getField(extensionName, fieldName);
            String traduction = VradiHelper.getTraduction(extension, fieldName);
            editor.setFieldName(traduction);
            String fieldDesc = VradiHelper.getFieldTypeDescription(fieldType);
            editor.setFieldDescription(fieldDesc);
            editor.setExtensionName(extensionName);
            editor.setExtensionFieldName(fieldName);
            editor.setValue(value);
            if (fieldType.isNotNull()) {
                editor.setValidatorContext(REQUIRED_FIELD_CONTEXT);
            }
            editor.setEnabled(isEditable);
            content.add(editor);
            content.setVisible(true);
        }
    }

    public OfferEditUI getUI(JAXXContext context) {
        OfferEditUI ui = null;
        if (context instanceof OfferEditUI) {
            ui = (OfferEditUI)context;
        }
        if (ui == null) {
            ui = (OfferEditUI)context.getContextValue(OfferEditUI.class);
        }
        return ui;
    }

    protected void addPropositions(JAXXContext context, Thesaurus[] props) {
        OfferEditUI ui = this.getUI(context);
        DefaultListModel propositionListModel = ui.getPropositionListModel();
        propositionListModel.removeAllElements();
        for (Thesaurus p : props) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Add proposition element : " + p.getName()));
            }
            propositionListModel.addElement(p);
        }
    }

    protected void save(JAXXContext context, Form form) {
        Component[] components;
        log.info((Object)("Saving Form: " + form.getWikittyId()));
        WikittyProxy proxy = VradiService.getWikittyProxy();
        OfferEditUI offerEditUI = this.getUI(context);
        try {
            ArrayList<Thesaurus> thesaurusToSave = new ArrayList<Thesaurus>();
            for (Object s : offerEditUI.getPropositionList().getSelectedValues()) {
                Thesaurus selected = (Thesaurus)s;
                selected.addAttachment(form.getWikittyId());
                if (thesaurusToSave.contains(selected)) continue;
                thesaurusToSave.add(selected);
            }
            for (Component c : offerEditUI.getThesaurus().getComponents()) {
                Object[] selected;
                ThesaurusUI thesaurusUI = (ThesaurusUI)((Object)c);
                DefaultListModel model = thesaurusUI.getThesaurusSelectedModel();
                for (Object s : selected = model.toArray()) {
                    Thesaurus thesaurus = (Thesaurus)s;
                    thesaurus.addAttachment(form.getWikittyId());
                    if (thesaurusToSave.contains(thesaurus)) continue;
                    thesaurusToSave.add(thesaurus);
                }
            }
            List actualThesauruses = this.getDataService().getThesaurusAttachedToForm(form);
            for (Thesaurus actualThesaurus : actualThesauruses) {
                if (thesaurusToSave.contains(actualThesaurus)) continue;
                actualThesaurus.removeAttachment(form.getWikittyId());
                thesaurusToSave.add(actualThesaurus);
            }
            proxy.store(thesaurusToSave);
        }
        catch (Exception eee) {
            log.error((Object)"Can't save thesaurus : ", (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        JPanel content = offerEditUI.getContent();
        for (Component c : components = content.getComponents()) {
            VradiEditor editor = (VradiEditor)c;
            this.updateFormField(editor, form);
        }
        this.updateFormField(offerEditUI.getObjetEditor(), form);
        this.updateFormField(offerEditUI.getIdEditor(), form);
        this.updateFormField(offerEditUI.getSourceTextEditor(), form);
        this.updateFormField(offerEditUI.getSourceURLEditor(), form);
        this.updateFormField(offerEditUI.getEntityEditor(), form);
        this.updateFormField(offerEditUI.getCountryEditor(), form);
        this.updateFormField(offerEditUI.getDepartmentEditor(), form);
        this.updateFormField(offerEditUI.getDatePubEditor(), form);
        this.updateFormField(offerEditUI.getDatePeremeptionEditor(), form);
        this.updateFormField(offerEditUI.getDescriptionEditor(), form);
        VradiUser vradiUser = (VradiUser)context.getContextValue(VradiUser.class);
        ModificationTag formTag = (ModificationTag)VradiService.getWikittyProxy().cast((BusinessEntity)form, ModificationTag.class);
        formTag.setLastModified(new Date());
        formTag.setLastModifier(vradiUser.getLogin());
        try {
            for (File embeddedFile : offerEditUI.getEmbeddedFilePane().getAddedDatas()) {
                VradiService.getFileService().uploadFormEmbeddedFile(embeddedFile, form.getWikittyId());
            }
            for (File attachementFile : offerEditUI.getAttachmentFilePane().getAddedDatas()) {
                VradiService.getFileService().uploadFormAttachment(attachementFile, form.getWikittyId());
            }
        }
        catch (Exception eee) {
            log.error((Object)("Can't upload files for form : " + form.getObjet()), (Throwable)eee);
            ErrorDialogUI.showError((Exception)eee);
        }
        try {
            ArrayList<Object> toSave = new ArrayList<Object>();
            toSave.addAll(offerEditUI.getRelatedFormPane().getAddedDatas());
            toSave.addAll(offerEditUI.getReplaceFormPane().getAddedDatas());
            toSave.add(form);
            proxy.store(toSave);
        }
        catch (WikittyObsoleteException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Your form is obselete (" + form.getObjet() + ")"), (Throwable)eee);
            }
            JOptionPane.showMessageDialog(this.getUI(context), I18n._("vradi.error.formWikittyObselete", form.getObjet()), I18n._("vradi.error.formWikittyObselete.title"), 0);
        }
    }

    void updateFormField(VradiEditor editor, Form form) {
        String extensionName = editor.getExtensionName();
        String extensionFieldName = editor.getExtensionFieldName();
        Object value = editor.getValue();
        if (log.isDebugEnabled()) {
            log.debug((Object)("updating: " + extensionName + "." + extensionFieldName + "=" + value));
        }
        form.setField(extensionName, extensionFieldName, value);
    }

    protected void update(JAXXContext context) {
        VradiMainUIHandler rootHandler = (VradiMainUIHandler)VradiContext.get().getContextValue(VradiMainUIHandler.class);
        rootHandler.goToHome(context);
    }

    protected void findQueries(JAXXContext context) {
        OfferEditUI ui = this.getUI(context);
        Form form = ui.getData();
        try {
            Map queries = this.getDataService().findQueriesReturningForm(form.getWikittyId());
            RequestFormViewHandler handler = UIHelper.getHandler(context, RequestFormViewHandler.class);
            RequestFormViewUI requestFormViewUI = handler.initUI(context, queries);
            requestFormViewUI.setVisible(true);
        }
        catch (VradiException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            ErrorDialogUI.showError((Exception)((Object)e));
        }
    }

    public void viewInPDF(JAXXContext context) {
        final OfferEditUI ui = this.getUI(context);
        final Form form = ui.getData();
        VradiTask<String> generatePDF = new VradiTask<String>(context, false){

            @Override
            public String doAction() throws Exception {
                return VradiService.getVradiStorageService().generatePDF(form.getWikittyId(), true);
            }

            @Override
            public void doWhenDone() throws Exception {
                String fileUri = (String)this.get();
                if (fileUri == null) {
                    JOptionPane.showMessageDialog(ui, I18n._("vradi.offerEdit.cantGeneratePDF"), I18n._("vradi.offerEdit.cantGeneratePDFTitle"), 0);
                    return;
                }
                File file = VradiService.getFileService().downloadPDF(fileUri);
                Desktop.getDesktop().open(file);
            }
        };
        generatePDF.execute();
    }

    public File addEmbeddedFile(MultipleSelectionPane ui, Form form) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"addFile(context)");
        }
        FileFilter imageFileFilter = new FileFilter(){
            private final String[] FILTER_EXTENSIONS = new String[]{"jpg", "jpeg", "png", "gif"};

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                for (String extension : this.FILTER_EXTENSIONS) {
                    if (!file.getName().toLowerCase().endsWith(extension)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return "Images(.jpg, .jpeg, .png, .gif)";
            }
        };
        File file = FileUtil.getFile((Component)ui, (FileFilter[])new FileFilter[]{imageFileFilter});
        if (file != null) {
            form.addFiles(file.getName());
        }
        return file;
    }

    public List<String> removeEmbeddedFile(Form form, List<String> filesNamesToRemove) {
        for (String fileName : filesNamesToRemove) {
            form.removeFiles(fileName);
        }
        return filesNamesToRemove;
    }

    public File addAttachmentFile(MultipleSelectionPane ui, Form form) {
        File attachment;
        if (log.isDebugEnabled()) {
            log.debug((Object)"addAttachment(context)");
        }
        if ((attachment = FileUtil.getFile((Component)ui, (FileFilter[])new FileFilter[0])) != null) {
            form.addAttachments(attachment.getName());
        }
        return attachment;
    }

    public List<String> removeAttachmentFile(Form form, List<String> filesNamesToRemove) {
        for (String fileNameToRemove : filesNamesToRemove) {
            form.removeAttachments(fileNameToRemove);
        }
        return filesNamesToRemove;
    }

    protected synchronized VradiEditor getEditor(FieldType type, JAXXContext context) {
        String editorName;
        if (editorMapping == null) {
            editorMapping = new TreeMap();
            editorMapping.put(FieldTypeEnum.STRING.name(), StringEditor.class);
            editorMapping.put(FieldTypeEnum.DATE_TIME.name(), DateTimeEditor.class);
            editorMapping.put(FieldTypeEnum.DATE.name(), DateEditor.class);
            editorMapping.put(FieldTypeEnum.EMAIL.name(), EmailEditor.class);
            editorMapping.put(FieldTypeEnum.NUMERIC.name(), NumEditor.class);
            editorMapping.put(FieldTypeEnum.TEXT.name(), TextEditor.class);
            editorMapping.put(FieldTypeEnum.URL.name(), UrlEditor.class);
            editorMapping.put(FieldTypeEnum.CURRENCY.name(), CurrencyEditor.class);
            editorMapping.put(DEFAULT_EDITOR_NAME, StringEditor.class);
        }
        FieldTypeEnum typeEnum = FieldTypeEnum.valueOf(type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("typeEnum of type " + type + " = " + (Object)((Object)typeEnum)));
        }
        String string = editorName = typeEnum == null ? DEFAULT_EDITOR_NAME : typeEnum.name();
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor name for type [" + type.getType() + "] : " + editorName));
        }
        Class<VradiEditor<?, ?>> editorClass = editorMapping.get(editorName);
        if (log.isDebugEnabled()) {
            log.debug((Object)("editor class to use : " + editorClass));
        }
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = editorClass.getConstructors()) {
                if (constructor.getParameterTypes() == null || constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].equals(JAXXContext.class)) continue;
                VradiEditor editor = (VradiEditor)constructor.newInstance(context);
                editor.init();
                return editor;
            }
            return null;
        }
        catch (Exception eee) {
            throw new IllegalStateException(eee);
        }
    }

    public void changeStatusAndSave(JAXXContext context, Form form, Status status) {
        try {
            String intialStatus = form.getStatus();
            String updateStatus = status.getWikittyId();
            if (intialStatus == null || !updateStatus.equals(intialStatus)) {
                VradiUser vradiUser = (VradiUser)context.getContextValue(VradiUser.class);
                String statusModifier = vradiUser != null ? vradiUser.getLogin() : null;
                ModificationTag formTag = (ModificationTag)VradiService.getWikittyProxy().cast((BusinessEntity)form, ModificationTag.class);
                formTag.setLastModified(new Date());
                formTag.setLastModifier(statusModifier);
                formTag.setLastStatusModifier(statusModifier);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Updating: statusModifier=%s on form: %s", statusModifier, form.getWikittyId()));
                    log.debug((Object)String.format("New Status: %s, Old Status: %s", intialStatus, updateStatus));
                }
            }
            form.setStatus(updateStatus);
            this.save(context, form);
        }
        catch (Exception eee) {
            log.error((Object)("Cant change status for form '" + (form == null ? "null" : form.getObjet()) + "' with status '" + (status == null ? "null" : I18n._(status.getName())) + "'"), (Throwable)eee);
        }
    }

    public FormLink addRelatedForm(JAXXContext rootContext, Form form) {
        String name = JOptionPane.showInputDialog(I18n._("vradi.offerEdit.askRelatedFormName"));
        if (!StringUtils.isBlank((String)name)) {
            JAXXInitialContext context = new JAXXInitialContext().add((Object)rootContext);
            SearchHandler searchHandler = new SearchHandler();
            OfferListTableModel offerListTableModel = new OfferListTableModel();
            OfferListColumnFactory offerListColumnFactory = new OfferListColumnFactory();
            context.add((Object)searchHandler);
            context.add((Object)offerListTableModel);
            context.add((Object)offerListColumnFactory);
            SelectFormUI selectFormUI = new SelectFormUI((JAXXContext)context);
            OfferTable listTable = selectFormUI.getResultTable();
            TableModelListener offerListTableModelListener = this.getOfferListTableModelListener(listTable);
            offerListTableModel.addTableModelListener(offerListTableModelListener);
            OfferListTableModel.OfferListTableCellRenderer renderer = new OfferListTableModel.OfferListTableCellRenderer();
            listTable.setDefaultRenderer(Boolean.class, renderer);
            listTable.setDefaultRenderer(Date.class, renderer);
            listTable.setDefaultRenderer(Double.class, renderer);
            listTable.setDefaultRenderer(String.class, renderer);
            listTable.setDefaultRenderer(XmlStream.class, renderer);
            listTable.setDefaultRenderer(Status.class, renderer);
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)HighlighterFactory.NOTEPAD, (Color)HighlighterFactory.GENERIC_GRAY);
            listTable.addHighlighter(highlighter);
            SearchUI searchUI = searchHandler.initCloneUI((JAXXContext)context, offerListTableModel);
            selectFormUI.getSearchPanel().add((Component)((Object)searchUI), "Center");
            selectFormUI.setVisible(true);
            String selectedFormId = selectFormUI.getFormId();
            if (selectedFormId != null) {
                return this.createFormLink(name, FormLinkTypeEnum.RELATED, form.getWikittyId(), selectedFormId);
            }
        }
        return null;
    }

    private TableModelListener getOfferListTableModelListener(final JXTable listTable) {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                listTable.packAll();
            }
        };
    }

    public FormLink addReplaceForm(MultipleSelectionPane ui, Form form) {
        String name = JOptionPane.showInputDialog(I18n._("vradi.offerEdit.askReplaceFormName"));
        if (!StringUtils.isBlank((String)name)) {
            Wikitty formWikittyCloned = null;
            WikittyProxy wikittyProxy = VradiService.getWikittyProxy();
            try {
                formWikittyCloned = WikittyUtil.clone((Wikitty)wikittyProxy.getWikitty((BusinessEntity)form), (boolean)true);
                formWikittyCloned = wikittyProxy.store(formWikittyCloned);
            }
            catch (CloneNotSupportedException eee) {
                log.error((Object)("Cant clone form : " + form));
                ErrorDialogUI.showError((Exception)eee);
            }
            if (formWikittyCloned != null) {
                Form formCloned = new FormImpl(formWikittyCloned);
                formCloned = VradiHelper.initForm(formCloned);
                formCloned = (Form)wikittyProxy.store((BusinessEntity)formCloned);
                OfferListHandler listHandler = UIHelper.getHandler((JAXXContext)ui, OfferListHandler.class);
                OfferListUI offerListUI = (OfferListUI)VradiContext.OFFERT_LIST_UI_ENTRY_DEF.getContextValue((JAXXContext)VradiContext.get());
                OfferEditUI offerEditUI = listHandler.addEditPane((JAXXContext)offerListUI, formCloned);
                offerEditUI.setPreviousForm(form);
                offerEditUI.setEditable(false);
                return this.createFormLink(name, FormLinkTypeEnum.REPLACE, form.getWikittyId(), formCloned.getWikittyId());
            }
        }
        return null;
    }

    protected FormLink createFormLink(String name, FormLinkTypeEnum type, String fromFormId, String toFormId) {
        FormLink formLink = new FormLinkImpl();
        formLink.setName(name);
        formLink.setFromForm(fromFormId);
        formLink.setToForm(toFormId);
        formLink.setType(type.getValue());
        formLink = (FormLink)VradiService.getWikittyProxy().store((BusinessEntity)formLink);
        return formLink;
    }

    public List<String> removeLinkForm(List<String> formLinkIds) {
        WikittyProxy proxy = VradiService.getWikittyProxy();
        proxy.delete(formLinkIds);
        return formLinkIds;
    }
}

