/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.tools.osb.mbean.common;

import com.arjuna.ats.arjuna.ObjectStatus;
import com.arjuna.ats.arjuna.ObjectType;
import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.tools.osb.mbean.common.BasicBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.common.StateBeanMBean;
import com.arjuna.ats.arjuna.tools.osb.mbean.common.UidBean;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StateBean
extends UidBean
implements StateBeanMBean {
    public static final DateFormat formatter = new SimpleDateFormat("E, dd MMM yyyy HH:mm:ss Z");
    protected StateManagerInfo info;

    StateBean(BasicBean parent, Uid uid) {
        super(parent, uid);
    }

    public StateBean(BasicBean parent, ObjectStore store, Uid uid) {
        this(parent, parent.getType(), store, uid);
    }

    public StateBean(BasicBean parent, String type, ObjectStore store, Uid uid) {
        super(parent, type, uid);
        this.info = new StateManagerInfo(store, uid, type);
    }

    @Override
    public String getCreationTime() {
        return this.info.birthDate < 0L ? "" : formatter.format(new Date(this.info.birthDate));
    }

    @Override
    public long getAgeInSeconds() {
        return this.info.birthDate < 0L ? -1L : (System.currentTimeMillis() - this.info.birthDate) / 1000L;
    }

    @Override
    public String getUid() {
        return this.uid.stringForm();
    }

    public String getStoreRoot() {
        return this.info.getStoreRoot();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getStatus() {
        return ObjectStatus.toString(this.info.status());
    }

    @Override
    public String getObjectType() {
        return ObjectType.toString(this.info.ObjectType());
    }

    class StateManagerInfo
    extends StateManager {
        String state;
        Uid txId;
        Uid processUid;
        long birthDate;

        protected StateManagerInfo(ObjectStore os, Uid uid, String type) {
            block4: {
                super(uid);
                this.txId = Uid.nullUid();
                this.processUid = Uid.nullUid();
                this.birthDate = -1L;
                try {
                    this.unpackHeader(os.read_committed(uid, type));
                }
                catch (IOException e) {
                    if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                        tsLogger.arjLoggerI18N.info("org.jboss.jbosstm.tools.jmx.osb.MbState.m_1", new Object[]{e.getMessage()});
                    }
                }
                catch (ObjectStoreException e) {
                    if (!tsLogger.arjLoggerI18N.isInfoEnabled()) break block4;
                    tsLogger.arjLoggerI18N.info("org.jboss.jbosstm.tools.jmx.osb.MbState.m_1", new Object[]{e.getMessage()});
                }
            }
        }

        void unpackHeader(InputObjectState os) throws IOException {
            if (os != null) {
                this.state = os.unpackString();
                byte[] txIdBytes = os.unpackBytes();
                this.txId = new Uid(txIdBytes);
                if (this.state.equals("#ARJUNA#")) {
                    if (!this.txId.equals(Uid.nullUid())) {
                        byte[] pUidBytes = os.unpackBytes();
                        this.processUid = new Uid(pUidBytes);
                    }
                    this.birthDate = os.unpackLong();
                }
            }
        }
    }
}

