/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class PatternReplaceFilter
extends TokenFilter {
    private final Pattern p;
    private final String replacement;
    private final boolean all;
    private final TermAttribute termAtt;

    public PatternReplaceFilter(TokenStream in, Pattern p, String replacement, boolean all) {
        super(in);
        this.p = p;
        this.replacement = null == replacement ? "" : replacement;
        this.all = all;
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        CharBuffer text = CharBuffer.wrap(this.termAtt.termBuffer(), 0, this.termAtt.termLength());
        Matcher m = this.p.matcher(text);
        if (this.all) {
            this.termAtt.setTermBuffer(m.replaceAll(this.replacement));
        } else {
            this.termAtt.setTermBuffer(m.replaceFirst(this.replacement));
        }
        return true;
    }
}

