/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.application;

import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.StringUtil;

public class ActionWorker<R, P>
extends SwingWorker<R, P> {
    private static final Log log = LogFactory.getLog(ActionWorker.class);
    protected final String actionLabel;
    protected Runnable target;
    protected ActionStatus status;
    protected Exception error;
    protected long startTime;
    protected long endTime;

    public ActionWorker(String actionLabel) {
        this.actionLabel = actionLabel;
    }

    public ActionWorker(String actionLabel, Runnable target) {
        this.target = target;
        this.actionLabel = actionLabel;
    }

    public Runnable getTarget() {
        return this.target;
    }

    public void setTarget(Runnable target) {
        this.target = target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected R doInBackground() throws Exception {
        this.startTime = System.nanoTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + this.getActionLabel() + "] is starting..."));
        }
        try {
            this.getTarget().run();
        }
        catch (Exception e) {
            this.error = e;
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Action [" + this.getActionLabel() + "] is ending..."));
            }
        }
        return null;
    }

    public boolean isFailed() {
        return (this.isDone() || this.isCancelled()) && this.error != null;
    }

    public Exception getError() {
        return this.error;
    }

    public ActionStatus getStatus() {
        return this.status;
    }

    public String getActionLabel() {
        return this.actionLabel;
    }

    @Override
    protected void done() {
        super.done();
        this.endTime = System.nanoTime();
        this.status = this.error != null ? ActionStatus.FAIL : (this.isCancelled() ? ActionStatus.CANCEL : ActionStatus.OK);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Action [" + this.getActionLabel() + "] ends with status : " + (Object)((Object)this.status) + " in " + this.getTime()));
        }
    }

    public String getTime() {
        return StringUtil.convertTime((long)(this.endTime - this.startTime));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public static enum ActionStatus {
        OK,
        CANCEL,
        FAIL;

    }
}

