/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import groovyjarjarasm.asm.Label;
import groovyjarjarasm.asm.MethodVisitor;
import groovyjarjarasm.asm.Opcodes;
import groovyjarjarasm.asm.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.classgen.ClassGeneratorException;
import org.codehaus.groovy.classgen.Variable;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class BytecodeHelper
implements Opcodes {
    private MethodVisitor cv;

    public MethodVisitor getMethodVisitor() {
        return this.cv;
    }

    public BytecodeHelper(MethodVisitor cv) {
        this.cv = cv;
    }

    public void quickBoxIfNecessary(ClassNode type) {
        String descr = BytecodeHelper.getTypeDescription(type);
        if (type == ClassHelper.boolean_TYPE) {
            this.boxBoolean();
        } else if (ClassHelper.isPrimitiveType(type) && type != ClassHelper.VOID_TYPE) {
            if (type == ClassHelper.int_TYPE) {
                this.cv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(ScriptBytecodeAdapter.class.getName()), "integerValue", "(I)Ljava/lang/Integer;");
                return;
            }
            ClassNode wrapper = ClassHelper.getWrapper(type);
            String internName = BytecodeHelper.getClassInternalName(wrapper);
            this.cv.visitTypeInsn(187, internName);
            this.cv.visitInsn(89);
            if (type == ClassHelper.double_TYPE || type == ClassHelper.long_TYPE) {
                this.cv.visitInsn(94);
                this.cv.visitInsn(88);
            } else {
                this.cv.visitInsn(93);
                this.cv.visitInsn(88);
            }
            this.cv.visitMethodInsn(183, internName, "<init>", "(" + descr + ")V");
        }
    }

    public void quickUnboxIfNecessary(ClassNode type) {
        if (ClassHelper.isPrimitiveType(type) && type != ClassHelper.VOID_TYPE) {
            ClassNode wrapper = ClassHelper.getWrapper(type);
            String internName = BytecodeHelper.getClassInternalName(wrapper);
            if (type == ClassHelper.boolean_TYPE) {
                this.cv.visitTypeInsn(192, internName);
                this.cv.visitMethodInsn(182, internName, type.getName() + "Value", "()" + BytecodeHelper.getTypeDescription(type));
            } else {
                this.cv.visitTypeInsn(192, "java/lang/Number");
                this.cv.visitMethodInsn(182, "java/lang/Number", type.getName() + "Value", "()" + BytecodeHelper.getTypeDescription(type));
            }
        }
    }

    public void box(Class type) {
        if (type.isPrimitive() && type != Void.TYPE) {
            String returnString = "(" + BytecodeHelper.getTypeDescription(type) + ")Ljava/lang/Object;";
            this.cv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(ScriptBytecodeAdapter.class.getName()), "box", returnString);
        }
    }

    public void box(ClassNode type) {
        if (type.isPrimaryClassNode()) {
            return;
        }
        this.box(type.getTypeClass());
    }

    public void unbox(Class type) {
        if (type.isPrimitive() && type != Void.TYPE) {
            String returnString = "(Ljava/lang/Object;)" + BytecodeHelper.getTypeDescription(type);
            this.cv.visitMethodInsn(184, BytecodeHelper.getClassInternalName(ScriptBytecodeAdapter.class.getName()), type.getName() + "Unbox", returnString);
        }
    }

    public void unbox(ClassNode type) {
        if (type.isPrimaryClassNode()) {
            return;
        }
        this.unbox(type.getTypeClass());
    }

    public static String getClassInternalName(ClassNode t) {
        if (t.isPrimaryClassNode()) {
            return BytecodeHelper.getClassInternalName(t.getName());
        }
        return BytecodeHelper.getClassInternalName(t.getTypeClass());
    }

    public static String getClassInternalName(Class t) {
        return Type.getInternalName(t);
    }

    public static String getClassInternalName(String name) {
        return name.replace('.', '/');
    }

    public static String getMethodDescriptor(ClassNode returnType, Parameter[] parameters) {
        StringBuffer buffer = new StringBuffer("(");
        for (int i = 0; i < parameters.length; ++i) {
            buffer.append(BytecodeHelper.getTypeDescription(parameters[i].getType()));
        }
        buffer.append(")");
        buffer.append(BytecodeHelper.getTypeDescription(returnType));
        return buffer.toString();
    }

    public static String getMethodDescriptor(Class returnType, Class[] paramTypes) {
        StringBuffer buffer = new StringBuffer("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            buffer.append(BytecodeHelper.getTypeDescription(paramTypes[i]));
        }
        buffer.append(")");
        buffer.append(BytecodeHelper.getTypeDescription(returnType));
        return buffer.toString();
    }

    public static String getTypeDescription(Class c) {
        return Type.getDescriptor(c);
    }

    public static String getClassLoadingTypeDescription(ClassNode c) {
        StringBuffer buf = new StringBuffer();
        boolean array = false;
        while (c.isArray()) {
            buf.append('[');
            c = c.getComponentType();
            array = true;
        }
        if (ClassHelper.isPrimitiveType(c)) {
            buf.append(BytecodeHelper.getTypeDescription(c));
        } else {
            if (array) {
                buf.append('L');
            }
            buf.append(c.getName());
            if (array) {
                buf.append(';');
            }
        }
        return buf.toString();
    }

    public static String getTypeDescription(ClassNode c) {
        StringBuffer buf = new StringBuffer();
        ClassNode d = c;
        while (true) {
            if (ClassHelper.isPrimitiveType(d)) {
                int car = d == ClassHelper.int_TYPE ? 73 : (d == ClassHelper.VOID_TYPE ? 86 : (d == ClassHelper.boolean_TYPE ? 90 : (d == ClassHelper.byte_TYPE ? 66 : (d == ClassHelper.char_TYPE ? 67 : (d == ClassHelper.short_TYPE ? 83 : (d == ClassHelper.double_TYPE ? 68 : (d == ClassHelper.float_TYPE ? 70 : 74)))))));
                buf.append((char)car);
                return buf.toString();
            }
            if (!d.isArray()) break;
            buf.append('[');
            d = d.getComponentType();
        }
        buf.append('L');
        String name = d.getName();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char car = name.charAt(i);
            buf.append(car == '.' ? (char)'/' : (char)car);
        }
        buf.append(';');
        return buf.toString();
    }

    public static String[] getClassInternalNames(ClassNode[] names) {
        int size = names.length;
        String[] answer = new String[size];
        for (int i = 0; i < size; ++i) {
            answer[i] = BytecodeHelper.getClassInternalName(names[i]);
        }
        return answer;
    }

    protected void pushConstant(boolean value) {
        if (value) {
            this.cv.visitInsn(4);
        } else {
            this.cv.visitInsn(3);
        }
    }

    protected void pushConstant(int value) {
        switch (value) {
            case 0: {
                this.cv.visitInsn(3);
                break;
            }
            case 1: {
                this.cv.visitInsn(4);
                break;
            }
            case 2: {
                this.cv.visitInsn(5);
                break;
            }
            case 3: {
                this.cv.visitInsn(6);
                break;
            }
            case 4: {
                this.cv.visitInsn(7);
                break;
            }
            case 5: {
                this.cv.visitInsn(8);
                break;
            }
            default: {
                if (value >= -128 && value <= 127) {
                    this.cv.visitIntInsn(16, value);
                    break;
                }
                if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
                    this.cv.visitIntInsn(17, value);
                    break;
                }
                this.cv.visitLdcInsn(new Integer(value));
            }
        }
    }

    public void doCast(Class type) {
        if (type != Object.class) {
            if (type.isPrimitive() && type != Void.TYPE) {
                this.unbox(type);
            } else {
                this.cv.visitTypeInsn(192, type.isArray() ? BytecodeHelper.getTypeDescription(type) : BytecodeHelper.getClassInternalName(type.getName()));
            }
        }
    }

    public void doCast(ClassNode type) {
        if (type == ClassHelper.OBJECT_TYPE) {
            return;
        }
        if (ClassHelper.isPrimitiveType(type) && type != ClassHelper.VOID_TYPE) {
            this.unbox(type);
        } else {
            this.cv.visitTypeInsn(192, type.isArray() ? BytecodeHelper.getTypeDescription(type) : BytecodeHelper.getClassInternalName(type));
        }
    }

    public void load(ClassNode type, int idx) {
        if (type == ClassHelper.double_TYPE) {
            this.cv.visitVarInsn(24, idx);
        } else if (type == ClassHelper.float_TYPE) {
            this.cv.visitVarInsn(23, idx);
        } else if (type == ClassHelper.long_TYPE) {
            this.cv.visitVarInsn(22, idx);
        } else if (type == ClassHelper.boolean_TYPE || type == ClassHelper.char_TYPE || type == ClassHelper.byte_TYPE || type == ClassHelper.int_TYPE || type == ClassHelper.short_TYPE) {
            this.cv.visitVarInsn(21, idx);
        } else {
            this.cv.visitVarInsn(25, idx);
        }
    }

    public void load(Variable v) {
        this.load(v.getType(), v.getIndex());
    }

    public void store(Variable v, boolean markStart) {
        ClassNode type = v.getType();
        this.unbox(type);
        int idx = v.getIndex();
        if (type == ClassHelper.double_TYPE) {
            this.cv.visitVarInsn(57, idx);
        } else if (type == ClassHelper.float_TYPE) {
            this.cv.visitVarInsn(56, idx);
        } else if (type == ClassHelper.long_TYPE) {
            this.cv.visitVarInsn(55, idx);
        } else if (type == ClassHelper.boolean_TYPE || type == ClassHelper.char_TYPE || type == ClassHelper.byte_TYPE || type == ClassHelper.int_TYPE || type == ClassHelper.short_TYPE) {
            this.cv.visitVarInsn(54, idx);
        } else {
            this.cv.visitVarInsn(58, idx);
        }
    }

    public void store(Variable v) {
        this.store(v, false);
    }

    void loadConstant(Object value) {
        if (value == null) {
            this.cv.visitInsn(1);
        } else if (value instanceof String) {
            this.cv.visitLdcInsn(value);
        } else if (value instanceof Character) {
            String className = "java/lang/Character";
            this.cv.visitTypeInsn(187, className);
            this.cv.visitInsn(89);
            this.cv.visitLdcInsn(value);
            String methodType = "(C)V";
            this.cv.visitMethodInsn(183, className, "<init>", methodType);
        } else if (value instanceof Number) {
            String methodType;
            Number n = (Number)value;
            String className = BytecodeHelper.getClassInternalName(value.getClass().getName());
            this.cv.visitTypeInsn(187, className);
            this.cv.visitInsn(89);
            if (n instanceof Integer) {
                this.cv.visitLdcInsn(n);
                methodType = "(I)V";
            } else if (n instanceof Double) {
                this.cv.visitLdcInsn(n);
                methodType = "(D)V";
            } else if (n instanceof Float) {
                this.cv.visitLdcInsn(n);
                methodType = "(F)V";
            } else if (n instanceof Long) {
                this.cv.visitLdcInsn(n);
                methodType = "(J)V";
            } else if (n instanceof BigDecimal) {
                this.cv.visitLdcInsn(n.toString());
                methodType = "(Ljava/lang/String;)V";
            } else if (n instanceof BigInteger) {
                this.cv.visitLdcInsn(n.toString());
                methodType = "(Ljava/lang/String;)V";
            } else if (n instanceof Short) {
                this.cv.visitLdcInsn(n);
                methodType = "(S)V";
            } else if (n instanceof Byte) {
                this.cv.visitLdcInsn(n);
                methodType = "(B)V";
            } else {
                throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName() + ".  Numeric constant type not supported.");
            }
            this.cv.visitMethodInsn(183, className, "<init>", methodType);
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            String text = bool != false ? "TRUE" : "FALSE";
            this.cv.visitFieldInsn(178, "java/lang/Boolean", text, "Ljava/lang/Boolean;");
        } else if (value instanceof Class) {
            Class vc = (Class)value;
            if (!vc.getName().equals("java.lang.Void")) {
                throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName());
            }
        } else {
            throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + value.getClass().getName());
        }
    }

    public void loadVar(Variable variable) {
        int index = variable.getIndex();
        if (variable.isHolder()) {
            this.cv.visitVarInsn(25, index);
            this.cv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
        } else {
            this.load(variable);
            if (variable != Variable.THIS_VARIABLE && variable != Variable.SUPER_VARIABLE) {
                this.box(variable.getType());
            }
        }
    }

    public void storeVar(Variable variable) {
        String type = variable.getTypeName();
        int index = variable.getIndex();
        if (variable.isHolder()) {
            this.cv.visitVarInsn(25, index);
            this.cv.visitInsn(95);
            this.cv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
        } else {
            this.store(variable, false);
        }
    }

    public void putField(FieldNode fld) {
        this.putField(fld, BytecodeHelper.getClassInternalName(fld.getOwner()));
    }

    public void putField(FieldNode fld, String ownerName) {
        this.cv.visitFieldInsn(181, ownerName, fld.getName(), BytecodeHelper.getTypeDescription(fld.getType()));
    }

    public void loadThis() {
        this.cv.visitVarInsn(25, 0);
    }

    public void swapObjectWith(ClassNode type) {
        if (type == ClassHelper.long_TYPE || type == ClassHelper.double_TYPE) {
            this.cv.visitInsn(91);
            this.cv.visitInsn(87);
        } else {
            this.cv.visitInsn(95);
        }
    }

    public static ClassNode boxOnPrimitive(ClassNode type) {
        if (!type.isArray()) {
            return ClassHelper.getWrapper(type);
        }
        return BytecodeHelper.boxOnPrimitive(type.getComponentType()).makeArray();
    }

    public void boxBoolean() {
        Label l0 = new Label();
        this.cv.visitJumpInsn(153, l0);
        this.cv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        Label l1 = new Label();
        this.cv.visitJumpInsn(167, l1);
        this.cv.visitLabel(l0);
        this.cv.visitFieldInsn(178, "java/lang/Boolean", "FALSE", "Ljava/lang/Boolean;");
        this.cv.visitLabel(l1);
    }

    public void mark(String msg) {
        this.cv.visitLdcInsn(msg);
        this.cv.visitInsn(87);
    }

    public static String formatNameForClassLoading(String name) {
        if (name.equals("int") || name.equals("long") || name.equals("short") || name.equals("float") || name.equals("double") || name.equals("byte") || name.equals("char") || name.equals("boolean") || name.equals("void")) {
            return name;
        }
        if (name == null) {
            return "java.lang.Object;";
        }
        if (name.startsWith("[")) {
            return name.replace('/', '.');
        }
        if (name.startsWith("L")) {
            if ((name = name.substring(1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name.replace('/', '.');
        }
        String prefix = "";
        if (name.endsWith("[]")) {
            prefix = "[";
            if ((name = name.substring(0, name.length() - 2)).equals("int")) {
                return prefix + "I";
            }
            if (name.equals("long")) {
                return prefix + "J";
            }
            if (name.equals("short")) {
                return prefix + "S";
            }
            if (name.equals("float")) {
                return prefix + "F";
            }
            if (name.equals("double")) {
                return prefix + "D";
            }
            if (name.equals("byte")) {
                return prefix + "B";
            }
            if (name.equals("char")) {
                return prefix + "C";
            }
            if (name.equals("boolean")) {
                return prefix + "Z";
            }
            return prefix + "L" + name.replace('/', '.') + ";";
        }
        return name.replace('/', '.');
    }

    public void dup() {
        this.cv.visitInsn(89);
    }
}

