/*
 * #%L
 * Vradi :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 JurisMarches, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package com.jurismarches.vradi.ui.search;

import com.jurismarches.vradi.VradiContext;
import com.jurismarches.vradi.entities.*;
import com.jurismarches.vradi.ui.helpers.UIHelper;
import com.jurismarches.vradi.ui.search.*;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.swing.*;
import jaxx.runtime.swing.editor.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.widget.tooltip.FocusableTip;
import org.nuiton.wikitty.entities.BusinessEntity;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static jaxx.runtime.validator.BeanValidatorUtil.convert;
import static org.nuiton.i18n.I18n._;
import static org.nuiton.i18n.I18n.n_;

public class MultipleSelectionEditor<B extends BusinessEntity> extends javax.swing.JLabel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN_CLASS = "beanClass";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJVSsW4TQRAdn2MbO0CAiCgoQQrQr1uQEQQFrIAcIuEm4hrW3lVurfXesrsXjgbxCXwC9DRIdFSIgpqCBvELCFHQImbXjs+BQ4CLszSz8+bNe+/lF6hZAxdGNM+JyZQTY07u3Njb2x2M+NDd5HZohHapgcmvEkEUwyKb1a2DS3HPj7en4+2tdKxTxdXcdKcHLeseS24Tzp2D80cnhta2+7N2J9eZOUSdkSpDff7ta/SMPX0RAeQa2VXxlI2/TRWXLPQgEszBGdx0QNuSqn2kYYTaR74nfG1LUmvv0jF/CE+g0YO6pgbBHFz895MDRpjPtYOqHEgHl4fpmIwyI+yYmmHCLTkwlAmSCWK5r5CdTDqhJe9ziT6IVN1iAlG1DlB1B80BpypgO1jyXInnT0KleNVIqGKSGwdX/n/l9mQW0QysHZEVDSOFYYWilRhqJsOyg9X4d4/vYWvi7uov7nrA0P2xsvzxzefX3UNLK7j7bOnTuUSi1NqkGs8UfvXSxM/MCdneoboTQ9OGm0Jc10uI9adtJIf7Tgc5/TjZpjZBiFrj09t3Kw8+VCHqQkumlHWpf38bmi4xqEIqWa6vbwZGxx8dw+8pz83BguM55uXkVUYd3RgIxTBe13KUYL1EghmPQfP99+X+q815Gc798XkhRe0+1IWSQvGQ7WlsS7O8qC3PWFrEsyywFf/f0lr/BHYSk20pBAAA";
    private static final Log log = LogFactory.getLog(com.jurismarches.vradi.ui.search.MultipleSelectionEditor.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Class beanClass;
    protected com.jurismarches.vradi.ui.search.MultipleSelectionHandler< B > handler;
    protected MultipleSelectionEditor lbl = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<B> allValues;
    protected java.util.List<B> selectedValues;
    protected FocusableTip focusableTip;
    
    
    @Override
    public String getToolTipText(MouseEvent event) {
        super.getToolTipText(event);
    
        // display it into persistant tooltip
        if (focusableTip == null) {
            jaxx.runtime.JAXXUtil.assignment(focusableTip = new FocusableTip(this, true), "focusableTip", com.jurismarches.vradi.ui.search.MultipleSelectionEditor.this);
        }
        focusableTip.toolTipRequested(event, handler.getPopupUI());
    
        return null;
    }
    
    void $afterCompleteSetup() {
        jaxx.runtime.JAXXUtil.assignment(selectedValues = new ArrayList<B>(), "selectedValues", com.jurismarches.vradi.ui.search.MultipleSelectionEditor.this);
        setToolTipText(FocusableTip.DUMMY_TOOL_TIP);
    }
    
    public void setHandler(com.jurismarches.vradi.ui.search.MultipleSelectionHandler handler) {
        this.handler = handler;
    }
    
    public java.util.List<B> getAllValues() {
        return allValues;
    }
    
    public void setAllValues(java.util.List<B> allValues) {
        this.allValues = allValues;
    }
    
    public java.util.List<B> getSelectedValues() {
        return selectedValues;
    }
    
    public void setSelectedValues(java.util.List<B> selectedValues) {
        this.selectedValues = selectedValues;
    }
    
    public void addSelectedValue(B selected) {
        selectedValues.add(selected);
        lbl.setText(handler.getValuesAsString(selectedValues));
    }
    
    public void removeSelectedValue(B unselected) {
        selectedValues.remove(unselected);
        lbl.setText(handler.getValuesAsString(selectedValues));
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public MultipleSelectionEditor() {
        $initialize();
    }

    public MultipleSelectionEditor(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Class getBeanClass() {
        return beanClass;
    }

    public com.jurismarches.vradi.ui.search.MultipleSelectionHandler< B > getHandler() {
        return handler;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBeanClass(java.lang.Class newValue) {
        java.lang.Class oldValue = this.beanClass;
        this.beanClass = newValue;
        firePropertyChange(PROPERTY_BEAN_CLASS, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createBeanClass() {
        $objectMap.put("beanClass", beanClass = null);
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new com.jurismarches.vradi.ui.search.MultipleSelectionHandler< B >(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        // apply 1 property setters
        setText(_(handler.getValuesAsString(getSelectedValues())));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("lbl", this);
        createBeanClass();
        createHandler();
        // inline creation of lbl
        setName("lbl");
        
        $completeSetup();
    }

}